/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.coreservice.api.parameter;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.coreservice.api.parameter.EvaluationOperator;
import org.kuali.rice.coreservice.api.parameter.ParameterContract;
import org.kuali.rice.coreservice.api.parameter.ParameterKey;
import org.kuali.rice.coreservice.api.parameter.ParameterType;
import org.w3c.dom.Element;

@XmlRootElement(name="parameter")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="ParameterType", propOrder={"applicationId", "namespaceCode", "componentCode", "name", "value", "description", "parameterType", "evaluationOperator", "versionNumber", "objectId", "_futureElements"})
public final class Parameter
extends AbstractDataTransferObject
implements ParameterContract {
    private static final long serialVersionUID = 6097498602725305353L;
    @XmlElement(name="applicationId", required=true)
    private final String applicationId;
    @XmlElement(name="namespaceCode", required=true)
    private final String namespaceCode;
    @XmlElement(name="componentCode", required=true)
    private final String componentCode;
    @XmlElement(name="name", required=true)
    private final String name;
    @XmlElement(name="value", required=false)
    private final String value;
    @XmlElement(name="description", required=false)
    private final String description;
    @XmlElement(name="parameterType", required=true)
    private final ParameterType parameterType;
    @XmlJavaTypeAdapter(value=EvaluationOperator.Adapter.class)
    @XmlElement(name="evaluationOperator", required=false)
    private final String evaluationOperator;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlElement(name="objectId", required=false)
    private final String objectId;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private Parameter() {
        this.applicationId = null;
        this.namespaceCode = null;
        this.componentCode = null;
        this.name = null;
        this.value = null;
        this.description = null;
        this.parameterType = null;
        this.evaluationOperator = null;
        this.versionNumber = null;
        this.objectId = null;
    }

    private Parameter(Builder builder) {
        this.applicationId = builder.getApplicationId();
        this.namespaceCode = builder.getNamespaceCode();
        this.componentCode = builder.getComponentCode();
        this.name = builder.getName();
        this.value = builder.getValue();
        this.description = builder.getDescription();
        this.parameterType = builder.parameterType.build();
        EvaluationOperator evaluationOperatorEnum = builder.getEvaluationOperator();
        this.evaluationOperator = evaluationOperatorEnum == null ? null : evaluationOperatorEnum.getCode();
        this.versionNumber = builder.getVersionNumber();
        this.objectId = builder.getObjectId();
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    public String getNamespaceCode() {
        return this.namespaceCode;
    }

    @Override
    public String getComponentCode() {
        return this.componentCode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public ParameterType getParameterType() {
        return this.parameterType;
    }

    @Override
    public EvaluationOperator getEvaluationOperator() {
        return EvaluationOperator.fromCode(this.evaluationOperator);
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public ParameterKey getParameterKey() {
        return ParameterKey.create(this.applicationId, this.namespaceCode, this.componentCode, this.name);
    }

    public static final class Builder
    implements ParameterContract,
    ModelBuilder,
    Serializable {
        private static final long serialVersionUID = 7077484401017765844L;
        private String applicationId;
        private String namespaceCode;
        private String componentCode;
        private String name;
        private String value;
        private String description;
        private ParameterType.Builder parameterType;
        private EvaluationOperator evaluationOperator;
        private Long versionNumber;
        private String objectId;

        private Builder(String applicationId, String namespaceCode, String componentCode, String name, ParameterType.Builder parameterType) {
            this.setApplicationId(applicationId);
            this.setNamespaceCode(namespaceCode);
            this.setComponentCode(componentCode);
            this.setName(name);
            this.setParameterType(parameterType);
        }

        public static Builder create(String applicationId, String namespaceCode, String componentCode, String name, ParameterType.Builder parameterType) {
            return new Builder(applicationId, namespaceCode, componentCode, name, parameterType);
        }

        public static Builder create(ParameterContract contract) {
            Builder builder = new Builder(contract.getApplicationId(), contract.getNamespaceCode(), contract.getComponentCode(), contract.getName(), ParameterType.Builder.create(contract.getParameterType()));
            builder.setValue(contract.getValue());
            builder.setDescription(contract.getDescription());
            builder.setEvaluationOperator(contract.getEvaluationOperator());
            builder.setVersionNumber(contract.getVersionNumber());
            builder.setObjectId(contract.getObjectId());
            return builder;
        }

        public void setApplicationId(String applicationId) {
            if (StringUtils.isBlank((String)applicationId)) {
                throw new IllegalArgumentException("applicationId is blank");
            }
            this.applicationId = applicationId;
        }

        public void setNamespaceCode(String namespaceCode) {
            if (StringUtils.isBlank((String)namespaceCode)) {
                throw new IllegalArgumentException("namespaceCode is blank");
            }
            this.namespaceCode = namespaceCode;
        }

        public void setComponentCode(String componentCode) {
            if (StringUtils.isBlank((String)componentCode)) {
                throw new IllegalArgumentException("componentCode is blank");
            }
            this.componentCode = componentCode;
        }

        public void setName(String name) {
            if (StringUtils.isBlank((String)name)) {
                throw new IllegalArgumentException("name is blank");
            }
            this.name = name;
        }

        public void setParameterType(ParameterType.Builder parameterType) {
            if (parameterType == null) {
                throw new IllegalArgumentException("parameterType is null");
            }
            this.parameterType = parameterType;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setEvaluationOperator(EvaluationOperator evaluationOperator) {
            this.evaluationOperator = evaluationOperator;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public void setObjectId(String objectId) {
            this.objectId = objectId;
        }

        @Override
        public String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public String getNamespaceCode() {
            return this.namespaceCode;
        }

        @Override
        public String getComponentCode() {
            return this.componentCode;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public EvaluationOperator getEvaluationOperator() {
            return this.evaluationOperator;
        }

        public Parameter build() {
            return new Parameter(this);
        }

        @Override
        public ParameterType.Builder getParameterType() {
            return this.parameterType;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public String getObjectId() {
            return this.objectId;
        }
    }

    public static class Cache {
        public static final String NAME = "http://rice.kuali.org/core/v2_0/ParameterType";
    }

    static class Elements {
        static final String APPLICATION_ID = "applicationId";
        static final String NAMESPACE_CODE = "namespaceCode";
        static final String COMPONENT_CODE = "componentCode";
        static final String NAME = "name";
        static final String VALUE = "value";
        static final String DESCRIPTION = "description";
        static final String PARAMETER_TYPE = "parameterType";
        static final String EVALUATION_OPERATOR = "evaluationOperator";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "parameter";
        static final String TYPE_NAME = "ParameterType";

        Constants() {
        }
    }
}

