/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.sourceforge.schemaspy.Config;
import net.sourceforge.schemaspy.DbAnalyzer;
import net.sourceforge.schemaspy.MultipleSchemaAnalyzer;
import net.sourceforge.schemaspy.TableOrderer;
import net.sourceforge.schemaspy.model.ConnectionFailure;
import net.sourceforge.schemaspy.model.ConsoleProgressListener;
import net.sourceforge.schemaspy.model.Database;
import net.sourceforge.schemaspy.model.EmptySchemaException;
import net.sourceforge.schemaspy.model.ForeignKeyConstraint;
import net.sourceforge.schemaspy.model.ImpliedForeignKeyConstraint;
import net.sourceforge.schemaspy.model.InvalidConfigurationException;
import net.sourceforge.schemaspy.model.ProgressListener;
import net.sourceforge.schemaspy.model.Table;
import net.sourceforge.schemaspy.model.TableColumn;
import net.sourceforge.schemaspy.model.xml.SchemaMeta;
import net.sourceforge.schemaspy.util.ConnectionURLBuilder;
import net.sourceforge.schemaspy.util.DOMUtil;
import net.sourceforge.schemaspy.util.DbSpecificOption;
import net.sourceforge.schemaspy.util.Dot;
import net.sourceforge.schemaspy.util.LineWriter;
import net.sourceforge.schemaspy.util.LogFormatter;
import net.sourceforge.schemaspy.util.ResourceWriter;
import net.sourceforge.schemaspy.view.DotFormatter;
import net.sourceforge.schemaspy.view.HtmlAnomaliesPage;
import net.sourceforge.schemaspy.view.HtmlColumnsPage;
import net.sourceforge.schemaspy.view.HtmlConstraintsPage;
import net.sourceforge.schemaspy.view.HtmlMainIndexPage;
import net.sourceforge.schemaspy.view.HtmlOrphansPage;
import net.sourceforge.schemaspy.view.HtmlRelationshipsPage;
import net.sourceforge.schemaspy.view.HtmlRoutinesPage;
import net.sourceforge.schemaspy.view.HtmlTablePage;
import net.sourceforge.schemaspy.view.ImageWriter;
import net.sourceforge.schemaspy.view.StyleSheet;
import net.sourceforge.schemaspy.view.TextFormatter;
import net.sourceforge.schemaspy.view.WriteStats;
import net.sourceforge.schemaspy.view.XmlTableFormatter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SchemaAnalyzer {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private boolean fineEnabled;

    public Database analyze(Config config) throws SQLException, IOException {
        boolean bl = config.isHtmlGenerationEnabled() && !this.fineEnabled;
        ConsoleProgressListener consoleProgressListener = new ConsoleProgressListener(bl);
        return this.analyze(config, consoleProgressListener);
    }

    public Database analyze(Config config, ProgressListener progressListener) throws SQLException, IOException {
        try {
            Object object;
            LineWriter lineWriter;
            Object object2;
            Serializable serializable;
            DocumentBuilder documentBuilder;
            SchemaMeta schemaMeta;
            CharSequence charSequence;
            if (config.isHelpRequired()) {
                config.dumpUsage(null, false);
                return null;
            }
            if (config.isDbHelpRequired()) {
                config.dumpUsage(null, true);
                return null;
            }
            Logger.getLogger("").setLevel(config.getLogLevel());
            for (Handler object42 : Logger.getLogger("").getHandlers()) {
                if (!(object42 instanceof ConsoleHandler)) continue;
                ((ConsoleHandler)object42).setFormatter(new LogFormatter());
                object42.setLevel(config.getLogLevel());
            }
            this.fineEnabled = this.logger.isLoggable(Level.FINE);
            this.logger.info("Starting schema analysis");
            File file = config.getOutputDir();
            if (!file.isDirectory() && !file.mkdirs()) {
                throw new IOException("Failed to create directory '" + String.valueOf(file) + "'");
            }
            List<String> list = config.getSchemas();
            if (list != null) {
                List<String> list2 = config.asList();
                list2.remove("-schemas");
                list2.remove("-schemata");
                String string = config.getDb();
                MultipleSchemaAnalyzer.getInstance().analyze(string, list, list2, config);
                return null;
            }
            Properties properties = config.determineDbProperties(config.getDbType());
            ConnectionURLBuilder connectionURLBuilder = new ConnectionURLBuilder(config, properties);
            if (config.getDb() == null) {
                config.setDb(connectionURLBuilder.getConnectionURL());
            }
            if (config.getRemainingParameters().size() != 0) {
                charSequence = new StringBuilder("Unrecognized option(s):");
                for (String string : config.getRemainingParameters()) {
                    ((StringBuilder)charSequence).append(" " + string);
                }
                this.logger.warning(((StringBuilder)charSequence).toString());
            }
            charSequence = properties.getProperty("driver");
            Object object3 = properties.getProperty("driverPath");
            if (object3 == null) {
                object3 = "";
            }
            if (config.getDriverPath() != null) {
                object3 = config.getDriverPath() + File.pathSeparator + (String)object3;
            }
            Connection connection = this.getConnection(config, connectionURLBuilder.getConnectionURL(), (String)charSequence, (String)object3);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String string = config.getDb();
            String string2 = config.getSchema();
            if (config.isEvaluateAllEnabled()) {
                List<String> list2 = config.asList();
                for (DbSpecificOption dbSpecificOption : connectionURLBuilder.getOptions()) {
                    if (list2.contains("-" + dbSpecificOption.getName())) continue;
                    list2.add("-" + dbSpecificOption.getName());
                    list2.add(dbSpecificOption.getValue().toString());
                }
                Object object4 = config.getSchemaSpec();
                if (object4 == null) {
                    object4 = properties.getProperty("schemaSpec", ".*");
                }
                MultipleSchemaAnalyzer.getInstance().analyze(string, databaseMetaData, (String)object4, null, list2, config);
                return null;
            }
            String string3 = config.getCatalog();
            this.logger.fine("supportsSchemasInTableDefinitions: " + databaseMetaData.supportsSchemasInTableDefinitions());
            this.logger.fine("supportsCatalogsInTableDefinitions: " + databaseMetaData.supportsCatalogsInTableDefinitions());
            if (string2 == null && databaseMetaData.supportsSchemasInTableDefinitions() && !config.isSchemaDisabled()) {
                string2 = config.getUser();
                this.logger.fine("schema not specified for a database that requires one.  using user: '" + string2 + "'");
                if (string2 == null) {
                    throw new InvalidConfigurationException("Either a schema ('-s') or a user ('-u') must be specified");
                }
                config.setSchema(string2);
            }
            if (string3 == null && string2 == null && databaseMetaData.supportsCatalogsInTableDefinitions()) {
                string3 = string;
                this.logger.fine("catalog not specified for a database that requires one.  using dbName: '" + string3 + "'");
                config.setCatalog(string3);
            }
            SchemaMeta schemaMeta2 = schemaMeta = config.getMeta() == null ? null : new SchemaMeta(config.getMeta(), string, string2);
            if (config.isHtmlGenerationEnabled()) {
                new File(file, "tables").mkdirs();
                new File(file, "diagrams/summary").mkdirs();
                this.logger.info("Connected to " + databaseMetaData.getDatabaseProductName() + " - " + databaseMetaData.getDatabaseProductVersion());
                if (schemaMeta != null && schemaMeta.getFile() != null) {
                    this.logger.info("Using additional metadata from " + String.valueOf(schemaMeta.getFile()));
                }
            }
            Database database = new Database(config, connection, databaseMetaData, string, string3, string2, schemaMeta, progressListener);
            long l = progressListener.startedGraphingSummaries();
            schemaMeta = null;
            ArrayList<Table> arrayList = new ArrayList<Table>(database.getTables());
            arrayList.addAll(database.getViews());
            if (arrayList.isEmpty()) {
                SchemaAnalyzer.dumpNoTablesMessage(string2, config.getUser(), databaseMetaData, config.getTableInclusions() != null);
                if (!config.isOneOfMultipleSchemas()) {
                    throw new EmptySchemaException();
                }
            }
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            try {
                documentBuilder = documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new RuntimeException(parserConfigurationException);
            }
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("database");
            document.appendChild(element);
            DOMUtil.appendAttribute(element, "name", string);
            if (string2 != null) {
                DOMUtil.appendAttribute(element, "schema", string2);
            }
            DOMUtil.appendAttribute(element, "type", database.getDatabaseProduct());
            if (config.isHtmlGenerationEnabled()) {
                this.logger.info("Gathered schema details in " + l / 1000L + " seconds");
                this.logger.info("Writing/graphing summary");
                ImageWriter.getInstance().writeImages(file);
                ResourceWriter.getInstance().writeResource("/jquery.js", new File(file, "/jquery.js"));
                ResourceWriter.getInstance().writeResource("/schemaSpy.js", new File(file, "/schemaSpy.js"));
                progressListener.graphingSummaryProgressed();
                boolean bl = arrayList.size() <= config.getMaxDetailedTables();
                boolean bl2 = config.isImpliedConstraintsEnabled();
                if (config.isRailsEnabled()) {
                    DbAnalyzer.getRailsConstraints(database.getTablesByName());
                }
                serializable = new File(file, "diagrams/summary");
                object2 = "relationships";
                lineWriter = new LineWriter(new File((File)serializable, (String)object2 + ".real.compact.dot"), "UTF-8");
                object = new WriteStats(arrayList);
                DotFormatter.getInstance().writeRealRelationships(database, arrayList, true, bl, (WriteStats)object, lineWriter);
                boolean bl3 = ((WriteStats)object).getNumTablesWritten() > 0 || ((WriteStats)object).getNumViewsWritten() > 0;
                lineWriter.close();
                if (bl3) {
                    progressListener.graphingSummaryProgressed();
                    lineWriter = new LineWriter(new File((File)serializable, (String)object2 + ".real.large.dot"), "UTF-8");
                    DotFormatter.getInstance().writeRealRelationships(database, arrayList, false, bl, (WriteStats)object, lineWriter);
                    lineWriter.close();
                }
                List<ImpliedForeignKeyConstraint> list3 = null;
                list3 = bl2 ? DbAnalyzer.getImpliedConstraints(arrayList) : new ArrayList<ImpliedForeignKeyConstraint>();
                List<Table> list4 = DbAnalyzer.getOrphans(arrayList);
                config.setHasOrphans(!list4.isEmpty() && Dot.getInstance().isValid());
                config.setHasRoutines(!database.getRoutines().isEmpty());
                progressListener.graphingSummaryProgressed();
                File file2 = new File((File)serializable, (String)object2 + ".implied.compact.dot");
                lineWriter = new LineWriter(file2, "UTF-8");
                boolean bl4 = DotFormatter.getInstance().writeAllRelationships(database, arrayList, true, bl, (WriteStats)object, lineWriter);
                Set<TableColumn> set = ((WriteStats)object).getExcludedColumns();
                lineWriter.close();
                if (bl4) {
                    file2 = new File((File)serializable, (String)object2 + ".implied.large.dot");
                    lineWriter = new LineWriter(file2, "UTF-8");
                    DotFormatter.getInstance().writeAllRelationships(database, arrayList, false, bl, (WriteStats)object, lineWriter);
                    lineWriter.close();
                } else {
                    file2.delete();
                }
                lineWriter = new LineWriter(new File(file, (String)object2 + ".html"), config.getCharset());
                HtmlRelationshipsPage.getInstance().write(database, (File)serializable, (String)object2, bl3, bl4, set, progressListener, lineWriter);
                lineWriter.close();
                progressListener.graphingSummaryProgressed();
                object2 = "utilities";
                File file3 = new File(file, "diagrams/orphans");
                file3.mkdirs();
                lineWriter = new LineWriter(new File(file, (String)object2 + ".html"), config.getCharset());
                HtmlOrphansPage.getInstance().write(database, list4, file3, lineWriter);
                list4 = null;
                lineWriter.close();
                progressListener.graphingSummaryProgressed();
                lineWriter = new LineWriter(new File(file, "index.html"), 65536, config.getCharset());
                HtmlMainIndexPage.getInstance().write(database, arrayList, database.getRemoteTables(), lineWriter);
                lineWriter.close();
                progressListener.graphingSummaryProgressed();
                List<ForeignKeyConstraint> list5 = DbAnalyzer.getForeignKeyConstraints(arrayList);
                lineWriter = new LineWriter(new File(file, "constraints.html"), 262144, config.getCharset());
                HtmlConstraintsPage htmlConstraintsPage = HtmlConstraintsPage.getInstance();
                htmlConstraintsPage.write(database, list5, arrayList, lineWriter);
                lineWriter.close();
                progressListener.graphingSummaryProgressed();
                lineWriter = new LineWriter(new File(file, "anomalies.html"), 16384, config.getCharset());
                HtmlAnomaliesPage.getInstance().write(database, arrayList, list3, lineWriter);
                lineWriter.close();
                progressListener.graphingSummaryProgressed();
                for (HtmlColumnsPage.ColumnInfo columnInfo : HtmlColumnsPage.getInstance().getColumnInfos().values()) {
                    lineWriter = new LineWriter(new File(file, columnInfo.getLocation()), 16384, config.getCharset());
                    HtmlColumnsPage.getInstance().write(database, arrayList, columnInfo, lineWriter);
                    lineWriter.close();
                }
                progressListener.graphingSummaryProgressed();
                lineWriter = new LineWriter(new File(file, "routines.html"), 16384, config.getCharset());
                HtmlRoutinesPage.getInstance().write(database, lineWriter);
                lineWriter.close();
                l = progressListener.startedGraphingDetails();
                this.logger.info("Completed summary in " + l / 1000L + " seconds");
                this.logger.info("Writing/diagramming details");
                HtmlTablePage htmlTablePage = HtmlTablePage.getInstance();
                for (Table table : arrayList) {
                    progressListener.graphingDetailsProgressed(table);
                    if (this.fineEnabled) {
                        this.logger.fine("Writing details of " + table.getName());
                    }
                    lineWriter = new LineWriter(new File(file, "tables/" + table.getName() + ".html"), 24576, config.getCharset());
                    htmlTablePage.write(database, table, file, (WriteStats)object, lineWriter);
                    lineWriter.close();
                }
                lineWriter = new LineWriter(new File(file, "schemaSpy.css"), config.getCharset());
                StyleSheet.getInstance().write(lineWriter);
                lineWriter.close();
            }
            XmlTableFormatter.getInstance().appendTables(element, arrayList);
            Object object5 = string;
            object5 = new File((String)object5).getName();
            String[] stringArray = ((String)object5).split("[:@]");
            object5 = stringArray[stringArray.length - 1];
            if (string2 != null) {
                object5 = (String)object5 + "." + string2;
            }
            lineWriter = new LineWriter(new File(file, (String)object5 + ".xml"), "UTF-8");
            document.getDocumentElement().normalize();
            try {
                DOMUtil.printDOM(document, lineWriter);
            }
            catch (TransformerException transformerException) {
                throw new IOException(transformerException);
            }
            lineWriter.close();
            documentBuilder = null;
            Object var9_18 = null;
            document = null;
            documentBuilderFactory = null;
            databaseMetaData = null;
            properties = null;
            element = null;
            Object var6_13 = null;
            serializable = new ArrayList();
            object2 = new TableOrderer();
            object = ((TableOrderer)object2).getTablesOrderedByRI(database.getTables(), (Collection<ForeignKeyConstraint>)((Object)serializable));
            lineWriter = new LineWriter(new File(file, "insertionOrder.txt"), 16384, "UTF-8");
            TextFormatter.getInstance().write((Collection<Table>)object, false, lineWriter);
            lineWriter.close();
            lineWriter = new LineWriter(new File(file, "deletionOrder.txt"), 16384, "UTF-8");
            Collections.reverse(object);
            TextFormatter.getInstance().write((Collection<Table>)object, false, lineWriter);
            lineWriter.close();
            l = progressListener.finishedGatheringDetails();
            long l2 = progressListener.finished(arrayList, config);
            if (config.isHtmlGenerationEnabled()) {
                this.logger.info("Wrote table details in " + l / 1000L + " seconds");
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.info("Wrote relationship details of " + arrayList.size() + " tables/views to directory '" + String.valueOf(config.getOutputDir()) + "' in " + l2 / 1000L + " seconds.");
                    this.logger.info("View the results by opening " + String.valueOf(new File(config.getOutputDir(), "index.html")));
                }
            }
            return database;
        }
        catch (Config.MissingRequiredParameterException missingRequiredParameterException) {
            config.dumpUsage(missingRequiredParameterException.getMessage(), missingRequiredParameterException.isDbTypeSpecific());
            return null;
        }
    }

    private static void dumpNoTablesMessage(String string, String string2, DatabaseMetaData databaseMetaData, boolean bl) throws SQLException {
        System.out.println();
        System.out.println();
        System.out.println("No tables or views were found in schema '" + string + "'.");
        List<String> list = null;
        Exception exception = null;
        try {
            list = DbAnalyzer.getSchemas(databaseMetaData);
        }
        catch (SQLException sQLException) {
            exception = sQLException;
        }
        catch (RuntimeException runtimeException) {
            exception = runtimeException;
        }
        if (list == null) {
            System.out.println("The user you specified (" + string2 + ")");
            System.out.println("  might not have rights to read the database metadata.");
            System.out.flush();
            if (exception != null) {
                exception.printStackTrace();
            }
            return;
        }
        if (string == null || list.contains(string)) {
            System.out.println("The schema exists in the database, but the user you specified (" + string2 + ")");
            System.out.println("  might not have rights to read its contents.");
            if (bl) {
                System.out.println("Another possibility is that the regular expression that you specified");
                System.out.println("  for what to include (via -i) didn't match any tables.");
            }
        } else {
            System.out.println("The schema does not exist in the database.");
            System.out.println("Make sure that you specify a valid schema with the -s option and that");
            System.out.println("  the user specified (" + string2 + ") can read from the schema.");
            System.out.println("Note that schema names are usually case sensitive.");
        }
        System.out.println();
        boolean bl2 = list.size() != 1;
        System.out.println(list.size() + " schema" + (bl2 ? "s" : "") + " exist" + (bl2 ? "" : "s") + " in this database.");
        System.out.println("Some of these \"schemas\" may be users or system schemas.");
        System.out.println();
        for (String object : list) {
            System.out.print(object + " ");
        }
        System.out.println();
        List<String> list2 = DbAnalyzer.getPopulatedSchemas(databaseMetaData);
        if (list2.isEmpty()) {
            System.out.println("Unable to determine if any of the schemas contain tables/views");
        } else {
            System.out.println("These schemas contain tables/views that user '" + string2 + "' can see:");
            System.out.println();
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                System.out.print(" " + string3);
            }
        }
    }

    protected Connection getConnection(Config config, String string, String string2, String string3) throws FileNotFoundException, IOException {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("Using database properties:");
            this.logger.info("  " + config.getDbPropertiesLoadedFrom());
        } else {
            System.out.println("Using database properties:");
            System.out.println("  " + config.getDbPropertiesLoadedFrom());
        }
        Driver driver = this.getDriver(string2, string3);
        Properties properties = config.getConnectionProperties();
        if (config.getUser() != null) {
            properties.put("user", config.getUser());
        }
        if (config.getPassword() != null) {
            properties.put("password", config.getPassword());
        }
        Connection connection = null;
        try {
            connection = driver.connect(string, properties);
            if (connection == null) {
                System.err.println();
                System.err.println("Cannot connect to this database URL:");
                System.err.println("  " + string);
                System.err.println("with this driver:");
                System.err.println("  " + string2);
                System.err.println();
                System.err.println("Additional connection information may be available in ");
                System.err.println("  " + config.getDbPropertiesLoadedFrom());
                throw new ConnectionFailure("Cannot connect to '" + string + "' with driver '" + string2 + "'");
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println();
            System.err.println("Failed to load driver [" + string2 + "] from classpath " + String.valueOf(this.getExistingUrls(string3)));
            System.err.println();
            System.err.println("Make sure the reported library (.dll/.lib/.so) from the following line can be");
            System.err.println("found by your PATH (or LIB*PATH) environment variable");
            System.err.println();
            unsatisfiedLinkError.printStackTrace();
            throw new ConnectionFailure(unsatisfiedLinkError);
        }
        catch (Exception exception) {
            System.err.println();
            System.err.println("Failed to connect to database URL [" + string + "]");
            System.err.println();
            exception.printStackTrace();
            throw new ConnectionFailure(exception);
        }
        return connection;
    }

    protected Driver getDriver(String string, String string2) throws MalformedURLException {
        List<URL> list = this.getExistingUrls(string2);
        ClassLoader classLoader = this.getDriverClassLoader(list);
        Driver driver = null;
        try {
            driver = (Driver)Class.forName(string, true, classLoader).newInstance();
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.err.println();
            System.err.print("Failed to load driver '" + string + "'");
            if (list.isEmpty()) {
                System.err.println();
            } else {
                System.err.println(" from: " + String.valueOf(list));
            }
            List<File> list2 = this.getMissingFiles(string2);
            if (!list2.isEmpty()) {
                if (list2.size() == 1) {
                    System.err.print("This entry doesn't point to a valid file/directory: ");
                } else {
                    System.err.print("These entries don't point to valid files/directories: ");
                }
                System.err.println(list2);
            }
            System.err.println();
            System.err.println("Use the -dp option to specify the location of the database");
            System.err.println("drivers for your database (usually in a .jar or .zip/.Z).");
            System.err.println();
            throw new ConnectionFailure(exception);
        }
        return driver;
    }

    protected ClassLoader getDriverClassLoader(List<URL> list) {
        ClassLoader classLoader = null;
        classLoader = list.size() > 0 ? new URLClassLoader(list.toArray(new URL[list.size()])) : this.getClass().getClassLoader();
        return classLoader;
    }

    protected List<URL> getExistingUrls(String string) throws MalformedURLException {
        String[] stringArray;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (String string2 : stringArray = string.split(File.pathSeparator)) {
            File file = new File(string2);
            if (!file.exists()) continue;
            arrayList.add(file.toURI().toURL());
        }
        return arrayList;
    }

    protected List<File> getMissingFiles(String string) {
        String[] stringArray;
        ArrayList<File> arrayList = new ArrayList<File>();
        for (String string2 : stringArray = string.split(File.pathSeparator)) {
            File file = new File(string2);
            if (file.exists()) continue;
            arrayList.add(file);
        }
        return arrayList;
    }

    static void yankParam(List<String> list, String string) {
        int n = list.indexOf(string);
        if (n >= 0) {
            list.remove(n);
            list.remove(n);
        }
    }
}

