/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.contacts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.rolodex.NonOrganizationalRolodex;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.unit.UnitContactType;
import org.kuali.coeus.common.framework.unit.admin.AbstractUnitAdministrator;
import org.kuali.coeus.common.framework.unit.admin.UnitAdministrator;
import org.kuali.coeus.common.framework.unit.admin.UnitAdministratorType;
import org.kuali.kra.award.home.ContactRole;
import org.kuali.kra.award.home.ContactType;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalContact;

public class InstitutionalProposalUnitContact
extends InstitutionalProposalContact
implements AbstractUnitAdministrator {
    private static final long serialVersionUID = -4018882949510183728L;
    public static final String OSP_ADMINISTRATOR = "OSP_ADMINISTRATOR";
    private static final String UNIT_ADMINISTRATOR_TYPE_CODE = "UNIT_ADMINISTRATOR_TYPE_CODE";
    private static final String CONTACT_TYPE_CODE = "CONTACT_TYPE_CODE";
    private UnitContactType unitContactType;
    private UnitAdministratorType unitAdministratorType;
    private String unitAdministratorTypeCode;

    public InstitutionalProposalUnitContact() {
    }

    public InstitutionalProposalUnitContact(NonOrganizationalRolodex rolodex, ContactRole role, UnitContactType unitContactType) {
        super(rolodex, role);
        this.unitContactType = unitContactType;
    }

    public InstitutionalProposalUnitContact(KcPerson person, ContactRole role, UnitContactType unitContactType) {
        super(person, role);
        this.unitContactType = unitContactType;
    }

    InstitutionalProposalUnitContact(UnitContactType unitContactType) {
        this.unitContactType = unitContactType;
    }

    public String getUnitAdministratorUnitNumberByPersonId() {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("unitNumber", this.getInstitutionalProposal().getLeadUnitNumber());
        criteria.put("personId", this.getPerson().getPersonId());
        ArrayList results = new ArrayList(this.getBusinessObjectService().findMatching(UnitAdministrator.class, criteria));
        if (results.size() == 0) {
            return this.getPerson().getUnit().getUnitNumber();
        }
        return ((UnitAdministrator)results.get(0)).getUnitNumber();
    }

    public UnitContactType getUnitContactType() {
        return this.unitContactType;
    }

    @Override
    public UnitAdministratorType getUnitAdministratorType() {
        return this.unitAdministratorType;
    }

    @Override
    public Unit getUnit() {
        return this.getPerson() != null && this.getPerson().getUnit() != null ? this.getPerson().getUnit() : null;
    }

    public void setUnitAdministratorType(UnitAdministratorType unitAdministratorType) {
        this.unitAdministratorType = unitAdministratorType;
    }

    @Override
    public String getUnitAdministratorTypeCode() {
        return this.unitAdministratorTypeCode;
    }

    @Override
    public String getUnitNumber() {
        return this.getUnit() != null ? this.getUnit().getUnitNumber() : null;
    }

    public void setUnitAdministratorTypeCode(String unitAdministratorTypeCode) {
        this.unitAdministratorTypeCode = unitAdministratorTypeCode;
    }

    public boolean isOspAdministrator() {
        boolean ospAdmin = this.getUnitContactType() == UnitContactType.ADMINISTRATOR && this.roleCode != null && this.getContactRole() == null ? OSP_ADMINISTRATOR.equals(this.refreshContactRole().getRoleDescription()) : false;
        return ospAdmin;
    }

    public void setUnitContactType(UnitContactType contactType) {
        this.unitContactType = contactType;
    }

    protected Class<? extends ContactRole> getContactRoleType() {
        return this.getUnitContactType() == UnitContactType.ADMINISTRATOR ? UnitAdministratorType.class : ContactType.class;
    }

    protected String getContactRoleTypeIdentifier() {
        return this.getUnitContactType() == UnitContactType.ADMINISTRATOR ? UNIT_ADMINISTRATOR_TYPE_CODE : CONTACT_TYPE_CODE;
    }

    @Override
    protected Map<String, Object> getContactRoleIdentifierMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(this.getContactRoleTypeIdentifier(), this.getRoleCode());
        return map;
    }
}

