/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.web.struts.action;

import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.framework.compliance.core.AddSpecialReviewEvent;
import org.kuali.coeus.common.framework.compliance.core.SaveSpecialReviewEvent;
import org.kuali.coeus.common.framework.compliance.core.SpecialReviewNotificationRenderer;
import org.kuali.coeus.common.notification.impl.service.KcNotificationService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.institutionalproposal.document.InstitutionalProposalDocument;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.notification.InstitutionalProposalNotification;
import org.kuali.kra.institutionalproposal.notification.InstitutionalProposalNotificationContext;
import org.kuali.kra.institutionalproposal.notification.InstitutionalProposalNotificationRenderer;
import org.kuali.kra.institutionalproposal.specialreview.InstitutionalProposalSpecialReview;
import org.kuali.kra.institutionalproposal.web.struts.action.InstitutionalProposalAction;
import org.kuali.kra.institutionalproposal.web.struts.form.InstitutionalProposalForm;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;

public class InstitutionalProposalSpecialReviewAction
extends InstitutionalProposalAction {
    private static final String SAVE_SPECIAL_REVIEW_FIELD = "document.institutionalProposalList[0].specialReviews";
    private static final String CONFIRM_DELETE_SPECIAL_REVIEW_KEY = "confirmDeleteSpecialReview";
    private static final String SPECIAL_REVIEW_INDICATOR_ON = "1";
    private static final String SPECIAL_REVIEW_INDICATOR_OFF = "0";
    private static final String SPECIAL_REVIEW_INSERTED_CONTEXT_NAME = "Special Review Inserted";
    private static final String IP_IRB_INSERTED_ACTION_CODE = "552";
    private static final String IP_IRB_REMOVED_ACTION_CODE = "553";
    private static final String IP_EXPORT_CONTROL_ACTION_CODE = "558";
    private KcNotificationService notificationService;

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.execute(mapping, form, request, response);
        InstitutionalProposalForm institutionalProposalForm = (InstitutionalProposalForm)form;
        institutionalProposalForm.getSpecialReviewHelper().prepareView();
        return forward;
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.refresh(mapping, form, request, response);
        InstitutionalProposalForm ipForm = (InstitutionalProposalForm)form;
        ipForm.getSpecialReviewHelper().getProtocolSaveLocationPrefix(request.getParameterMap()).ifPresent(prefix -> {
            InstitutionalProposalSpecialReview ipSpecialReview = null;
            if (StringUtils.startsWith((CharSequence)prefix, (CharSequence)"specialReviewHelper.newSpecialReview")) {
                ipSpecialReview = (InstitutionalProposalSpecialReview)ipForm.getSpecialReviewHelper().getNewSpecialReview();
            } else {
                int index = ipForm.getSpecialReviewHelper().getProtocolIndex((String)prefix);
                if (index != -1) {
                    ipSpecialReview = ipForm.getInstitutionalProposalDocument().getInstitutionalProposal().getSpecialReviews().get(index);
                }
            }
            ipForm.getSpecialReviewHelper().prepareProtocolLinkViewFields(ipSpecialReview);
        });
        return forward;
    }

    public ActionForward addSpecialReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InstitutionalProposalForm institutionalProposalForm = (InstitutionalProposalForm)form;
        InstitutionalProposalDocument document = institutionalProposalForm.getInstitutionalProposalDocument();
        InstitutionalProposalSpecialReview specialReview = (InstitutionalProposalSpecialReview)institutionalProposalForm.getSpecialReviewHelper().getNewSpecialReview();
        List<InstitutionalProposalSpecialReview> specialReviews = document.getInstitutionalProposal().getSpecialReviews();
        boolean isProtocolLinkingEnabled = institutionalProposalForm.getSpecialReviewHelper().getIsExportControlEnabled();
        institutionalProposalForm.getSpecialReviewHelper().prepareProtocolLinkViewFields(specialReview);
        ActionForward forward = mapping.findForward("basic");
        if (this.applyRules((DocumentEvent)new AddSpecialReviewEvent<InstitutionalProposalSpecialReview>(document, specialReview, specialReviews, isProtocolLinkingEnabled))) {
            String specialReviewTypeCode;
            specialReview.setSpecialReviewNumber(document.getDocumentNextValue("SPECIAL_REVIEW_NUMBER"));
            document.getInstitutionalProposal().getSpecialReviews().add(specialReview);
            institutionalProposalForm.getSpecialReviewHelper().setNewSpecialReview(new InstitutionalProposalSpecialReview());
            if (specialReview.getSpecialReviewType() == null) {
                specialReview.refreshReferenceObject("specialReviewType");
            }
            if (StringUtils.equals((CharSequence)(specialReviewTypeCode = specialReview.getSpecialReviewType().getSpecialReviewTypeCode()), (CharSequence)SPECIAL_REVIEW_INDICATOR_ON)) {
                SpecialReviewNotificationRenderer renderer = new SpecialReviewNotificationRenderer(new InstitutionalProposalNotificationRenderer(document.getInstitutionalProposal()), specialReview);
                InstitutionalProposalNotificationContext context = new InstitutionalProposalNotificationContext(document.getInstitutionalProposal(), IP_IRB_INSERTED_ACTION_CODE, SPECIAL_REVIEW_INSERTED_CONTEXT_NAME, renderer, "specialReview");
                if (institutionalProposalForm.getNotificationHelper().getPromptUserForNotificationEditor(context)) {
                    institutionalProposalForm.getNotificationHelper().initializeDefaultValues(context);
                    forward = mapping.findForward("notificationEditor");
                } else {
                    this.getNotificationService().sendNotificationAndPersist(context, new InstitutionalProposalNotification(), document.getInstitutionalProposal());
                }
            } else if (StringUtils.equals((CharSequence)specialReviewTypeCode, (CharSequence)"RESBOOT-1000")) {
                SpecialReviewNotificationRenderer renderer = new SpecialReviewNotificationRenderer(new InstitutionalProposalNotificationRenderer(document.getInstitutionalProposal()), specialReview);
                InstitutionalProposalNotificationContext context = new InstitutionalProposalNotificationContext(document.getInstitutionalProposal(), IP_EXPORT_CONTROL_ACTION_CODE, SPECIAL_REVIEW_INSERTED_CONTEXT_NAME, renderer, "specialReview");
                if (institutionalProposalForm.getNotificationHelper().getPromptUserForNotificationEditor(context)) {
                    institutionalProposalForm.getNotificationHelper().initializeDefaultValues(context);
                    forward = mapping.findForward("notificationEditor");
                } else {
                    this.getNotificationService().sendNotificationAndPersist(context, new InstitutionalProposalNotification(), document.getInstitutionalProposal());
                }
            }
        }
        return forward;
    }

    public ActionForward createProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        InstitutionalProposalForm ipForm = (InstitutionalProposalForm)form;
        InstitutionalProposal institutionalProposal = ipForm.getInstitutionalProposalDocument().getInstitutionalProposal();
        return new ActionForward(ipForm.getSpecialReviewHelper().getCreateUrl(institutionalProposal.getProposalNumber(), institutionalProposal.getTitle(), CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("application.url") + "/institutionalProposalSpecialReview.do?docId=" + ipForm.getInstitutionalProposalDocument().getDocumentNumber() + "&methodToCall=docHandler&command=displayDocSearchView&viewDocument=false"), true);
    }

    public ActionForward deleteSpecialReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.confirm(this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_DELETE_SPECIAL_REVIEW_KEY, "question.special.review.delete.confirmation", new String[0]), CONFIRM_DELETE_SPECIAL_REVIEW_KEY, "");
    }

    public ActionForward confirmDeleteSpecialReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        String question = request.getParameter("questionIndex");
        if (CONFIRM_DELETE_SPECIAL_REVIEW_KEY.equals(question)) {
            InstitutionalProposalForm institutionalProposalForm = (InstitutionalProposalForm)form;
            InstitutionalProposalDocument document = institutionalProposalForm.getInstitutionalProposalDocument();
            InstitutionalProposalSpecialReview specialReview = document.getInstitutionalProposal().getSpecialReviews().get(this.getLineToDelete(request));
            document.getInstitutionalProposal().getSpecialReviews().remove(specialReview);
            if (StringUtils.equals((CharSequence)specialReview.getSpecialReviewType().getSpecialReviewTypeCode(), (CharSequence)SPECIAL_REVIEW_INDICATOR_ON)) {
                SpecialReviewNotificationRenderer renderer = new SpecialReviewNotificationRenderer(new InstitutionalProposalNotificationRenderer(document.getInstitutionalProposal()), specialReview);
                InstitutionalProposalNotificationContext context = new InstitutionalProposalNotificationContext(document.getInstitutionalProposal(), IP_IRB_REMOVED_ACTION_CODE, "Special Review Deleted", renderer, "specialReview");
                if (institutionalProposalForm.getNotificationHelper().getPromptUserForNotificationEditor(context)) {
                    institutionalProposalForm.getNotificationHelper().initializeDefaultValues(context);
                    forward = mapping.findForward("notificationEditor");
                } else {
                    this.getNotificationService().sendNotificationAndPersist(context, new InstitutionalProposalNotification(), document.getInstitutionalProposal());
                }
            }
        }
        return forward;
    }

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean isExconProtocolLinkingEnabled;
        InstitutionalProposal institutionalProposal;
        List<InstitutionalProposalSpecialReview> specialReviews;
        ActionForward forward = mapping.findForward("basic");
        InstitutionalProposalForm institutionalProposalForm = (InstitutionalProposalForm)form;
        InstitutionalProposalDocument document = institutionalProposalForm.getInstitutionalProposalDocument();
        if (this.applyRules((DocumentEvent)new SaveSpecialReviewEvent<InstitutionalProposalSpecialReview>(SAVE_SPECIAL_REVIEW_FIELD, document, specialReviews = (institutionalProposal = document.getInstitutionalProposal()).getSpecialReviews(), isExconProtocolLinkingEnabled = institutionalProposalForm.getSpecialReviewHelper().getIsExportControlEnabled()))) {
            List<InstitutionalProposalSpecialReview> deletedReviews = this.getDeletedSpecialReviews(((InstitutionalProposal)this.getBusinessObjectService().findBySinglePrimaryKey(InstitutionalProposal.class, (Object)institutionalProposal.getProposalId())).getSpecialReviews(), specialReviews);
            this.getDocumentService().saveDocument((Document)document);
            institutionalProposal.setSpecialReviewIndicator(institutionalProposal.getSpecialReviews().isEmpty() ? SPECIAL_REVIEW_INDICATOR_OFF : SPECIAL_REVIEW_INDICATOR_ON);
            forward = super.save(mapping, form, request, response);
            institutionalProposalForm.getSpecialReviewHelper().syncProtocolReferences(specialReviews, institutionalProposal.getProposalNumber(), institutionalProposal.getTitle(), deletedReviews);
        }
        return forward;
    }

    private List<InstitutionalProposalSpecialReview> getDeletedSpecialReviews(List<InstitutionalProposalSpecialReview> previousReviews, List<InstitutionalProposalSpecialReview> currentReviews) {
        return previousReviews.stream().filter(psr -> !currentReviews.contains(psr)).collect(Collectors.toList());
    }

    public ActionForward viewSpecialReviewProtocolLink(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String viewProtocolUrl = "";
        InstitutionalProposalForm ipForm = (InstitutionalProposalForm)form;
        String lineNumber = request.getParameter("line");
        if (NumberUtils.isCreatable((String)lineNumber)) {
            int index = Integer.parseInt(lineNumber);
            InstitutionalProposalSpecialReview specialReview = ipForm.getInstitutionalProposalDocument().getInstitutionalProposal().getSpecialReviews().get(index);
            viewProtocolUrl = ipForm.getSpecialReviewHelper().getForwardUrl(specialReview).orElse("");
        }
        return new ActionForward(viewProtocolUrl, true);
    }

    protected KcNotificationService getNotificationService() {
        if (this.notificationService == null) {
            this.notificationService = KcServiceLocator.getService(KcNotificationService.class);
        }
        return this.notificationService;
    }

    public void setNotificationService(KcNotificationService notificationService) {
        this.notificationService = notificationService;
    }
}

