-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

DELIMITER /

DROP PROCEDURE IF EXISTS FIX_BUDGET_DETAILS_MODULAR_MODULAR_IDC
/

CREATE PROCEDURE FIX_BUDGET_DETAILS_MODULAR_MODULAR_IDC()
BEGIN
  DECLARE NO_MORE_RECORDS BOOLEAN DEFAULT FALSE;

  DECLARE V_BUDGET_ID DECIMAL(12,0);
  DECLARE V_BUDGET_PERIOD_NUMBER DECIMAL(12,0);
  DECLARE V_BUDGET_PERIOD DECIMAL(3,0);

  DECLARE RECORD_CUR CURSOR FOR
    SELECT BUDGET_ID, BUDGET_PERIOD_NUMBER, BUDGET_PERIOD FROM BUDGET_PERIODS;

  DECLARE CONTINUE HANDLER FOR NOT FOUND SET NO_MORE_RECORDS = TRUE;

  OPEN RECORD_CUR;

  record_loop: LOOP
    FETCH RECORD_CUR INTO V_BUDGET_ID, V_BUDGET_PERIOD_NUMBER, V_BUDGET_PERIOD;
    IF NO_MORE_RECORDS THEN
      CLOSE RECORD_CUR;
      LEAVE record_loop;
    END IF;

    UPDATE BUDGET_DETAILS
    SET BUDGET_ID = V_BUDGET_ID, BUDGET_PERIOD = V_BUDGET_PERIOD
    WHERE BUDGET_PERIOD_NUMBER = V_BUDGET_PERIOD_NUMBER;

    UPDATE BUDGET_MODULAR
    SET BUDGET_ID = V_BUDGET_ID, BUDGET_PERIOD = V_BUDGET_PERIOD
    WHERE BUDGET_PERIOD_NUMBER = V_BUDGET_PERIOD_NUMBER;

    UPDATE BUDGET_MODULAR_IDC
    SET BUDGET_ID = V_BUDGET_ID, BUDGET_PERIOD = V_BUDGET_PERIOD
    WHERE BUDGET_PERIOD_NUMBER = V_BUDGET_PERIOD_NUMBER;

  END LOOP;

END
/

CALL FIX_BUDGET_DETAILS_MODULAR_MODULAR_IDC
/

DROP PROCEDURE IF EXISTS FIX_DETAILS_CAL_AMOUNTS_PERSONNEL_DETS
/

CREATE PROCEDURE FIX_DETAILS_CAL_AMOUNTS_PERSONNEL_DETS()
BEGIN
  DECLARE NO_MORE_RECORDS BOOLEAN DEFAULT FALSE;

  DECLARE V_BUDGET_ID DECIMAL(12,0);
  DECLARE V_BUDGET_PERIOD_NUMBER DECIMAL(12,0);
  DECLARE V_BUDGET_PERIOD DECIMAL(3,0);
  DECLARE V_BUDGET_DETAILS_ID DECIMAL(12,0);

  -- budget details was fixed above so we can query it for correct data
  DECLARE RECORD_CUR CURSOR FOR
    SELECT BUDGET_ID, BUDGET_PERIOD_NUMBER, BUDGET_PERIOD, BUDGET_DETAILS_ID FROM BUDGET_DETAILS;

  DECLARE CONTINUE HANDLER FOR NOT FOUND SET NO_MORE_RECORDS = TRUE;

  OPEN RECORD_CUR;

  record_loop: LOOP
    FETCH RECORD_CUR INTO V_BUDGET_ID, V_BUDGET_PERIOD_NUMBER, V_BUDGET_PERIOD, V_BUDGET_DETAILS_ID;
    IF NO_MORE_RECORDS THEN
      CLOSE RECORD_CUR;
      LEAVE record_loop;
    END IF;

    UPDATE BUDGET_DETAILS_CAL_AMTS
    SET BUDGET_ID = V_BUDGET_ID, BUDGET_PERIOD = V_BUDGET_PERIOD, BUDGET_PERIOD_NUMBER = V_BUDGET_PERIOD_NUMBER
    WHERE BUDGET_DETAILS_ID = V_BUDGET_DETAILS_ID;

    UPDATE BUDGET_PERSONNEL_DETAILS
    SET BUDGET_ID = V_BUDGET_ID, BUDGET_PERIOD = V_BUDGET_PERIOD, BUDGET_PERIOD_NUMBER = V_BUDGET_PERIOD_NUMBER
    WHERE BUDGET_DETAILS_ID = V_BUDGET_DETAILS_ID;

  END LOOP;

END
/

CALL FIX_DETAILS_CAL_AMOUNTS_PERSONNEL_DETS
/

DROP PROCEDURE IF EXISTS FIX_BUDGET_PER_CAL_AMOUNTS_RAB
/

CREATE PROCEDURE FIX_BUDGET_PER_CAL_AMOUNTS_RAB()
BEGIN
  DECLARE NO_MORE_RECORDS BOOLEAN DEFAULT FALSE;

  DECLARE V_BUDGET_ID DECIMAL(12,0);
  DECLARE V_BUDGET_PERIOD_NUMBER DECIMAL(12,0);
  DECLARE V_BUDGET_PERIOD DECIMAL(3,0);
  DECLARE V_BUDGET_PERSONNEL_DETAILS_ID DECIMAL(12,0);

  -- budget personnel details was fixed above so we can query it for correct data
  DECLARE RECORD_CUR CURSOR FOR
    SELECT BUDGET_ID, BUDGET_PERIOD_NUMBER, BUDGET_PERIOD, BUDGET_PERSONNEL_DETAILS_ID FROM BUDGET_PERSONNEL_DETAILS;

  DECLARE CONTINUE HANDLER FOR NOT FOUND SET NO_MORE_RECORDS = TRUE;

  OPEN RECORD_CUR;

  record_loop: LOOP
    FETCH RECORD_CUR INTO V_BUDGET_ID, V_BUDGET_PERIOD_NUMBER, V_BUDGET_PERIOD, V_BUDGET_PERSONNEL_DETAILS_ID;
    IF NO_MORE_RECORDS THEN
      CLOSE RECORD_CUR;
      LEAVE record_loop;
    END IF;

    UPDATE BUDGET_PERSONNEL_CAL_AMTS
    SET BUDGET_ID = V_BUDGET_ID, BUDGET_PERIOD = V_BUDGET_PERIOD, BUDGET_PERIOD_NUMBER = V_BUDGET_PERIOD_NUMBER
    WHERE BUDGET_PERSONNEL_DETAILS_ID = V_BUDGET_PERSONNEL_DETAILS_ID;

    UPDATE BUDGET_PER_DET_RATE_AND_BASE
    SET BUDGET_ID = V_BUDGET_ID, BUDGET_PERIOD = V_BUDGET_PERIOD, BUDGET_PERIOD_NUMBER = V_BUDGET_PERIOD_NUMBER
    WHERE BUDGET_PERSONNEL_DETAILS_ID = V_BUDGET_PERSONNEL_DETAILS_ID;

  END LOOP;

END
/

CALL FIX_BUDGET_PER_CAL_AMOUNTS_RAB
/

DELIMITER ;
