-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

ALTER TABLE NOTIFICATION_TYPE ADD (
  FROM_ADDRESS VARCHAR(1000),
  EMAIL_ONLY CHAR(1) DEFAULT 'N' NOT NULL
);

CREATE TABLE AWARD_NOTIFICATION
(
      NOTIFICATION_ID DECIMAL(20)
        , NOTIFICATION_TYPE_ID DECIMAL(6) NOT NULL
        , DOCUMENT_NUMBER VARCHAR(40) NOT NULL
        , OWNING_DOCUMENT_ID_FK DECIMAL(22) NOT NULL
        , RECIPIENTS VARCHAR(1000)
        , SUBJECT VARCHAR(1000)
        , MESSAGE VARCHAR(4000)
        , UPDATE_USER VARCHAR(60) NOT NULL
        , UPDATE_TIMESTAMP DATETIME NOT NULL
        , CREATE_TIMESTAMP DATETIME NOT NULL
        , VER_NBR DECIMAL(8) default 1 NOT NULL
        , OBJ_ID VARCHAR(36) NOT NULL
);
ALTER TABLE AWARD_NOTIFICATION
    ADD CONSTRAINT AWARD_NOTIFICATIONP1
PRIMARY KEY (NOTIFICATION_ID);

ALTER TABLE AWARD_NOTIFICATION ADD CONSTRAINT FK1_AWARD_NOTIFICATION
  FOREIGN KEY (OWNING_DOCUMENT_ID_FK) REFERENCES AWARD (AWARD_ID);

ALTER TABLE AWARD_NOTIFICATION ADD CONSTRAINT FK2_AWARD_NOTIFICATION
  FOREIGN KEY (NOTIFICATION_TYPE_ID) REFERENCES NOTIFICATION_TYPE (NOTIFICATION_TYPE_ID);

CREATE TABLE PROPOSAL_NOTIFICATION
(
      NOTIFICATION_ID DECIMAL(20)
        , NOTIFICATION_TYPE_ID DECIMAL(6) NOT NULL
        , DOCUMENT_NUMBER VARCHAR(40) NOT NULL
        , OWNING_DOCUMENT_ID_FK VARCHAR(12) NOT NULL
        , RECIPIENTS VARCHAR(1000)
        , SUBJECT VARCHAR(1000)
        , MESSAGE VARCHAR(4000)
        , UPDATE_USER VARCHAR(60) NOT NULL
        , UPDATE_TIMESTAMP DATETIME NOT NULL
        , CREATE_TIMESTAMP DATETIME NOT NULL
        , VER_NBR DECIMAL(8) default 1 NOT NULL
        , OBJ_ID VARCHAR(36) NOT NULL
);
ALTER TABLE PROPOSAL_NOTIFICATION
    ADD CONSTRAINT PROPOSAL_NOTIFICATIONP1
PRIMARY KEY (NOTIFICATION_ID);

ALTER TABLE PROPOSAL_NOTIFICATION ADD CONSTRAINT FK1_PROPOSAL_NOTIFICATION
  FOREIGN KEY (OWNING_DOCUMENT_ID_FK) REFERENCES EPS_PROPOSAL (PROPOSAL_NUMBER);

ALTER TABLE PROPOSAL_NOTIFICATION ADD CONSTRAINT FK2_PROPOSAL_NOTIFICATION
  FOREIGN KEY (NOTIFICATION_TYPE_ID) REFERENCES NOTIFICATION_TYPE (NOTIFICATION_TYPE_ID);
