/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.logging.appender;

import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import org.owasp.esapi.ESAPI;

public class ServerInfoSupplier
implements Supplier<String> {
    private boolean logServerIP = true;
    private boolean logAppName = true;
    private String applicationName = "";
    private boolean logLogName = true;
    private final String logName;

    public ServerInfoSupplier(String logName) {
        this.logName = logName;
    }

    @Override
    public String get() {
        HttpServletRequest request;
        StringBuilder appInfo = new StringBuilder();
        if (this.logServerIP && (request = ESAPI.currentRequest()) != null) {
            appInfo.append(request.getLocalAddr()).append(":").append(request.getLocalPort());
        }
        if (this.logAppName) {
            appInfo.append("/").append(this.applicationName);
        }
        if (this.logLogName) {
            appInfo.append("/").append(this.logName);
        }
        return appInfo.toString();
    }

    public void setLogServerIp(boolean log) {
        this.logServerIP = log;
    }

    public void setLogLogName(boolean logLogName) {
        this.logLogName = logLogName;
    }

    public void setLogApplicationName(boolean log, String appName) {
        this.logAppName = log;
        this.applicationName = appName;
    }
}

