/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.web.listener;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.reflect.ObjectDefinition;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;

public class BootstrapListener
implements HttpSessionListener {
    private static final Logger LOG = LogManager.getLogger(BootstrapListener.class);
    private static final String LISTENER_PREFIX = "listener.";
    private static final String CLASS_SUFFIX = ".class";
    private boolean initted;
    private final Map<String, HttpSessionListener> listeners = new HashMap<String, HttpSessionListener>();

    private void addListener(String name, String classname) {
        LOG.debug("Adding listener: " + name + "=" + classname);
        Object listenerObject = GlobalResourceLoader.getResourceLoader().getObject(new ObjectDefinition(classname));
        if (listenerObject == null) {
            LOG.error("Listener '" + name + "' class not found: " + classname);
            return;
        }
        if (!(listenerObject instanceof HttpSessionListener)) {
            LOG.error("Class '" + String.valueOf(listenerObject.getClass()) + "' does not implement servlet javax.servlet.http.HttpSessionListener");
            return;
        }
        HttpSessionListener listener = (HttpSessionListener)listenerObject;
        this.listeners.put(name, listener);
    }

    private synchronized void init() {
        if (this.initted) {
            return;
        }
        LOG.debug("Initializing BootstrapListener...");
        Config cfg = ConfigContext.getCurrentContextConfig();
        HashMap<Object, Object> properties = new HashMap<Object, Object>(cfg.getProperties());
        for (Map.Entry entry : properties.entrySet()) {
            String key = ((String)entry.getKey()).toString();
            if (!key.startsWith(LISTENER_PREFIX) || !key.endsWith(CLASS_SUFFIX)) continue;
            String name = key.substring(LISTENER_PREFIX.length(), key.length() - CLASS_SUFFIX.length());
            String value = (String)entry.getValue();
            this.addListener(name, value);
        }
        this.initted = true;
    }

    public void sessionCreated(HttpSessionEvent event) {
        LOG.debug("Begin BootstrapListener session created...");
        this.init();
        for (HttpSessionListener listener : this.listeners.values()) {
            listener.sessionCreated(event);
        }
        LOG.debug("...end BootstrapListener session created.");
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        LOG.debug("Begin BootstrapListener session destroyed...");
        this.init();
        for (HttpSessionListener listener : this.listeners.values()) {
            listener.sessionDestroyed(event);
        }
        LOG.debug("...end BootstrapListener session destroyed.");
    }

    public Map<String, HttpSessionListener> getListeners() {
        return this.listeners;
    }
}

