/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.document.rule;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.coreservice.api.CoreServiceApiServiceLocator;
import org.kuali.rice.coreservice.api.namespace.Namespace;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.bo.ui.GroupDocumentMember;
import org.kuali.rice.kim.bo.ui.GroupDocumentQualifier;
import org.kuali.rice.kim.document.IdentityManagementGroupDocument;
import org.kuali.rice.kim.document.rule.AttributeValidationHelper;
import org.kuali.rice.kim.framework.services.KimFrameworkServiceLocator;
import org.kuali.rice.kim.framework.type.KimTypeService;
import org.kuali.rice.kim.rule.event.ui.AddGroupMemberEvent;
import org.kuali.rice.kim.rule.ui.AddGroupMemberRule;
import org.kuali.rice.kim.rules.ui.GroupDocumentMemberRule;
import org.kuali.rice.kns.rules.TransactionalDocumentRuleBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class IdentityManagementGroupDocumentRule
extends TransactionalDocumentRuleBase
implements AddGroupMemberRule {
    protected AddGroupMemberRule addGroupMemberRule;
    protected AttributeValidationHelper attributeValidationHelper = new AttributeValidationHelper();
    protected Class<? extends GroupDocumentMemberRule> addGroupMemberRuleClass = GroupDocumentMemberRule.class;
    protected IdentityService identityService;

    public IdentityService getIdentityService() {
        if (this.identityService == null) {
            this.identityService = KimApiServiceLocator.getIdentityService();
        }
        return this.identityService;
    }

    protected boolean processCustomSaveDocumentBusinessRules(Document document) {
        if (!(document instanceof IdentityManagementGroupDocument)) {
            return false;
        }
        IdentityManagementGroupDocument groupDoc = (IdentityManagementGroupDocument)document;
        boolean valid = true;
        GlobalVariables.getMessageMap().addToErrorPath("document");
        valid &= this.validAssignGroup(groupDoc);
        valid &= this.validDuplicateGroupName(groupDoc);
        this.getDictionaryValidationService().validateDocumentAndUpdatableReferencesRecursively(document, this.getMaxDictionaryValidationDepth(), true, false);
        valid &= this.validateGroupQualifier(groupDoc.getQualifiers(), groupDoc.getKimType());
        valid &= this.validGroupMemberActiveDates(groupDoc.getMembers());
        GlobalVariables.getMessageMap().removeFromErrorPath("document");
        return valid &= this.validGroupMemberPrincipalIDs(groupDoc.getMembers());
    }

    protected boolean validGroupNamespace(IdentityManagementGroupDocument document) {
        boolean rulePassed = true;
        String namespacePassed = document.getGroupNamespace();
        if (StringUtils.isNotBlank((String)namespacePassed)) {
            rulePassed = true;
            Namespace matchedNamespace = CoreServiceApiServiceLocator.getNamespaceService().getNamespace(namespacePassed);
            if (matchedNamespace == null) {
                rulePassed = false;
            }
        } else {
            rulePassed = false;
        }
        if (!rulePassed) {
            GlobalVariables.getMessageMap().putError("document.groupNamespace", "error.required", new String[]{"Group Namespace"});
        }
        return rulePassed;
    }

    protected boolean validAssignGroup(IdentityManagementGroupDocument document) {
        boolean rulePassed = true;
        HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
        additionalPermissionDetails.put("namespaceCode", document.getGroupNamespace());
        additionalPermissionDetails.put("groupName", document.getGroupName());
        if (document.getMembers() != null && document.getMembers().size() > 0 && !IdentityManagementGroupDocumentRule.getDocumentDictionaryService().getDocumentAuthorizer((Document)document).isAuthorizedByTemplate((Object)document, "KR-IDM", "Populate Group", GlobalVariables.getUserSession().getPrincipalId(), additionalPermissionDetails, null)) {
            GlobalVariables.getMessageMap().putError("document.groupName", "error.assign.group", new String[]{document.getGroupNamespace(), document.getGroupName()});
            rulePassed = false;
        }
        return rulePassed;
    }

    protected boolean validDuplicateGroupName(IdentityManagementGroupDocument groupDoc) {
        Group group = null;
        if (null != groupDoc.getGroupNamespace() && null != groupDoc.getGroupName()) {
            group = KimApiServiceLocator.getGroupService().getGroupByNamespaceCodeAndName(groupDoc.getGroupNamespace(), groupDoc.getGroupName());
        }
        boolean rulePassed = true;
        if (group != null) {
            if (group.getId().equals(groupDoc.getGroupId())) {
                rulePassed = true;
            } else {
                GlobalVariables.getMessageMap().putError("document.groupName", "error.duplicate.entry", new String[]{"Group Name"});
                rulePassed = false;
            }
        }
        return rulePassed;
    }

    protected boolean validGroupMemberActiveDates(List<GroupDocumentMember> groupMembers) {
        boolean valid = true;
        int i = 0;
        for (GroupDocumentMember groupMember : groupMembers) {
            valid &= this.validateActiveDate("document.members[" + i + "].activeToDate", groupMember.getActiveFromDate(), groupMember.getActiveToDate());
            ++i;
        }
        return valid;
    }

    protected boolean validGroupMemberPrincipalIDs(List<GroupDocumentMember> groupMembers) {
        boolean valid = true;
        ArrayList<String> principalIds = new ArrayList<String>();
        for (GroupDocumentMember groupMember : groupMembers) {
            if (!StringUtils.equals((String)groupMember.getMemberTypeCode(), (String)KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE.getCode())) continue;
            principalIds.add(groupMember.getMemberId());
        }
        if (!principalIds.isEmpty()) {
            List validPrincipals = this.getIdentityService().getPrincipals(principalIds);
            ArrayList<String> validPrincipalIds = new ArrayList<String>(validPrincipals.size());
            for (Principal principal : validPrincipals) {
                validPrincipalIds.add(principal.getPrincipalId());
            }
            ArrayList invalidPrincipalIds = new ArrayList(CollectionUtils.subtract(principalIds, validPrincipalIds));
            if (CollectionUtils.isNotEmpty(invalidPrincipalIds)) {
                GlobalVariables.getMessageMap().putError("document.member.memberId", "error.memberid.membertype.mismatch", invalidPrincipalIds.toArray(new String[invalidPrincipalIds.size()]));
                valid = false;
            }
        }
        return valid;
    }

    protected boolean validateGroupQualifier(List<GroupDocumentQualifier> groupQualifiers, KimType kimType) {
        ArrayList<RemotableAttributeError> validationErrors = new ArrayList<RemotableAttributeError>();
        KimTypeService kimTypeService = KimFrameworkServiceLocator.getKimTypeService((KimType)kimType);
        GlobalVariables.getMessageMap().removeFromErrorPath("document");
        Map<String, String> mapToValidate = this.attributeValidationHelper.convertQualifiersToMap(groupQualifiers);
        List errorsTemp = kimTypeService.validateAttributes(kimType.getId(), mapToValidate);
        validationErrors.addAll(this.attributeValidationHelper.convertErrors("", this.attributeValidationHelper.convertQualifiersToAttrIdxMap(groupQualifiers), errorsTemp));
        GlobalVariables.getMessageMap().addToErrorPath("document");
        if (validationErrors.isEmpty()) {
            return true;
        }
        this.attributeValidationHelper.moveValidationErrorsToErrorMap(validationErrors);
        return false;
    }

    protected boolean validateActiveDate(String errorPath, Timestamp activeFromDate, Timestamp activeToDate) {
        boolean valid = true;
        if (activeFromDate != null && activeToDate != null && activeToDate.before(activeFromDate)) {
            MessageMap errorMap = GlobalVariables.getMessageMap();
            errorMap.putError(errorPath, "error.active.todate.before.fromdate", new String[0]);
            valid = false;
        }
        return valid;
    }

    public AddGroupMemberRule getAddGroupMemberRule() {
        if (this.addGroupMemberRule == null) {
            try {
                this.addGroupMemberRule = this.addGroupMemberRuleClass.newInstance();
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to create AddMemberRule instance using class: " + String.valueOf(this.addGroupMemberRuleClass), ex);
            }
        }
        return this.addGroupMemberRule;
    }

    @Override
    public boolean processAddGroupMember(AddGroupMemberEvent addGroupMemberEvent) {
        return this.getAddGroupMemberRule().processAddGroupMember(addGroupMemberEvent);
    }
}

