/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.impl.impex.xml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.impex.xml.XmlDoc;
import org.kuali.rice.core.api.impex.xml.XmlDocCollection;
import org.kuali.rice.core.framework.impex.xml.XmlLoader;
import org.kuali.rice.core.impl.impex.xml.XmlDigesterService;

public class XmlDigesterServiceImpl
implements XmlDigesterService {
    private static final Logger LOG = LogManager.getLogger(XmlDigesterServiceImpl.class);

    private static void addProcessingException(XmlDoc xmlDoc, String message, Throwable t) {
        Object msg = xmlDoc.getProcessingMessage();
        if (msg == null) {
            msg = "";
        }
        msg = (String)msg + message + "\n" + ExceptionUtils.getFullStackTrace((Throwable)t);
        xmlDoc.setProcessingMessage((String)msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void digest(XmlLoader xmlLoader, XmlDocCollection xmlDocCollection, String principalId) throws IOException {
        for (XmlDoc xmlDoc : xmlDocCollection.getXmlDocs()) {
            BufferedInputStream inputStream = null;
            try {
                inputStream = new BufferedInputStream(xmlDoc.getStream());
                xmlLoader.loadXml((InputStream)inputStream, principalId);
                xmlDoc.setProcessed(true);
            }
            catch (Exception e) {
                xmlDoc.setProcessed(false);
                XmlDigesterServiceImpl.addProcessingException(xmlDoc, "Caught Exception loading xml data from " + String.valueOf(xmlDoc) + ".  Will move associated file to problem dir.", e);
                LOG.error("Caught Exception loading xml data from " + String.valueOf(xmlDoc) + ".  Will move associated file to problem dir.", (Throwable)e);
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (!(e instanceof IOException)) continue;
                throw (IOException)e;
            }
            finally {
                if (inputStream == null) continue;
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException ioe) {
                    LOG.warn("Error closing stream for xml doc: " + String.valueOf(xmlDoc), (Throwable)ioe);
                }
            }
        }
    }
}

