/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.util.jaxb;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.w3c.dom.Element;

public class MapStringStringAdapter
extends XmlAdapter<StringMapEntryList, Map<String, String>> {
    public StringMapEntryList marshal(Map<String, String> map) throws Exception {
        if (map == null) {
            return null;
        }
        ArrayList<StringMapEntry> entries = new ArrayList<StringMapEntry>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            entries.add(new StringMapEntry(entry));
        }
        return new StringMapEntryList(entries);
    }

    public Map<String, String> unmarshal(StringMapEntryList entryList) throws Exception {
        if (entryList == null || entryList.getEntries() == null) {
            return null;
        }
        List<StringMapEntry> entries = entryList.getEntries();
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>(entries.size());
        for (StringMapEntry entry : entries) {
            resultMap.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(resultMap);
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    @XmlType(name="StringMapEntryType")
    public static final class StringMapEntry
    implements Serializable {
        private static final long serialVersionUID = -9609663434312103L;
        @XmlAttribute(name="key")
        private final String key;
        @XmlValue
        private final String value;

        private StringMapEntry() {
            this.key = null;
            this.value = null;
        }

        public StringMapEntry(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public StringMapEntry(Map.Entry<String, String> e) {
            this.key = e.getKey();
            this.value = e.getValue();
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="StringMapEntryListType")
    public static class StringMapEntryList
    extends AbstractDataTransferObject {
        private static final long serialVersionUID = 1L;
        @XmlElement(name="entry")
        private final List<StringMapEntry> entries;
        @XmlAnyElement
        private final Collection<Element> _futureElements = null;

        private StringMapEntryList() {
            this.entries = null;
        }

        public StringMapEntryList(List<StringMapEntry> entries) {
            this.entries = new ArrayList<StringMapEntry>(entries);
        }

        public List<StringMapEntry> getEntries() {
            if (this.entries == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(this.entries);
        }
    }
}

