/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.shared.caching;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.ehcache.Cache;
import org.ehcache.config.ResourceType;
import org.ehcache.core.CacheConfigurationChangeListener;
import org.ehcache.core.EhcachePrefixLoggerFactory;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.spi.store.tiering.CachingTier;
import org.ehcache.impl.internal.store.shared.AbstractPartition;
import org.ehcache.impl.internal.store.shared.composites.CompositeValue;
import org.ehcache.impl.store.HashUtils;
import org.ehcache.spi.resilience.StoreAccessException;
import org.slf4j.Logger;

public class CachingTierPartition<K, V>
extends AbstractPartition<CachingTier<CompositeValue<K>, CompositeValue<V>>>
implements CachingTier<K, V> {
    private final Logger logger = EhcachePrefixLoggerFactory.getLogger(CachingTierPartition.class);
    private final Map<Integer, CachingTier.InvalidationListener<?, ?>> invalidationListenerMap;

    public CachingTierPartition(ResourceType<?> type, int id, CachingTier<CompositeValue<K>, CompositeValue<V>> store, Map<Integer, CachingTier.InvalidationListener<?, ?>> invalidationListenerMap) {
        super(type, id, store);
        this.invalidationListenerMap = invalidationListenerMap;
    }

    public void clear() throws StoreAccessException {
        boolean completeRemoval = true;
        Store realStore = (Store)this.shared();
        Store.Iterator iterator = realStore.iterator();
        while (iterator.hasNext()) {
            try {
                Cache.Entry next = (Cache.Entry)iterator.next();
                if (((CompositeValue)next.getKey()).getStoreId() != this.id()) continue;
                realStore.remove(next.getKey());
            }
            catch (StoreAccessException cae) {
                completeRemoval = false;
            }
        }
        if (!completeRemoval) {
            this.logger.error("Iteration failures may have prevented a complete removal");
        }
    }

    public List<CacheConfigurationChangeListener> getConfigurationChangeListeners() {
        return ((CachingTier)this.shared()).getConfigurationChangeListeners();
    }

    public Store.ValueHolder<V> getOrComputeIfAbsent(K key, Function<K, Store.ValueHolder<V>> source) throws StoreAccessException {
        return this.decode(((CachingTier)this.shared()).getOrComputeIfAbsent(this.composite(key), k -> this.encode((Store.ValueHolder)source.apply(k.getValue()))));
    }

    public Store.ValueHolder<V> getOrDefault(K key, Function<K, Store.ValueHolder<V>> source) throws StoreAccessException {
        return this.decode(((CachingTier)this.shared()).getOrDefault(this.composite(key), k -> this.encode((Store.ValueHolder)source.apply(k.getValue()))));
    }

    public void invalidate(K key) throws StoreAccessException {
        ((CachingTier)this.shared()).invalidate(this.composite(key));
    }

    public void invalidateAll() throws StoreAccessException {
        Store realStore = (Store)this.shared();
        boolean invalidate = true;
        Store.Iterator iterator = realStore.iterator();
        while (iterator.hasNext()) {
            try {
                Cache.Entry next = (Cache.Entry)iterator.next();
                if (((CompositeValue)next.getKey()).getStoreId() != this.id()) continue;
                ((CachingTier)this.shared()).invalidate(next.getKey());
            }
            catch (StoreAccessException cae) {
                invalidate = false;
            }
        }
        if (!invalidate) {
            this.logger.error("Could not invalidate one or more cache entries");
        }
    }

    public void invalidateAllWithHash(long keyValueHash) throws StoreAccessException {
        ((CachingTier)this.shared()).invalidateAllWithHash((long)CompositeValue.compositeHash(this.id(), HashUtils.longHashToInt(keyValueHash)));
    }

    public void setInvalidationListener(CachingTier.InvalidationListener<K, V> invalidationListener) {
        this.invalidationListenerMap.put(this.id(), invalidationListener);
    }

    public Map<K, Store.ValueHolder<V>> bulkGetOrComputeIfAbsent(Iterable<? extends K> keys, Function<Set<? extends K>, Iterable<? extends Map.Entry<? extends K, ? extends Store.ValueHolder<V>>>> mappingFunction) throws StoreAccessException {
        Map results = ((CachingTier)this.shared()).bulkGetOrComputeIfAbsent(this.compositeSet(keys), compositeKeys -> {
            HashSet extractedKeys = new HashSet();
            compositeKeys.forEach(k -> extractedKeys.add(k.getValue()));
            HashMap encodedResults = new HashMap();
            Iterable extractedResults = (Iterable)mappingFunction.apply(extractedKeys);
            extractedResults.forEach(entry -> encodedResults.put(this.composite(entry.getKey()), this.encode((Store.ValueHolder)entry.getValue())));
            return encodedResults.entrySet();
        });
        HashMap decodedResults = new HashMap();
        results.forEach((k, v) -> decodedResults.put(k.getValue(), this.decode(v)));
        return decodedResults;
    }
}

