/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.shared.composites;

import java.util.Map;
import org.ehcache.core.spi.store.tiering.AuthoritativeTier;
import org.ehcache.impl.internal.store.shared.composites.CompositeValue;
import org.ehcache.impl.store.HashUtils;
import org.ehcache.spi.resilience.StoreAccessException;

public class CompositeInvalidationValve
implements AuthoritativeTier.InvalidationValve {
    private final Map<Integer, AuthoritativeTier.InvalidationValve> invalidationValveMap;

    public CompositeInvalidationValve(Map<Integer, AuthoritativeTier.InvalidationValve> invalidationValveMap) {
        this.invalidationValveMap = invalidationValveMap;
    }

    public void invalidateAll() throws StoreAccessException {
        this.invalidationValveMap.forEach((k, v) -> {
            try {
                v.invalidateAll();
            }
            catch (StoreAccessException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void invalidateAllWithHash(long keyValueHash) throws StoreAccessException {
        this.invalidationValveMap.forEach((k, v) -> {
            try {
                v.invalidateAllWithHash((long)CompositeValue.compositeHash(k, HashUtils.longHashToInt(keyValueHash)));
            }
            catch (StoreAccessException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

