/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.factory;

import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.configuration.Configurable;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.configuration.impl.OjbConfigurator;
import org.apache.ojb.broker.util.interceptor.InterceptorFactory;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public abstract class ConfigurableFactory
implements Configurable {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Class classToServe = null;

    public ConfigurableFactory() {
        OjbConfigurator.getInstance().configure(this);
    }

    protected abstract String getConfigurationKey();

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        if (this.getConfigurationKey() == null) {
            this.getLogger().error("ConfigurableFactory configuration key is 'null'");
            throw new PersistenceBrokerException("ConfigurableFactory configuration key is 'null'");
        }
        Class clazz = configuration.getClass(this.getConfigurationKey(), null);
        if (clazz == null) {
            this.getLogger().error("ConfigurableFactory configuration key class for key'" + this.getConfigurationKey() + "' does not exist.");
            throw new PersistenceBrokerException("ConfigurableFactory configuration key class for key'" + this.getConfigurationKey() + "' does not exist.");
        }
        this.setClassToServe(clazz);
    }

    public Object createNewInstance(Class[] classArray, Object[] objectArray) {
        try {
            Object object = classArray != null ? ClassHelper.newInstance(this.getClassToServe(), classArray, objectArray, true) : ClassHelper.newInstance(this.getClassToServe(), true);
            object = InterceptorFactory.getInstance().createInterceptorFor(object);
            return object;
        }
        catch (InstantiationException instantiationException) {
            this.getLogger().error("ConfigurableFactory can't instantiate class " + this.getClassToServe() + this.buildArgumentString(classArray, objectArray), instantiationException);
            throw new PersistenceBrokerException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.getLogger().error("ConfigurableFactory can't access constructor for class " + this.getClassToServe() + this.buildArgumentString(classArray, objectArray), illegalAccessException);
            throw new PersistenceBrokerException(illegalAccessException);
        }
        catch (Exception exception) {
            this.getLogger().error("ConfigurableFactory instantiation failed for class " + this.getClassToServe() + this.buildArgumentString(classArray, objectArray), exception);
            throw new PersistenceBrokerException(exception);
        }
    }

    protected String buildArgumentString(Class[] classArray, Object[] objectArray) {
        Object object;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        String string = SystemUtils.LINE_SEPARATOR;
        stringBuffer.append(string + "* Factory types: ");
        if (classArray != null) {
            for (n = 0; n < classArray.length; ++n) {
                object = classArray[n];
                stringBuffer.append(string + (n + 1) + " - Type: " + (object != null ? ((Class)object).getName() : null));
            }
        } else {
            stringBuffer.append(string + "none");
        }
        stringBuffer.append(string + "* Factory arguments: ");
        if (objectArray != null) {
            for (n = 0; n < objectArray.length; ++n) {
                object = objectArray[n];
                stringBuffer.append(string + (n + 1) + " - Argument: " + object);
            }
        } else {
            stringBuffer.append(string + "none");
        }
        return stringBuffer.toString();
    }

    public Object createNewInstance() {
        return this.createNewInstance((Class)null, (Object)null);
    }

    public Object createNewInstance(Class clazz, Object object) {
        if (clazz != null) {
            return this.createNewInstance(new Class[]{clazz}, new Object[]{object});
        }
        return this.createNewInstance((Class[])null, null);
    }

    public Class getClassToServe() {
        return this.classToServe;
    }

    public void setClassToServe(Class clazz) {
        this.classToServe = clazz;
    }

    protected Logger getLogger() {
        return this.log;
    }
}

