/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.simulation;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.kew.actionrequest.KimPrincipalRecipient;
import org.kuali.rice.kew.actionrequest.Recipient;
import org.kuali.rice.kew.api.action.RoutingReportActionToTake;
import org.kuali.rice.kew.api.action.RoutingReportCriteria;
import org.kuali.rice.kew.engine.simulation.SimulationActionToTake;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class SimulationCriteria {
    private String documentId;
    private String destinationNodeName;
    private List<Recipient> destinationRecipients = new ArrayList<Recipient>();
    private String documentTypeName;
    private String xmlContent;
    private List<String> nodeNames = new ArrayList<String>();
    private List<String> ruleTemplateNames = new ArrayList<String>();
    private Boolean activateRequests;
    private Person routingUser;
    private List<SimulationActionToTake> actionsToTake = new ArrayList<SimulationActionToTake>();
    private boolean flattenNodes;

    public SimulationCriteria() {
        this.activateRequests = null;
        this.flattenNodes = false;
    }

    public static SimulationCriteria createSimulationCritUsingDocumentId(String documentId) {
        return new SimulationCriteria(null, documentId);
    }

    public static SimulationCriteria createSimulationCritUsingDocTypeName(String documentTypeName) {
        return new SimulationCriteria(documentTypeName, null);
    }

    private SimulationCriteria(String documentTypeName, String documentId) {
        if (StringUtils.isNotBlank((String)documentId)) {
            this.documentId = documentId;
        } else if (StringUtils.isNotBlank((String)documentTypeName)) {
            this.documentTypeName = documentTypeName;
        }
    }

    public Boolean isActivateRequests() {
        return this.activateRequests;
    }

    public void setActivateRequests(Boolean activateRequests) {
        this.activateRequests = activateRequests;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public String getDestinationNodeName() {
        return this.destinationNodeName;
    }

    public void setDestinationNodeName(String destinationNodeName) {
        this.destinationNodeName = destinationNodeName;
    }

    public List<Recipient> getDestinationRecipients() {
        return this.destinationRecipients;
    }

    public void setDestinationRecipients(List<Recipient> destinationRecipients) {
        this.destinationRecipients = destinationRecipients;
    }

    public String getDocumentTypeName() {
        return this.documentTypeName;
    }

    public void setDocumentTypeName(String documentTypeName) {
        this.documentTypeName = documentTypeName;
    }

    public List<String> getRuleTemplateNames() {
        return this.ruleTemplateNames;
    }

    public void setRuleTemplateNames(List<String> ruleTemplateNames) {
        this.ruleTemplateNames = ruleTemplateNames;
    }

    public String getXmlContent() {
        return this.xmlContent;
    }

    public void setXmlContent(String xmlContent) {
        this.xmlContent = xmlContent;
    }

    public List<String> getNodeNames() {
        return this.nodeNames;
    }

    public void setNodeNames(List<String> nodeNames) {
        this.nodeNames = nodeNames;
    }

    public boolean isDocumentSimulation() {
        return this.documentId != null;
    }

    public boolean isDocumentTypeSimulation() {
        return !StringUtils.isEmpty((String)this.documentTypeName);
    }

    public List<SimulationActionToTake> getActionsToTake() {
        return this.actionsToTake;
    }

    public void setActionsToTake(List<SimulationActionToTake> actionsToTake) {
        this.actionsToTake = actionsToTake;
    }

    public Person getRoutingUser() {
        return this.routingUser;
    }

    public void setRoutingUser(Person routingUser) {
        this.routingUser = routingUser;
    }

    public boolean isFlattenNodes() {
        return this.flattenNodes;
    }

    public void setFlattenNodes(boolean flattenNodes) {
        this.flattenNodes = flattenNodes;
    }

    public static SimulationCriteria from(RoutingReportCriteria criteriaVO) {
        if (criteriaVO == null) {
            return null;
        }
        SimulationCriteria criteria = new SimulationCriteria();
        criteria.setDestinationNodeName(criteriaVO.getTargetNodeName());
        criteria.setDocumentId(criteriaVO.getDocumentId());
        criteria.setDocumentTypeName(criteriaVO.getDocumentTypeName());
        criteria.setXmlContent(criteriaVO.getXmlContent());
        criteria.setActivateRequests(criteriaVO.isActivateRequests());
        criteria.setFlattenNodes(criteriaVO.isFlattenNodes());
        if (criteriaVO.getRoutingPrincipalId() != null) {
            Principal kPrinc = KEWServiceLocator.getIdentityHelperService().getPrincipal(criteriaVO.getRoutingPrincipalId());
            Person user = KimApiServiceLocator.getPersonService().getPerson(kPrinc.getPrincipalId());
            if (user == null) {
                throw new RiceRuntimeException("Could not locate user for the given id: " + criteriaVO.getRoutingPrincipalId());
            }
            criteria.setRoutingUser(user);
        }
        if (criteriaVO.getRuleTemplateNames() != null) {
            criteria.setRuleTemplateNames(criteriaVO.getRuleTemplateNames());
        }
        if (criteriaVO.getNodeNames() != null) {
            criteria.setNodeNames(criteriaVO.getNodeNames());
        }
        if (criteriaVO.getTargetPrincipalIds() != null) {
            for (String targetPrincipalId : criteriaVO.getTargetPrincipalIds()) {
                Principal principal = KEWServiceLocator.getIdentityHelperService().getPrincipal(targetPrincipalId);
                criteria.getDestinationRecipients().add(new KimPrincipalRecipient((PrincipalContract)principal));
            }
        }
        if (criteriaVO.getActionsToTake() != null) {
            for (RoutingReportActionToTake actionToTake : criteriaVO.getActionsToTake()) {
                criteria.getActionsToTake().add(SimulationActionToTake.from(actionToTake));
            }
        }
        return criteria;
    }
}

