/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.core;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelDetails;
import org.kuali.coeus.common.budget.framework.personnel.ValidCeJobCode;
import org.kuali.coeus.common.budget.impl.core.CostElementValuesFinder;
import org.kuali.coeus.propdev.impl.budget.core.ProposalBudgetForm;
import org.kuali.coeus.sys.framework.util.ValuesFinderUtils;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="budgetPersonnelCostElementValuesFinder")
public class BudgetPersonnelCostElementValuesFinder
extends CostElementValuesFinder {
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;

    public List<KeyValue> getKeyValues(ViewModel model) {
        ProposalBudgetForm proposalBudgetForm = (ProposalBudgetForm)model;
        String unitNumber = proposalBudgetForm.getDevelopmentProposal().getUnitNumber();
        BudgetPersonnelDetails details = proposalBudgetForm.getAddProjectPersonnelHelper().getBudgetPersonnelDetail();
        String jobCode = details != null && details.getBudgetPerson() != null ? proposalBudgetForm.getAddProjectPersonnelHelper().getBudgetPersonnelDetail().getBudgetPerson().getJobCode() : "";
        return this.getValidCostElementForJobCode(jobCode, unitNumber);
    }

    protected List<KeyValue> getValidCostElementForJobCode(String jobCode, String unitNumber) {
        List<KeyValue> allKeyValues = super.getKeyValues(this.getPersonnelBudgetCategoryTypeCode(), true, null, unitNumber);
        if (StringUtils.isNotBlank((CharSequence)jobCode)) {
            List validCeCodes = this.getBusinessObjectService().findMatching(ValidCeJobCode.class, Collections.singletonMap("jobCode", jobCode.toUpperCase())).stream().map(ValidCeJobCode::getCostElement).collect(Collectors.toList());
            List<KeyValue> jobCodeLimitedKeyValues = allKeyValues.stream().filter(kv -> validCeCodes.contains(kv.getKey())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(jobCodeLimitedKeyValues)) {
                jobCodeLimitedKeyValues.add(0, ValuesFinderUtils.getSelectOption());
                return jobCodeLimitedKeyValues;
            }
            return allKeyValues;
        }
        return allKeyValues;
    }

    private String getPersonnelBudgetCategoryTypeCode() {
        return this.getParameterService().getParameterValueAsString("KC-B", "Document", "budgetCategoryType.personnel");
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

