/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s;

import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Embeddable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.kuali.coeus.propdev.api.s2s.S2sOppFormsContract;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;

@Entity
@Table(name="S2S_OPP_FORMS")
public class S2sOppForms
extends KcPersistableBusinessObjectBase
implements S2sOppFormsContract {
    @EmbeddedId
    private S2sOppFormsId s2sOppFormsId;
    @Column(name="AVAILABLE")
    @Convert(converter=BooleanYNConverter.class)
    private Boolean available;
    @Column(name="FORM_NAME")
    private String formName;
    @Column(name="INCLUDE")
    @Convert(converter=BooleanYNConverter.class)
    private Boolean include;
    @Column(name="MANDATORY")
    @Convert(converter=BooleanYNConverter.class)
    private Boolean mandatory;
    @Column(name="SCHEMA_URL")
    private String schemaUrl;
    @Transient
    private Boolean selectToPrint;
    @Column(name="USER_ATTACHED_FORM")
    @Convert(converter=BooleanYNConverter.class)
    private Boolean userAttachedForm;
    @Transient
    private transient ParameterService parameterService;

    public S2sOppFormsId getS2sOppFormsId() {
        return this.s2sOppFormsId;
    }

    public void setS2sOppFormsId(S2sOppFormsId s2sOppFormsId) {
        this.s2sOppFormsId = s2sOppFormsId;
    }

    public String getOppNameSpace() {
        return this.s2sOppFormsId.oppNameSpace;
    }

    public String getProposalNumber() {
        return this.s2sOppFormsId.proposalNumber;
    }

    public void setAvailable(Boolean available) {
        this.available = available;
    }

    public Boolean getAvailable() {
        return this.available;
    }

    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public void setInclude(Boolean include) {
        this.include = include;
    }

    public Boolean getInclude() {
        return this.include;
    }

    public void setMandatory(Boolean mandatory) {
        this.mandatory = mandatory;
    }

    public Boolean getMandatory() {
        return this.mandatory;
    }

    public String getSchemaUrl() {
        return this.schemaUrl;
    }

    public void setSchemaUrl(String schemaUrl) {
        this.schemaUrl = schemaUrl;
    }

    public Boolean getSelectToPrint() {
        return Objects.equals(Boolean.TRUE, this.include) && Objects.equals(Boolean.TRUE, this.selectToPrint);
    }

    public void setSelectToPrint(Boolean selectToPrint) {
        this.selectToPrint = selectToPrint;
    }

    public Boolean getUserAttachedForm() {
        return this.userAttachedForm;
    }

    public void setUserAttachedForm(Boolean userAttachedForm) {
        this.userAttachedForm = userAttachedForm;
    }

    public Boolean isPackagePreviewEnabled() {
        return this.getParameterService().getParameterValueAsBoolean("KC-PD", "All", "Beta_S2S_Package_Preview");
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    @Embeddable
    public static final class S2sOppFormsId
    implements Serializable,
    Comparable<S2sOppFormsId> {
        @Column(name="OPP_NAME_SPACE")
        private String oppNameSpace;
        @Column(name="PROPOSAL_NUMBER")
        private String proposalNumber;

        public String getOppNameSpace() {
            return this.oppNameSpace;
        }

        public void setOppNameSpace(String oppNameSpace) {
            this.oppNameSpace = oppNameSpace;
        }

        public String getProposalNumber() {
            return this.proposalNumber;
        }

        public void setProposalNumber(String proposalNumber) {
            this.proposalNumber = proposalNumber;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("oppNameSpace", (Object)this.oppNameSpace).append("proposalNumber", (Object)this.proposalNumber).toString();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            S2sOppFormsId rhs = (S2sOppFormsId)other;
            return new EqualsBuilder().append((Object)this.oppNameSpace, (Object)rhs.oppNameSpace).append((Object)this.proposalNumber, (Object)rhs.proposalNumber).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.oppNameSpace).append((Object)this.proposalNumber).toHashCode();
        }

        @Override
        public int compareTo(S2sOppFormsId other) {
            return new CompareToBuilder().append((Object)this.oppNameSpace, (Object)other.oppNameSpace).append((Object)this.proposalNumber, (Object)other.proposalNumber).toComparison();
        }
    }
}

