/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdevrest.impl.gf;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.api.document.service.CommonApiService;
import org.kuali.coeus.propdev.impl.gf.GrantForwardAmount;
import org.kuali.coeus.propdev.impl.gf.GrantForwardDeadline;
import org.kuali.coeus.propdev.impl.gf.GrantForwardLocation;
import org.kuali.coeus.propdev.impl.gf.GrantForwardRecord;
import org.kuali.coeus.propdev.impl.gf.GrantForwardSponsor;
import org.kuali.coeus.propdevrest.impl.gf.GrantForwardProposalDto;
import org.kuali.coeus.propdevrest.impl.gf.GrantForwardRequestDto;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.rest.UnauthorizedAccessException;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(value={"https://www.grantforward.com"})
@RequestMapping(value={"/api/v1"})
@RestController(value="grantForwardIntegrationController")
public class GrantForwardIntegrationController
extends org.kuali.coeus.sys.framework.controller.rest.RestController {
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="commonApiService")
    private CommonApiService commonApiService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;
    @Autowired
    @Qualifier(value="permissionService")
    private PermissionService permissionService;

    @PostMapping(value={"/grant-forward"}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity<GrantForwardProposalDto> createGrantForward(@RequestBody GrantForwardRequestDto grantForwardRequestDto) {
        if (grantForwardRequestDto.getGrant() == null) {
            return ResponseEntity.badRequest().build();
        }
        this.assertUserHasWriteAccess();
        GrantForwardRecord record = this.commonApiService.convertObject(grantForwardRequestDto.getGrant(), GrantForwardRecord.class);
        List<GrantForwardAmount> amounts = Optional.ofNullable(grantForwardRequestDto.getGrant().getAmounts()).stream().flatMap(Collection::stream).map(i -> {
            GrantForwardAmount r = this.commonApiService.convertObject(i, GrantForwardAmount.class);
            r.setGrantForwardRecord(record);
            return r;
        }).collect(Collectors.toList());
        List<GrantForwardDeadline> deadlines = Optional.ofNullable(grantForwardRequestDto.getGrant().getDeadlines()).stream().flatMap(Collection::stream).map(i -> {
            GrantForwardDeadline r = this.commonApiService.convertObject(i, GrantForwardDeadline.class);
            r.setGrantForwardRecord(record);
            return r;
        }).collect(Collectors.toList());
        List<GrantForwardLocation> locations = Optional.ofNullable(grantForwardRequestDto.getGrant().getLocations()).stream().flatMap(Collection::stream).map(i -> {
            GrantForwardLocation r = this.commonApiService.convertObject(i, GrantForwardLocation.class);
            r.setGrantForwardRecord(record);
            return r;
        }).collect(Collectors.toList());
        List<GrantForwardSponsor> sponsors = Optional.ofNullable(grantForwardRequestDto.getGrant().getSponsors()).stream().flatMap(Collection::stream).map(i -> {
            GrantForwardSponsor r = this.commonApiService.convertObject(i, GrantForwardSponsor.class);
            r.setGrantForwardRecord(record);
            return r;
        }).collect(Collectors.toList());
        record.setAmounts(amounts);
        record.setDeadlines(deadlines);
        record.setLocations(locations);
        record.setSponsors(sponsors);
        GrantForwardRecord saved = (GrantForwardRecord)this.dataObjectService.save((Object)record, new PersistenceOption[]{PersistenceOption.FLUSH});
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)this.createProposalDto(saved));
    }

    @GetMapping(value={"/grant-forward/{id}/proposal/"}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity<GrantForwardProposalDto> getGrantForwardProposal(@PathVariable String id) {
        this.assertUserHasReadAccess();
        GrantForwardRecord saved = (GrantForwardRecord)this.dataObjectService.find(GrantForwardRecord.class, (Object)id);
        if (saved != null) {
            return ResponseEntity.ok((Object)this.createProposalDto(saved));
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).build();
    }

    protected void assertUserHasReadAccess() {
        if (this.globalVariableService.getUserSession() == null || !this.permissionService.hasPermissionByTemplate(this.globalVariableService.getUserSession().getPrincipalId(), "KC-SYS", "Read Class", Collections.singletonMap("className", GrantForwardRecord.class.getName()))) {
            throw new UnauthorizedAccessException();
        }
    }

    protected void assertUserHasWriteAccess() {
        if (this.globalVariableService.getUserSession() == null || !this.permissionService.hasPermissionByTemplate(this.globalVariableService.getUserSession().getPrincipalId(), "KC-SYS", "Write Class", Collections.singletonMap("className", GrantForwardRecord.class.getName()))) {
            throw new UnauthorizedAccessException();
        }
    }

    private GrantForwardProposalDto createProposalDto(GrantForwardRecord record) {
        GrantForwardProposalDto proposal = new GrantForwardProposalDto();
        proposal.setId(record.getId());
        proposal.setGrantId(record.getGrantId());
        proposal.setUrl(record.getUrl());
        proposal.setProposalNumber(record.getProposalNumber());
        proposal.setProposalUrl(this.createProposalUrl(record.getId()));
        proposal.setUpdateUser(record.getUpdateUser());
        proposal.setUpdateTimestamp(record.getUpdateTimestamp());
        return proposal;
    }

    private String createProposalUrl(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("id cannot be blank or null");
        }
        return this.configurationService.getPropertyValueAsString("application.url") + "/kc-pd-krad/proposalDevelopment?viewId=PropDev-InitiateView&methodToCall=docHandler&command=initiate&gfRecordId=" + id;
    }
}

