/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.ipreview;

import java.io.Serializable;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.version.VersionException;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.institutionalproposal.ipreview.IntellectualPropertyReview;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalVersioningService;
import org.kuali.kra.maintenance.KraMaintainableImpl;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.data.MaterializeOption;
import org.kuali.rice.krad.util.ObjectUtils;

public class IntellectualPropertyReviewMaintainableImpl
extends KraMaintainableImpl
implements Maintainable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String KIM_PERSON_LOOKUPABLE_REFRESH_CALLER = "kimPersonLookupable";
    private static final Logger LOG = LogManager.getLogger(IntellectualPropertyReviewMaintainableImpl.class);

    public void refresh(String refreshCaller, Map fieldValues, MaintenanceDocument document) {
        super.refresh(refreshCaller, fieldValues, document);
        if (KIM_PERSON_LOOKUPABLE_REFRESH_CALLER.equals(refreshCaller)) {
            IntellectualPropertyReview ipReview = (IntellectualPropertyReview)this.getBusinessObject();
            String principalId = (String)fieldValues.get("principalId");
            ipReview.setIpReviewer(principalId);
        }
    }

    @Override
    public void prepareForSave() {
        super.prepareForSave();
        if (this.businessObject != null && this.businessObject instanceof IntellectualPropertyReview) {
            try {
                IntellectualPropertyReview newVersion = this.getInstitutionalProposalVersioningService().createNewIntellectualPropertyReviewVersion((IntellectualPropertyReview)this.businessObject);
                this.setBusinessObject((PersistableBusinessObject)newVersion);
            }
            catch (VersionException ve) {
                throw new RuntimeException("Caught exception versioning intellectual property review: " + String.valueOf(ve));
            }
        }
    }

    public void processAfterCopy(MaintenanceDocument document, Map<String, String[]> parameters) {
        try {
            this.getDataObjectService().wrap((Object)this.businessObject).materializeReferencedObjectsToDepth(2, new MaterializeOption[]{MaterializeOption.COLLECTIONS, MaterializeOption.UPDATE_UPDATABLE_REFS});
            ObjectUtils.setObjectPropertyDeep((Object)this.businessObject, (String)"newCollectionRecord", Boolean.TYPE, (Object)true, (int)2);
        }
        catch (Exception e) {
            LOG.error("unable to set newCollectionRecord property: " + e.getMessage(), (Throwable)e);
            throw new RuntimeException("unable to set newCollectionRecord property: " + e.getMessage(), e);
        }
        String proposalIdToLink = parameters.get("proposalId")[0];
        ((IntellectualPropertyReview)this.getBusinessObject()).setProposalIdToLink(Long.parseLong(proposalIdToLink));
    }

    private InstitutionalProposalVersioningService getInstitutionalProposalVersioningService() {
        return KcServiceLocator.getService(InstitutionalProposalVersioningService.class);
    }
}

