/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.lookup;

import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.search.SearchOperator;
import org.kuali.rice.kns.lookup.AbstractLookupableHelperServiceImpl;
import org.kuali.rice.kns.lookup.LookupUtils;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;
import org.kuali.rice.krad.datadictionary.BusinessObjectEntry;
import org.kuali.rice.krad.datadictionary.PrimitiveAttributeDefinition;
import org.kuali.rice.krad.datadictionary.RelationshipDefinition;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.util.BeanPropertyComparator;
import org.kuali.rice.krad.util.ExternalizableBusinessObjectUtils;
import org.kuali.rice.krad.util.ObjectUtils;
import org.springframework.transaction.annotation.Transactional;

@Deprecated
@Transactional
public class KualiLookupableHelperServiceImpl
extends AbstractLookupableHelperServiceImpl {
    protected static final Logger LOG = LogManager.getLogger(KualiLookupableHelperServiceImpl.class);
    protected boolean searchUsingOnlyPrimaryKeyValues = false;

    @Override
    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        return this.getSearchResultsHelper(org.kuali.rice.krad.lookup.LookupUtils.forceUppercase((Class)this.getBusinessObjectClass(), fieldValues), false);
    }

    @Override
    public List<? extends BusinessObject> getSearchResultsUnbounded(Map<String, String> fieldValues) {
        return this.getSearchResultsHelper(org.kuali.rice.krad.lookup.LookupUtils.forceUppercase((Class)this.getBusinessObjectClass(), fieldValues), true);
    }

    protected boolean isExternalBusinessObjectProperty(Object sampleBo, String propertyName) {
        try {
            if (propertyName.indexOf(".") > 0 && !StringUtils.contains((String)propertyName, (String)"add.")) {
                Class propertyClass = PropertyUtils.getPropertyType((Object)sampleBo, (String)StringUtils.substringBeforeLast((String)propertyName, (String)"."));
                if (propertyClass != null) {
                    return ExternalizableBusinessObjectUtils.isExternalizableBusinessObjectInterface((Class)propertyClass);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("unable to get class for " + StringUtils.substringBeforeLast((String)propertyName, (String)".") + " on " + sampleBo.getClass().getName());
                }
            }
        }
        catch (Exception e) {
            LOG.debug("Unable to determine type of property for " + sampleBo.getClass().getName() + "/" + propertyName, (Throwable)e);
        }
        return false;
    }

    protected String getExternalBusinessObjectProperty(Object sampleBo, String propertyName) {
        if (propertyName.indexOf(".") > 0 && !StringUtils.contains((String)propertyName, (String)"add.")) {
            return StringUtils.substringBeforeLast((String)propertyName, (String)".");
        }
        return null;
    }

    protected boolean hasExternalBusinessObjectProperty(Class boClass, Map<String, String> fieldValues) {
        try {
            Object sampleBo = boClass.newInstance();
            for (String key : fieldValues.keySet()) {
                if (!this.isExternalBusinessObjectProperty(sampleBo, key)) continue;
                return true;
            }
        }
        catch (Exception ex) {
            LOG.debug("Unable to check " + String.valueOf(boClass) + " for EBO properties.", (Throwable)ex);
        }
        return false;
    }

    protected Map<String, String> removeExternalizableBusinessObjectFieldValues(Class boClass, Map<String, String> fieldValues) {
        HashMap<String, String> eboFieldValues = new HashMap<String, String>();
        try {
            Object sampleBo = boClass.newInstance();
            for (String key : fieldValues.keySet()) {
                if (this.isExternalBusinessObjectProperty(sampleBo, key)) continue;
                eboFieldValues.put(key, fieldValues.get(key));
            }
        }
        catch (Exception ex) {
            LOG.debug("Unable to check " + String.valueOf(boClass) + " for EBO properties.", (Throwable)ex);
        }
        return eboFieldValues;
    }

    protected Map<String, String> getExternalizableBusinessObjectFieldValues(String eboPropertyName, Map<String, String> fieldValues) {
        HashMap<String, String> eboFieldValues = new HashMap<String, String>();
        for (String key : fieldValues.keySet()) {
            if (!key.startsWith(eboPropertyName + ".")) continue;
            eboFieldValues.put(StringUtils.substringAfterLast((String)key, (String)"."), fieldValues.get(key));
        }
        return eboFieldValues;
    }

    protected List<String> getExternalizableBusinessObjectProperties(Class boClass, Map<String, String> fieldValues) {
        HashSet<String> eboPropertyNames = new HashSet<String>();
        try {
            Object sampleBo = boClass.newInstance();
            for (String key : fieldValues.keySet()) {
                if (!this.isExternalBusinessObjectProperty(sampleBo, key)) continue;
                eboPropertyNames.add(StringUtils.substringBeforeLast((String)key, (String)"."));
            }
        }
        catch (Exception ex) {
            LOG.debug("Unable to check " + String.valueOf(boClass) + " for EBO properties.", (Throwable)ex);
        }
        return new ArrayList<String>(eboPropertyNames);
    }

    protected Class<? extends ExternalizableBusinessObject> getExternalizableBusinessObjectClass(Class boClass, String propertyName) {
        try {
            return PropertyUtils.getPropertyType(boClass.newInstance(), (String)StringUtils.substringBeforeLast((String)propertyName, (String)"."));
        }
        catch (Exception e) {
            LOG.debug("Unable to determine type of property for " + boClass.getName() + "/" + propertyName, (Throwable)e);
            return null;
        }
    }

    protected List<? extends BusinessObject> getSearchResultsHelper(Map<String, String> fieldValues, boolean unbounded) {
        List<String> defaultSortColumns;
        List searchResults;
        LookupUtils.removeHiddenCriteriaFields(this.getBusinessObjectClass(), fieldValues);
        this.searchUsingOnlyPrimaryKeyValues = this.getLookupService().allPrimaryKeyValuesPresentAndNotWildcard(this.getBusinessObjectClass(), fieldValues);
        this.setBackLocation(fieldValues.get("backLocation"));
        this.setDocFormKey(fieldValues.get("docFormKey"));
        this.setReferencesToRefresh(fieldValues.get("referencesToRefresh"));
        HashMap<String, String> nonBlankFieldValues = new HashMap<String, String>();
        for (String fieldName : fieldValues.keySet()) {
            String fieldValue = fieldValues.get(fieldName);
            if (!StringUtils.isNotBlank((String)fieldValue)) continue;
            if (fieldValue.endsWith("(&^#&)")) {
                String encryptedValue = StringUtils.removeEnd((String)fieldValue, (String)"(&^#&)");
                try {
                    if (CoreApiServiceLocator.getEncryptionService().isEnabled()) {
                        fieldValue = this.getEncryptionService().decrypt(encryptedValue);
                    }
                }
                catch (GeneralSecurityException e) {
                    LOG.error("Error decrypting value for business object " + String.valueOf(this.getBusinessObjectService()) + " attribute " + fieldName, (Throwable)e);
                    throw new RuntimeException("Error decrypting value for business object " + String.valueOf(this.getBusinessObjectService()) + " attribute " + fieldName, e);
                }
            }
            nonBlankFieldValues.put(fieldName, fieldValue);
        }
        if (ExternalizableBusinessObjectUtils.isExternalizableBusinessObject((Class)this.getBusinessObjectClass())) {
            ModuleService eboModuleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(this.getBusinessObjectClass());
            BusinessObjectEntry ddEntry = eboModuleService.getExternalizableBusinessObjectDictionaryEntry(this.getBusinessObjectClass());
            HashMap<String, String> filteredFieldValues = new HashMap<String, String>();
            for (String fieldName : nonBlankFieldValues.keySet()) {
                if (!ddEntry.getAttributeNames().contains(fieldName)) continue;
                filteredFieldValues.put(fieldName, (String)nonBlankFieldValues.get(fieldName));
            }
            searchResults = eboModuleService.getExternalizableBusinessObjectsListForLookup(this.getBusinessObjectClass(), filteredFieldValues, unbounded);
        } else if (this.hasExternalBusinessObjectProperty(this.getBusinessObjectClass(), nonBlankFieldValues)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("has EBO reference: " + String.valueOf(this.getBusinessObjectClass()));
                LOG.debug("properties: " + String.valueOf(nonBlankFieldValues));
            }
            Map<String, String> nonEboFieldValues = this.removeExternalizableBusinessObjectFieldValues(this.getBusinessObjectClass(), nonBlankFieldValues);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Non EBO properties removed: " + String.valueOf(nonEboFieldValues));
            }
            List<String> eboPropertyNames = this.getExternalizableBusinessObjectProperties(this.getBusinessObjectClass(), nonBlankFieldValues);
            if (LOG.isDebugEnabled()) {
                LOG.debug("EBO properties: " + String.valueOf(eboPropertyNames));
            }
            for (String eboPropertyName : eboPropertyNames) {
                Class eboParentClass;
                String eboParentPropertyName;
                Map<String, String> eboFieldValues = this.getExternalizableBusinessObjectFieldValues(eboPropertyName, nonBlankFieldValues);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("EBO properties for master EBO property: " + eboPropertyName);
                    LOG.debug("properties: " + String.valueOf(eboFieldValues));
                }
                ModuleService eboModuleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(this.getExternalizableBusinessObjectClass(this.getBusinessObjectClass(), eboPropertyName));
                List eboResults = Collections.emptyList();
                if (eboModuleService != null) {
                    eboResults = eboModuleService.getExternalizableBusinessObjectsListForLookup(this.getExternalizableBusinessObjectClass(this.getBusinessObjectClass(), eboPropertyName), eboFieldValues, unbounded);
                } else {
                    LOG.debug("EBO ModuleService is null: " + eboPropertyName);
                }
                if (ObjectUtils.isNestedAttribute(eboPropertyName)) {
                    eboParentPropertyName = StringUtils.substringBeforeLast((String)eboPropertyName, (String)".");
                    try {
                        eboParentClass = PropertyUtils.getPropertyType(this.getBusinessObjectClass().newInstance(), (String)eboParentPropertyName);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException("Unable to create an instance of the business object class: " + this.getBusinessObjectClass().getName(), ex);
                    }
                } else {
                    eboParentClass = this.getBusinessObjectClass();
                    eboParentPropertyName = null;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("determined EBO parent class/property name: " + String.valueOf(eboParentClass) + "/" + eboParentPropertyName);
                }
                RelationshipDefinition rd = this.getBusinessObjectMetaDataService().getBusinessObjectRelationshipDefinition(eboParentClass, eboPropertyName);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Obtained RelationshipDefinition for " + eboPropertyName);
                    LOG.debug((Object)rd);
                }
                if (!ObjectUtils.isNotNull(rd)) continue;
                if (rd.getPrimitiveAttributes().size() > 1) {
                    throw new RuntimeException("EBO Links don't work for relationships with multiple-field primary keys.");
                }
                String boProperty = ((PrimitiveAttributeDefinition)rd.getPrimitiveAttributes().get(0)).getSourceName();
                String eboProperty = ((PrimitiveAttributeDefinition)rd.getPrimitiveAttributes().get(0)).getTargetName();
                StringBuffer boPropertyValue = new StringBuffer();
                for (Object ebo : eboResults) {
                    if (boPropertyValue.length() != 0) {
                        boPropertyValue.append(SearchOperator.OR.op());
                    }
                    try {
                        boPropertyValue.append(PropertyUtils.getProperty(ebo, (String)eboProperty).toString());
                    }
                    catch (Exception ex) {
                        LOG.warn("Unable to get value for " + eboProperty + " on " + String.valueOf(ebo), (Throwable)ex);
                    }
                }
                if (eboParentPropertyName == null) {
                    nonEboFieldValues.put(boProperty, boPropertyValue.toString());
                    continue;
                }
                nonEboFieldValues.put(eboParentPropertyName + "." + boProperty, boPropertyValue.toString());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Passing these results into the lookup service: " + String.valueOf(nonEboFieldValues));
            }
            searchResults = (List)this.getLookupService().findCollectionBySearchHelper(this.getBusinessObjectClass(), nonEboFieldValues, unbounded);
        } else {
            searchResults = (ArrayList)this.getLookupService().findCollectionBySearchHelper(this.getBusinessObjectClass(), nonBlankFieldValues, unbounded);
        }
        if (searchResults == null) {
            searchResults = new ArrayList();
        }
        if ((defaultSortColumns = this.getDefaultSortColumns()).size() > 0) {
            Collections.sort(searchResults, new BeanPropertyComparator(defaultSortColumns, true));
        }
        return searchResults;
    }

    @Override
    public boolean isSearchUsingOnlyPrimaryKeyValues() {
        return this.searchUsingOnlyPrimaryKeyValues;
    }

    @Override
    public String getPrimaryKeyFieldLabels() {
        StringBuilder buf = new StringBuilder();
        List primaryKeyFieldNames = KRADServiceLocatorWeb.getLegacyDataAdapter().listPrimaryKeyFieldNames(this.getBusinessObjectClass());
        Iterator pkIter = primaryKeyFieldNames.iterator();
        while (pkIter.hasNext()) {
            String pkFieldName = (String)pkIter.next();
            buf.append(this.getDataDictionaryService().getAttributeLabel(this.getBusinessObjectClass(), pkFieldName));
            if (!pkIter.hasNext()) continue;
            buf.append(", ");
        }
        return buf.length() == 0 ? "N/A" : buf.toString();
    }
}

