/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.InlineKradAdaptor;
import freemarker.core.ParameterRole;
import freemarker.core.TemplateElement;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class InlineKradElement
extends TemplateElement {
    private static final Map ADAPTORS = new HashMap();
    private final Expression adaptorNameExp;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerAdaptor(String name, InlineKradAdaptor adaptor) {
        Map map = ADAPTORS;
        synchronized (map) {
            ADAPTORS.put(name, adaptor);
        }
    }

    public InlineKradElement(Expression adaptorNameExp) {
        this.adaptorNameExp = adaptorNameExp;
    }

    private InlineKradAdaptor getAdaptor(Environment env, String adaptorName) throws TemplateException {
        InlineKradAdaptor adaptor = (InlineKradAdaptor)ADAPTORS.get(adaptorName);
        if (adaptor == null) {
            throw new TemplateException("Inline KRAD adaptor " + adaptorName + " not registered", env);
        }
        return adaptor;
    }

    void accept(Environment env) throws TemplateException, IOException {
        String adaptorName = this.adaptorNameExp.evalAndCoerceToString(env);
        this.getAdaptor(env, adaptorName).accept(env);
    }

    protected String dump(boolean canonical) {
        return "<#krad_inline " + this.adaptorNameExp.getCanonicalForm() + " />";
    }

    String getNodeTypeSymbol() {
        return "#krad_inline-" + this.adaptorNameExp.getCanonicalForm();
    }

    int getParameterCount() {
        return 0;
    }

    Object getParameterValue(int idx) {
        return null;
    }

    ParameterRole getParameterRole(int idx) {
        return null;
    }
}

