/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.framework.lifecycle;

import javax.xml.namespace.QName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.lifecycle.BaseLifecycle;
import org.kuali.rice.core.api.lifecycle.Lifecycle;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;

public class ServiceDelegatingLifecycle
extends BaseLifecycle {
    private static final Logger LOG = LogManager.getLogger(BaseLifecycle.class);
    private QName serviceName;
    private Lifecycle service;

    public ServiceDelegatingLifecycle(QName serviceName) {
        this.serviceName = serviceName;
    }

    public ServiceDelegatingLifecycle(String serviceName) {
        this(new QName(serviceName));
    }

    public void start() throws Exception {
        if (!this.isStarted()) {
            this.service = this.loadService(this.serviceName);
            if (this.service == null) {
                throw new IllegalStateException("Failed to load the service with the given name: " + String.valueOf(this.serviceName));
            }
            this.service.start();
        }
        super.start();
    }

    public void stop() throws Exception {
        if (this.isStarted()) {
            try {
                if (this.service == null) {
                    LOG.warn("Couldn't stop service, failed to locate service with name " + String.valueOf(this.serviceName));
                } else {
                    this.service.stop();
                }
            }
            catch (Exception e) {
                LOG.warn("couldn't stop service " + String.valueOf(this.serviceName), (Throwable)e);
            }
        }
        this.service = null;
        super.stop();
    }

    protected Lifecycle loadService(QName serviceName) {
        Object service = GlobalResourceLoader.getService((QName)serviceName);
        if (service == null) {
            return null;
        }
        if (!(service instanceof Lifecycle)) {
            throw new IllegalStateException("Service with name " + String.valueOf(serviceName) + " does not implement the Lifecycle interface!");
        }
        return (Lifecycle)service;
    }
}

