/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.codecs;

import java.util.regex.Pattern;
import org.owasp.esapi.codecs.AbstractCharacterCodec;
import org.owasp.esapi.codecs.PushbackSequence;
import org.owasp.esapi.codecs.PushbackString;
import org.owasp.esapi.codecs.ref.EncodingPatternPreservation;

public class CSSCodec
extends AbstractCharacterCodec {
    private static final Character REPLACEMENT = Character.valueOf('\ufffd');
    private static final String RGB_TRPLT = "([rR][gG][bB])\\s*\\(\\s*\\d{1,3}\\s*(\\%)?\\s*,\\s*\\d{1,3}\\s*(\\%)?\\s*,\\s*\\d{1,3}\\s*(\\%)?\\s*\\)";
    private static final Pattern RGB_TRPLT_PATTERN = Pattern.compile("([rR][gG][bB])\\s*\\(\\s*\\d{1,3}\\s*(\\%)?\\s*,\\s*\\d{1,3}\\s*(\\%)?\\s*,\\s*\\d{1,3}\\s*(\\%)?\\s*\\)");

    @Override
    public String encode(char[] immune, String input) {
        EncodingPatternPreservation tripletCheck = new EncodingPatternPreservation(RGB_TRPLT_PATTERN);
        String inputChk = tripletCheck.captureAndReplaceMatches(input);
        String result = super.encode(immune, inputChk);
        return tripletCheck.restoreOriginalContent(result);
    }

    @Override
    public String encodeCharacter(char[] immune, Character c) {
        if (this.containsCharacter(c.charValue(), immune)) {
            return "" + c;
        }
        String hex = super.getHexForNonAlphanumeric(c.charValue());
        if (hex == null) {
            return "" + c;
        }
        return "\\" + hex + " ";
    }

    @Override
    public Character decodeCharacter(PushbackSequence<Character> input) {
        Character c;
        int i;
        input.mark();
        Character first = input.next();
        if (first == null || first.charValue() != '\\') {
            input.reset();
            return null;
        }
        Character second = input.next();
        if (second == null) {
            input.reset();
            return null;
        }
        switch (second.charValue()) {
            case '\r': {
                if (input.peek(Character.valueOf('\n'))) {
                    input.next();
                }
            }
            case '\u0000': 
            case '\n': 
            case '\f': {
                return this.decodeCharacter((PushbackSequence)input);
            }
        }
        if (!PushbackString.isHexDigit(second)) {
            return second;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(second);
        for (i = 0; i < 5 && (c = input.next()) != null && !Character.isWhitespace(c.charValue()); ++i) {
            if (!PushbackString.isHexDigit(c)) {
                input.pushback(c);
                break;
            }
            sb.append(c);
        }
        try {
            i = Integer.parseInt(sb.toString(), 16);
            if (Character.isValidCodePoint(i)) {
                return Character.valueOf((char)i);
            }
            return REPLACEMENT;
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("Received a NumberFormateException parsing a string verified to be hex", e);
        }
    }
}

