/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.info;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.node.ReportingService;
import org.elasticsearch.plugins.PluginDescriptor;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class PluginsAndModules
implements ReportingService.Info {
    private final List<PluginDescriptor> plugins;
    private final List<PluginDescriptor> modules;

    public PluginsAndModules(List<PluginDescriptor> plugins, List<PluginDescriptor> modules) {
        this.plugins = Collections.unmodifiableList(plugins);
        this.modules = Collections.unmodifiableList(modules);
    }

    public PluginsAndModules(StreamInput in) throws IOException {
        this.plugins = Collections.unmodifiableList(in.readList(PluginDescriptor::new));
        this.modules = Collections.unmodifiableList(in.readList(PluginDescriptor::new));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.plugins);
        out.writeList(this.modules);
    }

    public List<PluginDescriptor> getPluginInfos() {
        ArrayList<PluginDescriptor> plugins = new ArrayList<PluginDescriptor>(this.plugins);
        Collections.sort(plugins, Comparator.comparing(PluginDescriptor::getName));
        return plugins;
    }

    public List<PluginDescriptor> getModuleInfos() {
        ArrayList<PluginDescriptor> modules = new ArrayList<PluginDescriptor>(this.modules);
        Collections.sort(modules, Comparator.comparing(PluginDescriptor::getName));
        return modules;
    }

    public void addPlugin(PluginDescriptor info) {
        this.plugins.add(info);
    }

    public void addModule(PluginDescriptor info) {
        this.modules.add(info);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray("plugins");
        for (PluginDescriptor pluginDescriptor : this.getPluginInfos()) {
            pluginDescriptor.toXContent(builder, params);
        }
        builder.endArray();
        builder.startArray("modules");
        for (PluginDescriptor moduleInfo : this.getModuleInfos()) {
            moduleInfo.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }
}

