/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.util.Locale;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.common.util.LongLongHash;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;

public abstract class LongKeyedBucketOrds
implements Releasable {
    public static LongKeyedBucketOrds build(BigArrays bigArrays, CardinalityUpperBound cardinality) {
        return cardinality.map(estimate -> estimate < 2 ? new FromSingle(bigArrays) : new FromMany(bigArrays));
    }

    public static LongKeyedBucketOrds buildForValueRange(BigArrays bigArrays, CardinalityUpperBound cardinality, long min, long max) {
        return cardinality.map(cardinalityUpperBound -> {
            if (cardinalityUpperBound < 2) {
                return new FromSingle(bigArrays);
            }
            if (min < 0L || cardinalityUpperBound == Integer.MAX_VALUE) {
                return new FromMany(bigArrays);
            }
            int owningBucketOrdShift = Long.numberOfLeadingZeros(cardinalityUpperBound);
            int maxBits = 64 - Long.numberOfLeadingZeros(max);
            if (maxBits < owningBucketOrdShift) {
                return new FromManySmall(bigArrays, owningBucketOrdShift);
            }
            return new FromMany(bigArrays);
        });
    }

    private LongKeyedBucketOrds() {
    }

    public abstract long add(long var1, long var3);

    public abstract long bucketsInOrd(long var1);

    public abstract long find(long var1, long var3);

    public abstract long get(long var1);

    public abstract long size();

    public abstract long maxOwningBucketOrd();

    public abstract String decribe();

    public abstract BucketOrdsEnum ordsEnum(long var1);

    public static class FromSingle
    extends LongKeyedBucketOrds {
        private final LongHash ords;

        public FromSingle(BigArrays bigArrays) {
            this.ords = new LongHash(1L, bigArrays);
        }

        @Override
        public long add(long owningBucketOrd, long value) {
            assert (owningBucketOrd == 0L);
            return this.ords.add(value);
        }

        @Override
        public long find(long owningBucketOrd, long value) {
            assert (owningBucketOrd == 0L);
            return this.ords.find(value);
        }

        @Override
        public long get(long ordinal) {
            return this.ords.get(ordinal);
        }

        @Override
        public long bucketsInOrd(long owningBucketOrd) {
            assert (owningBucketOrd == 0L);
            return this.ords.size();
        }

        @Override
        public long size() {
            return this.ords.size();
        }

        @Override
        public long maxOwningBucketOrd() {
            return 0L;
        }

        @Override
        public String decribe() {
            return "single bucket ords";
        }

        @Override
        public BucketOrdsEnum ordsEnum(long owningBucketOrd) {
            assert (owningBucketOrd == 0L);
            return new BucketOrdsEnum(){
                private long ord = -1L;
                private long value;

                @Override
                public boolean next() {
                    ++this.ord;
                    if (this.ord >= ords.size()) {
                        return false;
                    }
                    this.value = ords.get(this.ord);
                    return true;
                }

                @Override
                public long value() {
                    return this.value;
                }

                @Override
                public long ord() {
                    return this.ord;
                }
            };
        }

        public void close() {
            this.ords.close();
        }
    }

    public static class FromMany
    extends LongKeyedBucketOrds {
        private final LongLongHash ords;

        public FromMany(BigArrays bigArrays) {
            this.ords = new LongLongHash(2L, bigArrays);
        }

        @Override
        public long add(long owningBucketOrd, long value) {
            return this.ords.add(owningBucketOrd, value);
        }

        @Override
        public long find(long owningBucketOrd, long value) {
            return this.ords.find(owningBucketOrd, value);
        }

        @Override
        public long get(long ordinal) {
            return this.ords.getKey2(ordinal);
        }

        @Override
        public long bucketsInOrd(long owningBucketOrd) {
            long count = 0L;
            for (long i = 0L; i < this.ords.size(); ++i) {
                if (this.ords.getKey1(i) != owningBucketOrd) continue;
                ++count;
            }
            return count;
        }

        @Override
        public long size() {
            return this.ords.size();
        }

        @Override
        public long maxOwningBucketOrd() {
            long max = -1L;
            for (long i = 0L; i < this.ords.size(); ++i) {
                max = Math.max(max, this.ords.getKey1(i));
            }
            return max;
        }

        @Override
        public String decribe() {
            return "many bucket ords";
        }

        @Override
        public BucketOrdsEnum ordsEnum(final long owningBucketOrd) {
            return new BucketOrdsEnum(){
                private long ord = -1L;
                private long value;

                @Override
                public boolean next() {
                    do {
                        ++this.ord;
                        if (this.ord < ords.size()) continue;
                        return false;
                    } while (ords.getKey1(this.ord) != owningBucketOrd);
                    this.value = ords.getKey2(this.ord);
                    return true;
                }

                @Override
                public long value() {
                    return this.value;
                }

                @Override
                public long ord() {
                    return this.ord;
                }
            };
        }

        public void close() {
            this.ords.close();
        }
    }

    public static class FromManySmall
    extends LongKeyedBucketOrds {
        private final LongHash ords;
        private final int owningBucketOrdShift;
        private final long owningBucketOrdMask;

        public FromManySmall(BigArrays bigArrays, int owningBucketOrdShift) {
            this.ords = new LongHash(2L, bigArrays);
            this.owningBucketOrdShift = owningBucketOrdShift;
            this.owningBucketOrdMask = -1L << owningBucketOrdShift;
        }

        private long encode(long owningBucketOrd, long value) {
            return owningBucketOrd << this.owningBucketOrdShift | value;
        }

        @Override
        public long add(long owningBucketOrd, long value) {
            long enc = this.encode(owningBucketOrd, value);
            if (owningBucketOrd != enc >>> this.owningBucketOrdShift && (enc & (this.owningBucketOrdMask ^ 0xFFFFFFFFFFFFFFFFL)) != value) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "[%s] and [%s] must fit in [%s..%s] bits", owningBucketOrd, value, 64 - this.owningBucketOrdShift, this.owningBucketOrdShift));
            }
            return this.ords.add(enc);
        }

        @Override
        public long find(long owningBucketOrd, long value) {
            if (Long.numberOfLeadingZeros(owningBucketOrd) < this.owningBucketOrdShift) {
                return -1L;
            }
            if ((value & this.owningBucketOrdMask) != 0L) {
                return -1L;
            }
            return this.ords.find(this.encode(owningBucketOrd, value));
        }

        @Override
        public long get(long ordinal) {
            return this.ords.get(ordinal) & (this.owningBucketOrdMask ^ 0xFFFFFFFFFFFFFFFFL);
        }

        @Override
        public long bucketsInOrd(long owningBucketOrd) {
            if (Long.numberOfLeadingZeros(owningBucketOrd) < this.owningBucketOrdShift) {
                return 0L;
            }
            long count = 0L;
            long enc = owningBucketOrd << this.owningBucketOrdShift;
            for (long i = 0L; i < this.ords.size(); ++i) {
                if ((this.ords.get(i) & this.owningBucketOrdMask) != enc) continue;
                ++count;
            }
            return count;
        }

        @Override
        public long size() {
            return this.ords.size();
        }

        @Override
        public long maxOwningBucketOrd() {
            long max = -1L;
            for (long i = 0L; i < this.ords.size(); ++i) {
                max = Math.max(max, (this.ords.get(i) & this.owningBucketOrdMask) >>> this.owningBucketOrdShift);
            }
            return max;
        }

        @Override
        public String decribe() {
            return "many bucket ords packed using [" + (64 - this.owningBucketOrdShift) + "/" + this.owningBucketOrdShift + "] bits";
        }

        @Override
        public BucketOrdsEnum ordsEnum(long owningBucketOrd) {
            if (Long.numberOfLeadingZeros(owningBucketOrd) < this.owningBucketOrdShift) {
                return BucketOrdsEnum.EMPTY;
            }
            final long encodedOwningBucketOrd = owningBucketOrd << this.owningBucketOrdShift;
            return new BucketOrdsEnum(){
                private long ord = -1L;
                private long value;

                @Override
                public boolean next() {
                    long encoded;
                    do {
                        ++this.ord;
                        if (this.ord < ords.size()) continue;
                        return false;
                    } while (((encoded = ords.get(this.ord)) & owningBucketOrdMask) != encodedOwningBucketOrd);
                    this.value = encoded & (owningBucketOrdMask ^ 0xFFFFFFFFFFFFFFFFL);
                    return true;
                }

                @Override
                public long value() {
                    return this.value;
                }

                @Override
                public long ord() {
                    return this.ord;
                }
            };
        }

        public void close() {
            this.ords.close();
        }
    }

    public static interface BucketOrdsEnum {
        public static final BucketOrdsEnum EMPTY = new BucketOrdsEnum(){

            @Override
            public boolean next() {
                return false;
            }

            @Override
            public long ord() {
                return 0L;
            }

            @Override
            public long value() {
                return 0L;
            }
        };

        public boolean next();

        public long ord();

        public long value();
    }
}

