/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.runtime;

import com.carrotsearch.hppc.LongSet;
import com.carrotsearch.hppc.cursors.LongCursor;
import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.script.DoubleFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.runtime.AbstractDoubleScriptFieldQuery;

public class DoubleScriptFieldTermsQuery
extends AbstractDoubleScriptFieldQuery {
    private final LongSet terms;

    public DoubleScriptFieldTermsQuery(Script script, DoubleFieldScript.LeafFactory leafFactory, String fieldName, LongSet terms) {
        super(script, leafFactory, fieldName);
        this.terms = terms;
    }

    @Override
    protected boolean matches(double[] values, int count) {
        for (int i = 0; i < count; ++i) {
            if (!this.terms.contains(Double.doubleToLongBits(values[i]))) continue;
            return true;
        }
        return false;
    }

    public final String toString(String field) {
        double[] termsArray = this.terms();
        Arrays.sort(termsArray);
        if (this.fieldName().equals(field)) {
            return Arrays.toString(termsArray);
        }
        return this.fieldName() + ":" + Arrays.toString(termsArray);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.terms);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        DoubleScriptFieldTermsQuery other = (DoubleScriptFieldTermsQuery)((Object)obj);
        return this.terms.equals(other.terms);
    }

    double[] terms() {
        double[] result = new double[this.terms.size()];
        int i = 0;
        for (LongCursor lc : this.terms) {
            result[i++] = Double.longBitsToDouble(lc.value);
        }
        return result;
    }
}

