/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.util;

import java.util.ArrayList;
import org.displaytag.util.HtmlAttributeMap;

public final class HtmlTagUtil {
    private HtmlTagUtil() {
    }

    public static String createOpenTagString(String tagName, HtmlAttributeMap attributes) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("\n<").append(tagName);
        if (attributes != null) {
            buffer.append(attributes.toString());
        }
        buffer.append(">");
        return buffer.toString();
    }

    public static String stripHTMLTags(String str) {
        int len = str.length();
        char[] value = str.toCharArray();
        StringBuilder dest = new StringBuilder(len + 16);
        boolean intag = false;
        block4: for (int j = 0; j < len; ++j) {
            char c = value[j];
            if (intag) {
                if (c != '>') continue;
                intag = false;
                continue;
            }
            switch (c) {
                case '\"': {
                    dest.append("&quot;");
                    continue block4;
                }
                case '<': {
                    intag = true;
                    continue block4;
                }
                default: {
                    dest.append(c);
                }
            }
        }
        return dest.toString();
    }

    public static String abbreviateHtmlString(String str, int maxLength, boolean byNumberOfWords) {
        int i;
        if (str == null || str.length() <= maxLength) {
            return str;
        }
        int sz = str.length();
        StringBuilder buffer = new StringBuilder(sz);
        boolean inTag = false;
        boolean inTagName = false;
        boolean endingTag = false;
        int count = 0;
        boolean chopped = false;
        int entityChars = 0;
        StringBuilder currentTag = new StringBuilder(5);
        ArrayList<String> openTags = new ArrayList<String>(5);
        for (i = 0; i < sz; ++i) {
            if (count >= maxLength) {
                chopped = true;
                break;
            }
            char c = str.charAt(i);
            if (c == '<') {
                inTag = true;
                inTagName = true;
            } else if (inTag) {
                if (inTagName && c == '/') {
                    if (currentTag.length() == 0) {
                        endingTag = true;
                    } else {
                        inTagName = false;
                    }
                    currentTag = new StringBuilder(5);
                } else if (inTagName && (c == ' ' || c == '>')) {
                    inTagName = false;
                    if (!endingTag) {
                        openTags.add(currentTag.toString());
                    } else {
                        openTags.remove(currentTag.toString());
                    }
                    currentTag = new StringBuilder(5);
                    if (c == '>') {
                        inTag = false;
                    }
                } else if (c == '>') {
                    inTag = false;
                } else if (inTagName) {
                    currentTag.append(c);
                }
            } else if (byNumberOfWords) {
                if (Character.isWhitespace(c)) {
                    ++count;
                }
            } else if (c == '&') {
                entityChars = 1;
            } else if (entityChars == 0) {
                ++count;
            } else {
                if (entityChars > 0 && c == ';') {
                    entityChars = 0;
                    ++count;
                } else {
                    ++entityChars;
                }
                if (entityChars > 5) {
                    count += entityChars;
                    entityChars = 0;
                }
            }
            if (!inTag && byNumberOfWords && count >= maxLength) continue;
            buffer.append(c);
        }
        if (chopped) {
            buffer.append("...");
        }
        if (!openTags.isEmpty()) {
            String remainingToken = str.substring(i);
            for (int j = openTags.size() - 1; j >= 0; --j) {
                String closingTag = "</" + (String)openTags.get(j) + ">";
                if (remainingToken.indexOf(closingTag) <= -1) continue;
                buffer.append(closingTag);
            }
        }
        return buffer.toString();
    }
}

