/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.auth;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.controller.rest.SimpleCrudMapBasedRestController;
import org.kuali.coeus.sys.framework.rest.ResourceNotFoundException;
import org.kuali.coeus.sys.framework.util.CollectionUtils;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kim.impl.permission.PermissionTemplateBo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

public class PermissionTemplateController
extends SimpleCrudMapBasedRestController<PermissionTemplateBo> {
    private static final String QUALIFIER_NAME_VALUE_DELIMETER = ":";
    @Autowired
    @Qualifier(value="permissionService")
    private PermissionService permissionService;

    @RequestMapping(method={RequestMethod.GET}, value={"{templateName}/namespace/{namespace}/principals/{memberId}"})
    @ResponseBody
    public Boolean hasPermission(@PathVariable String templateName, @PathVariable String namespace, @PathVariable String memberId, @RequestParam(value="details", required=false) String[] details, @RequestParam(value="qualification", required=false) String[] qualification) {
        this.assertMethodSupported(RequestMethod.GET);
        if (StringUtils.isBlank((CharSequence)templateName)) {
            throw new ResourceNotFoundException("templateName is blank");
        }
        if (StringUtils.isBlank((CharSequence)namespace)) {
            throw new ResourceNotFoundException("namespace is blank");
        }
        if (StringUtils.isBlank((CharSequence)memberId)) {
            throw new ResourceNotFoundException("memberId is blank");
        }
        return this.permissionService.isAuthorizedByTemplate(memberId, namespace, templateName, this.getQualifierMap(details != null ? Arrays.asList(details) : Collections.emptyList()), this.getQualifierMap(qualification != null ? Arrays.asList(qualification) : Collections.emptyList()));
    }

    protected Map<String, String> getQualifierMap(List<String> qualification) {
        return qualification.stream().map(qualifier -> {
            String[] q = qualifier.split(QUALIFIER_NAME_VALUE_DELIMETER);
            return CollectionUtils.entry(q[0], q[1]);
        }).collect(CollectionUtils.entriesToMap());
    }
}

