/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.composite;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.bucket.composite.MissingOrder;
import org.elasticsearch.search.aggregations.bucket.composite.SingleDimensionValuesSource;
import org.elasticsearch.search.aggregations.bucket.composite.SortedDocsProducer;
import org.elasticsearch.search.aggregations.bucket.composite.TermsSortedDocsProducer;

class GlobalOrdinalValuesSource
extends SingleDimensionValuesSource<BytesRef> {
    public static final long MISSING_VALUE_FLAG = -1L;
    private final CheckedFunction<LeafReaderContext, SortedSetDocValues, IOException> docValuesFunc;
    private LongArray values;
    private SortedSetDocValues lookup;
    private long currentValue;
    private Long afterValueGlobalOrd;
    private boolean isTopValueInsertionPoint;
    private long lastLookupOrd = -1L;
    private BytesRef lastLookupValue;

    GlobalOrdinalValuesSource(BigArrays bigArrays, MappedFieldType type, CheckedFunction<LeafReaderContext, SortedSetDocValues, IOException> docValuesFunc, DocValueFormat format, boolean missingBucket, MissingOrder missingOrder, int size, int reverseMul) {
        super(bigArrays, format, type, missingBucket, missingOrder, size, reverseMul);
        this.docValuesFunc = docValuesFunc;
        this.values = bigArrays.newLongArray(Math.min(size, 100), false);
    }

    @Override
    void copyCurrent(int slot) {
        this.values = this.bigArrays.grow(this.values, (long)(slot + 1));
        this.values.set(slot, this.currentValue);
    }

    private int compareInternal(long lhs, long rhs) {
        int mul = lhs == -1L || rhs == -1L ? this.missingOrder.compareAnyValueToMissing(this.reverseMul) : this.reverseMul;
        return Long.compare(lhs, rhs) * mul;
    }

    @Override
    int compare(int from, int to) {
        return this.compareInternal(this.values.get(from), this.values.get(to));
    }

    @Override
    int compareCurrent(int slot) {
        return this.compareInternal(this.currentValue, this.values.get(slot));
    }

    @Override
    int compareCurrentWithAfter() {
        int cmp = this.compareInternal(this.currentValue, this.afterValueGlobalOrd);
        if (cmp == 0 && this.isTopValueInsertionPoint) {
            return this.missingOrder.compareAnyValueToMissing(this.reverseMul);
        }
        return cmp;
    }

    @Override
    int hashCode(int slot) {
        return Long.hashCode(this.values.get(slot));
    }

    @Override
    int hashCodeCurrent() {
        return Long.hashCode(this.currentValue);
    }

    @Override
    void setAfter(Comparable<?> value) {
        if (this.missingBucket && value == null) {
            this.afterValue = null;
            this.afterValueGlobalOrd = -1L;
        } else if (value.getClass() == String.class || this.fieldType == null) {
            this.afterValue = this.format.parseBytesRef(value.toString());
        } else {
            throw new IllegalArgumentException("invalid value, expected string, got " + value.getClass().getSimpleName());
        }
    }

    @Override
    BytesRef toComparable(int slot) throws IOException {
        long globalOrd = this.values.get(slot);
        if (this.missingBucket && globalOrd == -1L) {
            return null;
        }
        if (globalOrd == this.lastLookupOrd) {
            return this.lastLookupValue;
        }
        this.lastLookupOrd = globalOrd;
        this.lastLookupValue = BytesRef.deepCopyOf((BytesRef)this.lookup.lookupOrd(this.values.get(slot)));
        return this.lastLookupValue;
    }

    @Override
    LeafBucketCollector getLeafCollector(LeafReaderContext context, final LeafBucketCollector next) throws IOException {
        final SortedSetDocValues dvs = (SortedSetDocValues)this.docValuesFunc.apply((Object)context);
        if (this.lookup == null) {
            this.initLookup(dvs);
        }
        return new LeafBucketCollector(){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (dvs.advanceExact(doc)) {
                    long ord;
                    while ((ord = dvs.nextOrd()) != -1L) {
                        GlobalOrdinalValuesSource.this.currentValue = ord;
                        next.collect(doc, bucket);
                    }
                } else if (GlobalOrdinalValuesSource.this.missingBucket) {
                    GlobalOrdinalValuesSource.this.currentValue = -1L;
                    next.collect(doc, bucket);
                }
            }
        };
    }

    @Override
    LeafBucketCollector getLeafCollector(Comparable<BytesRef> value, LeafReaderContext context, final LeafBucketCollector next) throws IOException {
        if (value.getClass() != BytesRef.class) {
            throw new IllegalArgumentException("Expected BytesRef, got " + value.getClass());
        }
        final BytesRef term = (BytesRef)value;
        final SortedSetDocValues dvs = (SortedSetDocValues)this.docValuesFunc.apply((Object)context);
        if (this.lookup == null) {
            this.initLookup(dvs);
        }
        return new LeafBucketCollector(){
            boolean currentValueIsSet = false;

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (!this.currentValueIsSet && dvs.advanceExact(doc)) {
                    long ord;
                    while ((ord = dvs.nextOrd()) != -1L) {
                        if (!term.equals((Object)GlobalOrdinalValuesSource.this.lookup.lookupOrd(ord))) continue;
                        this.currentValueIsSet = true;
                        GlobalOrdinalValuesSource.this.currentValue = ord;
                        break;
                    }
                }
                assert (this.currentValueIsSet);
                next.collect(doc, bucket);
            }
        };
    }

    @Override
    SortedDocsProducer createSortedDocsProducerOrNull(IndexReader reader, Query query) {
        if (!this.checkIfSortedDocsIsApplicable(reader, this.fieldType) || !(this.fieldType instanceof StringFieldType) || query != null && query.getClass() != MatchAllDocsQuery.class) {
            return null;
        }
        return new TermsSortedDocsProducer(this.fieldType.name());
    }

    public void close() {
        Releasables.close((Releasable)this.values);
    }

    private void initLookup(SortedSetDocValues dvs) throws IOException {
        this.lookup = dvs;
        if (this.afterValue != null && this.afterValueGlobalOrd == null) {
            this.afterValueGlobalOrd = this.lookup.lookupTerm((BytesRef)this.afterValue);
            if (this.afterValueGlobalOrd < 0L) {
                this.afterValueGlobalOrd = -this.afterValueGlobalOrd.longValue() - 1L;
                this.isTopValueInsertionPoint = true;
            }
        }
    }
}

