/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.job.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;

public enum DetectorFunction {
    COUNT,
    LOW_COUNT,
    HIGH_COUNT,
    NON_ZERO_COUNT("nzc"),
    LOW_NON_ZERO_COUNT("low_nzc"),
    HIGH_NON_ZERO_COUNT("high_nzc"),
    DISTINCT_COUNT("dc"),
    LOW_DISTINCT_COUNT("low_dc"),
    HIGH_DISTINCT_COUNT("high_dc"),
    RARE,
    FREQ_RARE,
    INFO_CONTENT,
    LOW_INFO_CONTENT,
    HIGH_INFO_CONTENT,
    METRIC,
    MEAN,
    LOW_MEAN,
    HIGH_MEAN,
    AVG,
    LOW_AVG,
    HIGH_AVG,
    MEDIAN,
    LOW_MEDIAN,
    HIGH_MEDIAN,
    MIN,
    MAX,
    SUM,
    LOW_SUM,
    HIGH_SUM,
    NON_NULL_SUM,
    LOW_NON_NULL_SUM,
    HIGH_NON_NULL_SUM,
    VARP,
    LOW_VARP,
    HIGH_VARP,
    TIME_OF_DAY,
    TIME_OF_WEEK,
    LAT_LONG;

    private Set<String> shortcuts;

    private DetectorFunction() {
        this.shortcuts = Collections.emptySet();
    }

    private DetectorFunction(String ... shortcuts) {
        this.shortcuts = Arrays.stream(shortcuts).collect(Collectors.toSet());
    }

    public String getFullName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public String toString() {
        return this.getFullName();
    }

    public static DetectorFunction fromString(String op) {
        for (DetectorFunction function : DetectorFunction.values()) {
            if (!function.getFullName().equals(op) && !function.shortcuts.contains(op)) continue;
            return function;
        }
        throw new IllegalArgumentException("Unknown detector function [" + op + "]");
    }
}

