/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.krad.datadictionary.BusinessObjectEntry;
import org.kuali.rice.krad.datadictionary.DataDictionaryEntry;
import org.kuali.rice.krad.datadictionary.DataDictionaryIndex;
import org.kuali.rice.krad.datadictionary.DataDictionaryMapper;
import org.kuali.rice.krad.datadictionary.DataObjectEntry;
import org.kuali.rice.krad.datadictionary.DocumentEntry;
import org.kuali.rice.krad.datadictionary.InactivationBlockingMetadata;
import org.kuali.rice.krad.datadictionary.MaintenanceDocumentEntry;
import org.kuali.rice.krad.datadictionary.uif.UifDictionaryIndex;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.view.View;
import org.springframework.beans.PropertyValues;

public class DataDictionaryIndexMapper
implements DataDictionaryMapper {
    private static final Logger LOG = LogManager.getLogger(DataDictionaryIndexMapper.class);

    @Override
    public Set<InactivationBlockingMetadata> getAllInactivationBlockingMetadatas(DataDictionaryIndex index, Class<?> blockedClass) {
        return index.getInactivationBlockersForClass().get(blockedClass);
    }

    @Override
    public List<String> getBusinessObjectClassNames(DataDictionaryIndex index) {
        ArrayList<String> classNames = new ArrayList<String>();
        classNames.addAll(index.getBusinessObjectEntries().keySet());
        return Collections.unmodifiableList(classNames);
    }

    @Override
    public Map<String, BusinessObjectEntry> getBusinessObjectEntries(DataDictionaryIndex index) {
        return index.getBusinessObjectEntries();
    }

    @Override
    public Map<String, DataObjectEntry> getDataObjectEntries(DataDictionaryIndex index) {
        return index.getDataObjectEntries();
    }

    @Override
    public DataObjectEntry getDataObjectEntryForConcreteClass(DataDictionaryIndex ddIndex, String className) {
        if (StringUtils.isBlank((String)className)) {
            throw new IllegalArgumentException("invalid (blank) className");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("calling getDataObjectEntry '" + className + "'");
        }
        String trimmedClassName = className;
        int index = className.indexOf("$$");
        if (index >= 0) {
            trimmedClassName = className.substring(0, index);
        }
        return ddIndex.getDataObjectEntries().get(trimmedClassName);
    }

    @Override
    public BusinessObjectEntry getBusinessObjectEntryForConcreteClass(DataDictionaryIndex ddIndex, String className) {
        int index;
        if (StringUtils.isBlank((String)className)) {
            throw new IllegalArgumentException("invalid (blank) className");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("calling getBusinessObjectEntry '" + className + "'");
        }
        if ((index = className.indexOf("$$")) >= 0) {
            className = className.substring(0, index);
        }
        return ddIndex.getBusinessObjectEntries().get(className);
    }

    @Override
    public DataDictionaryEntry getDictionaryObjectEntry(DataDictionaryIndex ddIndex, String className) {
        int index;
        if (StringUtils.isBlank((String)className)) {
            throw new IllegalArgumentException("invalid (blank) className");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("calling getDictionaryObjectEntry '" + className + "'");
        }
        if ((index = className.indexOf("$$")) >= 0) {
            className = className.substring(0, index);
        }
        DataDictionaryEntry entry = null;
        if (ddIndex.getEntriesByJstlKey() != null) {
            entry = ddIndex.getEntriesByJstlKey().get(className);
        }
        if (entry == null) {
            entry = ddIndex.getDataObjectEntries().get(className);
        }
        if (entry == null) {
            entry = this.getBusinessObjectEntry(ddIndex, className);
        }
        if (entry == null) {
            entry = this.getDocumentEntry(ddIndex, className);
        }
        return entry;
    }

    @Override
    public DataObjectEntry getDataObjectEntry(DataDictionaryIndex index, String className) {
        DataObjectEntry entry = this.getDataObjectEntryForConcreteClass(index, className);
        if (entry == null) {
            Class<?> boClass = null;
            try {
                boClass = Class.forName(className);
                ModuleService responsibleModuleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(boClass);
                if (responsibleModuleService != null && responsibleModuleService.isExternalizable(boClass)) {
                    entry = responsibleModuleService.getExternalizableBusinessObjectDictionaryEntry(boClass);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return entry;
    }

    @Override
    public BusinessObjectEntry getBusinessObjectEntry(DataDictionaryIndex index, String className) {
        BusinessObjectEntry entry = this.getBusinessObjectEntryForConcreteClass(index, className);
        if (entry == null) {
            Class<?> boClass = null;
            try {
                boClass = Class.forName(className);
                ModuleService responsibleModuleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(boClass);
                if (responsibleModuleService != null && responsibleModuleService.isExternalizable(boClass)) {
                    return responsibleModuleService.getExternalizableBusinessObjectDictionaryEntry(boClass);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return null;
        }
        return entry;
    }

    @Override
    public Map<String, DocumentEntry> getDocumentEntries(DataDictionaryIndex index) {
        return Collections.unmodifiableMap(index.getDocumentEntries());
    }

    @Override
    public DocumentEntry getDocumentEntry(DataDictionaryIndex index, String documentTypeDDKey) {
        DocumentEntry de;
        if (StringUtils.isBlank((String)documentTypeDDKey)) {
            throw new IllegalArgumentException("invalid (blank) documentTypeName");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("calling getDocumentEntry by documentTypeName '" + documentTypeDDKey + "'");
        }
        if ((de = index.getDocumentEntries().get(documentTypeDDKey)) == null) {
            try {
                Class<?> clazz = Class.forName(documentTypeDDKey);
                de = index.getDocumentEntriesByBusinessObjectClass().get(clazz);
                if (de == null) {
                    de = index.getDocumentEntriesByMaintainableClass().get(clazz);
                }
            }
            catch (ClassNotFoundException ex) {
                LOG.warn("Unable to find document entry for key: " + documentTypeDDKey, (Throwable)ex);
            }
        }
        return de;
    }

    @Override
    public String getDocumentTypeName(DataDictionaryIndex index, String documentTypeName) {
        return null;
    }

    @Override
    public MaintenanceDocumentEntry getMaintenanceDocumentEntryForBusinessObjectClass(DataDictionaryIndex index, Class<?> businessObjectClass) {
        if (businessObjectClass == null) {
            throw new IllegalArgumentException("invalid (null) dataObjectClass");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("calling getDocumentEntry by dataObjectClass '" + String.valueOf(businessObjectClass) + "'");
        }
        return (MaintenanceDocumentEntry)index.getDocumentEntriesByBusinessObjectClass().get(businessObjectClass);
    }

    @Override
    public View getViewById(UifDictionaryIndex index, String viewId) {
        if (StringUtils.isBlank((String)viewId)) {
            throw new IllegalArgumentException("invalid (blank) view id");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("calling getViewById by id '" + viewId + "'");
        }
        return index.getViewById(viewId);
    }

    @Override
    public View getImmutableViewById(UifDictionaryIndex index, String viewId) {
        if (StringUtils.isBlank((String)viewId)) {
            throw new IllegalArgumentException("invalid (blank) view id");
        }
        return index.getImmutableViewById(viewId);
    }

    @Override
    public View getViewByTypeIndex(UifDictionaryIndex index, UifConstants.ViewType viewTypeName, Map<String, String> indexKey) {
        if (viewTypeName == null) {
            throw new IllegalArgumentException("invalid (blank) view type name");
        }
        if (indexKey == null || indexKey.isEmpty()) {
            throw new IllegalArgumentException("index key must have at least one entry");
        }
        return index.getViewByTypeIndex(viewTypeName, indexKey);
    }

    @Override
    public String getViewIdByTypeIndex(UifDictionaryIndex index, UifConstants.ViewType viewTypeName, Map<String, String> indexKey) {
        if (viewTypeName == null) {
            throw new IllegalArgumentException("invalid (blank) view type name");
        }
        if (indexKey == null || indexKey.isEmpty()) {
            throw new IllegalArgumentException("index key must have at least one entry");
        }
        return index.getViewIdByTypeIndex(viewTypeName, indexKey);
    }

    @Override
    public boolean viewByTypeExist(UifDictionaryIndex index, UifConstants.ViewType viewTypeName, Map<String, String> indexKey) {
        if (viewTypeName == null) {
            throw new IllegalArgumentException("invalid (blank) view type name");
        }
        if (indexKey == null || indexKey.isEmpty()) {
            throw new IllegalArgumentException("index key must have at least one entry");
        }
        return index.viewByTypeExist(viewTypeName, indexKey);
    }

    @Override
    public PropertyValues getViewPropertiesById(UifDictionaryIndex index, String viewId) {
        if (StringUtils.isBlank((String)viewId)) {
            throw new IllegalArgumentException("invalid (blank) view id");
        }
        return index.getViewPropertiesById(viewId);
    }

    @Override
    public PropertyValues getViewPropertiesByType(UifDictionaryIndex index, UifConstants.ViewType viewTypeName, Map<String, String> indexKey) {
        if (viewTypeName == null) {
            throw new IllegalArgumentException("invalid (blank) view type name");
        }
        if (indexKey == null || indexKey.isEmpty()) {
            throw new IllegalArgumentException("index key must have at least one entry");
        }
        return index.getViewPropertiesByType(viewTypeName, indexKey);
    }

    @Override
    public List<View> getViewsForType(UifDictionaryIndex index, UifConstants.ViewType viewTypeName) {
        if (viewTypeName == null) {
            throw new IllegalArgumentException("invalid (blank) view type name");
        }
        return index.getViewsForType(viewTypeName);
    }
}

