/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ojb.broker.query.Criteria;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.search.Range;
import org.kuali.rice.core.framework.persistence.platform.DatabasePlatform;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.kns.lookup.SelectiveReferenceRefresher;
import org.kuali.rice.kns.service.BusinessObjectDictionaryService;
import org.kuali.rice.kns.service.BusinessObjectMetaDataService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.comparator.NullValueComparator;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.kns.web.struts.form.LookupForm;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.ResultRow;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.DataObjectRelationship;
import org.kuali.rice.krad.datadictionary.RelationshipDefinition;
import org.kuali.rice.krad.datadictionary.control.ControlDefinition;
import org.kuali.rice.krad.exception.ClassNotPersistableException;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.PersistenceStructureService;
import org.kuali.rice.krad.util.ObjectUtils;

@Deprecated
public class LookupUtils {
    private static final Logger LOG = LogManager.getLogger(LookupUtils.class);
    private static String BASE_LOOKUP_ACTION_URL = null;
    private static String BASE_MULTIPLE_VALUE_LOOKUP_ACTION_URL = null;
    private static String BASE_INQUIRY_ACTION_URL = null;
    private static Map<Class, Map<String, Map>> referencesForForeignKey = new HashMap<Class, Map<String, Map>>();

    public static void removeHiddenCriteriaFields(Class businessObjectClass, Map fieldValues) {
        List<String> lookupFieldAttributeList = LookupUtils.getBusinessObjectMetaDataService().getLookupableFieldNames(businessObjectClass);
        if (lookupFieldAttributeList != null) {
            for (String attributeName : lookupFieldAttributeList) {
                ControlDefinition controlDef;
                if (!fieldValues.containsKey(attributeName) || (controlDef = LookupUtils.getDataDictionaryService().getAttributeControlDefinition(businessObjectClass, attributeName)) == null || !controlDef.isHidden()) continue;
                fieldValues.remove(attributeName);
            }
        }
    }

    public static Integer getSearchResultsLimit(Class businessObjectClass) {
        Integer limit = null;
        if (BusinessObject.class.isAssignableFrom(businessObjectClass)) {
            limit = LookupUtils.getBusinessObjectSearchResultsLimit(businessObjectClass);
        }
        if (limit == null) {
            limit = LookupUtils.getApplicationSearchResultsLimit();
        }
        return limit;
    }

    public static Integer getApplicationSearchResultsLimit() {
        String limitString = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsString("KR-NS", "Lookup", "RESULTS_LIMIT");
        if (limitString != null) {
            return Integer.valueOf(limitString);
        }
        return null;
    }

    public static boolean isDistinctSearch() {
        return CoreFrameworkServiceLocator.getParameterService().getParameterValueAsBoolean("KR-NS", "Lookup", "RESULTS_DISTINCT");
    }

    public static Integer getBusinessObjectSearchResultsLimit(Class businessObjectClass) {
        if (!LookupUtils.isMultipleValueLookup()) {
            return LookupUtils.getBusinessObjectDictionaryService().getLookupResultSetLimit(businessObjectClass);
        }
        return LookupUtils.getBusinessObjectDictionaryService().getMultipleValueLookupResultSetLimit(businessObjectClass);
    }

    private static boolean isMultipleValueLookup() {
        KualiForm kualiForm = KNSGlobalVariables.getKualiForm();
        if (kualiForm instanceof LookupForm) {
            LookupForm lookupForm = (LookupForm)kualiForm;
            return lookupForm.isMultipleValues();
        }
        return false;
    }

    public static void applySearchResultsLimit(Class businessObjectClass, Criteria criteria, DatabasePlatform platform) {
        String limitSql;
        Integer limit = LookupUtils.getSearchResultsLimit(businessObjectClass);
        if (limit != null && StringUtils.isNotBlank((String)(limitSql = platform.applyLimitSql(limit)))) {
            criteria.addSql(limitSql);
        }
    }

    public static Integer getApplicationMaximumSearchResulsPerPageForMultipleValueLookups() {
        String limitString = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsString("KR-NS", "Lookup", "MULTIPLE_VALUE_RESULTS_PER_PAGE");
        if (limitString != null) {
            return Integer.valueOf(limitString);
        }
        return null;
    }

    public static List<String> translateReadOnlyFieldsToList(String readOnlyFieldsString) {
        ArrayList<String> readOnlyFieldsList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)readOnlyFieldsString)) {
            if (readOnlyFieldsString.indexOf(",") > 0) {
                StringTokenizer token = new StringTokenizer(readOnlyFieldsString, ",");
                while (token.hasMoreTokens()) {
                    String element = token.nextToken();
                    readOnlyFieldsList.add(element);
                }
            } else {
                readOnlyFieldsList.add(readOnlyFieldsString);
            }
        }
        return readOnlyFieldsList;
    }

    public static Map<String, String> translateFieldConversions(String fieldConversionsString) {
        HashMap<String, String> fieldConversionsMap = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((String)fieldConversionsString)) {
            if (fieldConversionsString.indexOf(",") > 0) {
                StringTokenizer token = new StringTokenizer(fieldConversionsString, ",");
                while (token.hasMoreTokens()) {
                    String element = token.nextToken();
                    fieldConversionsMap.put(element.substring(0, element.indexOf(":")), element.substring(element.indexOf(":") + 1));
                }
            } else {
                fieldConversionsMap.put(fieldConversionsString.substring(0, fieldConversionsString.indexOf(":")), fieldConversionsString.substring(fieldConversionsString.indexOf(":") + 1));
            }
        }
        return fieldConversionsMap;
    }

    @Deprecated
    public static Field setFieldQuickfinder(Object businessObject, String attributeName, Field field, List displayedFieldNames) {
        return LookupUtils.setFieldQuickfinder(businessObject, null, false, 0, attributeName, field, displayedFieldNames);
    }

    @Deprecated
    public static Field setFieldQuickfinder(BusinessObject businessObject, String attributeName, Field field, List displayedFieldNames, SelectiveReferenceRefresher srr) {
        return LookupUtils.setFieldQuickfinder(businessObject, (String)null, false, 0, attributeName, field, displayedFieldNames, srr);
    }

    @Deprecated
    public static Field setFieldQuickfinder(BusinessObject businessObject, String collectionName, boolean addLine, int index, String attributeName, Field field, List displayedFieldNames, SelectiveReferenceRefresher srr) {
        field = LookupUtils.setFieldQuickfinder(businessObject, collectionName, addLine, index, attributeName, field, displayedFieldNames);
        if (srr != null) {
            Object collectionPrefix = "";
            if (collectionName != null) {
                collectionPrefix = addLine ? "add." + collectionName + "." : collectionName + "[" + index + "].";
            }
            field.setReferencesToRefresh(LookupUtils.convertReferencesToSelectCollectionToString(srr.getAffectedReferencesFromLookup(businessObject, attributeName, (String)collectionPrefix)));
        }
        return field;
    }

    @Deprecated
    public static Field setFieldQuickfinder(Object businessObject, String collectionName, boolean addLine, int index, String attributeName, Field field, List displayedFieldNames) {
        boolean noLookup = false;
        if (businessObject == null) {
            return field;
        }
        Boolean noLookupField = LookupUtils.getBusinessObjectDictionaryService().noLookupFieldLookup(businessObject.getClass(), attributeName);
        if (noLookupField != null && noLookupField.booleanValue()) {
            noLookup = true;
        }
        return LookupUtils.setFieldQuickfinder(businessObject, collectionName, addLine, index, attributeName, field, displayedFieldNames, noLookup);
    }

    @Deprecated
    public static Field setFieldQuickfinder(Object businessObject, String collectionName, boolean addLine, int index, String attributeName, Field field, List displayedFieldNames, boolean noLookupField) {
        if (businessObject == null) {
            return field;
        }
        if (noLookupField) {
            return field;
        }
        DataObjectRelationship relationship = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("setFieldQuickfinder(" + businessObject.getClass().getName() + "," + attributeName + "," + String.valueOf(field) + "," + String.valueOf(displayedFieldNames) + ")");
        }
        relationship = LookupUtils.getBusinessObjectMetaDataService().getBusinessObjectRelationship(businessObject, businessObject.getClass(), attributeName, "", false);
        Object collectionPrefix = "";
        if (collectionName != null) {
            collectionPrefix = addLine ? "add." + collectionName + "." : collectionName + "[" + index + "].";
        }
        if (relationship == null) {
            Class c = ObjectUtils.getPropertyType(businessObject, attributeName, LookupUtils.getPersistenceStructureService());
            if (c != null) {
                if (attributeName.contains(".")) {
                    attributeName = StringUtils.substringBeforeLast((String)attributeName, (String)".");
                }
                RelationshipDefinition ddReference = LookupUtils.getBusinessObjectMetaDataService().getBusinessObjectRelationshipDefinition(businessObject, attributeName);
                relationship = LookupUtils.getBusinessObjectMetaDataService().getBusinessObjectRelationship(ddReference, businessObject, businessObject.getClass(), attributeName, "", false);
                if (relationship != null) {
                    field.setQuickFinderClassNameImpl(relationship.getRelatedClass().getName());
                    field.setFieldConversions(LookupUtils.generateFieldConversions(businessObject, (String)collectionPrefix, relationship, field.getPropertyPrefix(), displayedFieldNames, null));
                    field.setLookupParameters(LookupUtils.generateLookupParameters(businessObject, (String)collectionPrefix, relationship, field.getPropertyPrefix(), displayedFieldNames, null));
                    field.setBaseLookupUrl(LookupUtils.getBaseLookupUrl(false));
                    field.setImageSrc(LookupUtils.getBusinessObjectDictionaryService().getSearchIconOverride(businessObject.getClass()));
                }
            }
            return field;
        }
        if (ObjectUtils.isNestedAttribute(attributeName)) {
            String nestedAttributePrefix = StringUtils.substringBeforeLast((String)attributeName, (String)".");
            field.setQuickFinderClassNameImpl(relationship.getRelatedClass().getName());
            field.setFieldConversions(LookupUtils.generateFieldConversions(businessObject, (String)collectionPrefix, relationship, field.getPropertyPrefix(), displayedFieldNames, nestedAttributePrefix));
            field.setLookupParameters(LookupUtils.generateLookupParameters(businessObject, (String)collectionPrefix, relationship, field.getPropertyPrefix(), displayedFieldNames, nestedAttributePrefix));
            field.setBaseLookupUrl(LookupUtils.getBaseLookupUrl(false));
        } else {
            field.setQuickFinderClassNameImpl(relationship.getRelatedClass().getName());
            field.setFieldConversions(LookupUtils.generateFieldConversions(businessObject, (String)collectionPrefix, relationship, field.getPropertyPrefix(), displayedFieldNames, null));
            field.setLookupParameters(LookupUtils.generateLookupParameters(businessObject, (String)collectionPrefix, relationship, field.getPropertyPrefix(), displayedFieldNames, null));
            field.setBaseLookupUrl(LookupUtils.getBaseLookupUrl(false));
        }
        field.setImageSrc(LookupUtils.getBusinessObjectDictionaryService().getSearchIconOverride(businessObject.getClass()));
        return field;
    }

    @Deprecated
    public static String getBaseLookupUrl(boolean isMultipleValue) {
        ConfigurationService kualiConfigurationService = CoreApiServiceLocator.getKualiConfigurationService();
        if (isMultipleValue) {
            if (BASE_MULTIPLE_VALUE_LOOKUP_ACTION_URL == null) {
                Object lookupUrl = kualiConfigurationService.getPropertyValueAsString("application.url");
                if (!((String)lookupUrl).endsWith("/")) {
                    lookupUrl = (String)lookupUrl + "/";
                }
                BASE_MULTIPLE_VALUE_LOOKUP_ACTION_URL = lookupUrl = (String)lookupUrl + "kr/multipleValueLookup.do";
            }
            return BASE_MULTIPLE_VALUE_LOOKUP_ACTION_URL;
        }
        if (BASE_LOOKUP_ACTION_URL == null) {
            Object lookupUrl = kualiConfigurationService.getPropertyValueAsString("application.url");
            if (!((String)lookupUrl).endsWith("/")) {
                lookupUrl = (String)lookupUrl + "/";
            }
            BASE_LOOKUP_ACTION_URL = lookupUrl = (String)lookupUrl + "kr/lookup.do";
        }
        return BASE_LOOKUP_ACTION_URL;
    }

    @Deprecated
    public static String getBaseInquiryUrl() {
        if (BASE_INQUIRY_ACTION_URL == null) {
            StringBuffer inquiryUrl = new StringBuffer(CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("application.url"));
            if (inquiryUrl.charAt(inquiryUrl.length() - 1) != '/') {
                inquiryUrl.append('/');
            }
            inquiryUrl.append("kr/");
            inquiryUrl.append("inquiry.do");
            BASE_INQUIRY_ACTION_URL = inquiryUrl.toString();
        }
        return BASE_INQUIRY_ACTION_URL;
    }

    public static String transformLookupUrlToMultiple(String lookupUrl) {
        return lookupUrl.replace("kr/lookup.do", "kr/multipleValueLookup.do");
    }

    private static void setFieldDirectInquiry(Field field) {
        if (StringUtils.isNotBlank((String)field.getFieldConversions())) {
            boolean directInquiriesEnabled = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsBoolean("KR-NS", "All", "ENABLE_DIRECT_INQUIRIES_IND");
            if (directInquiriesEnabled && StringUtils.isNotBlank((String)field.getFieldConversions())) {
                String fieldConversions = field.getFieldConversions();
                Object newInquiryParameters = "";
                String[] conversions = StringUtils.split((String)fieldConversions, (String)",");
                for (int l = 0; l < conversions.length; ++l) {
                    String conversion = conversions[l];
                    String[] conversionPair = StringUtils.split((String)conversion, (String)":", (int)2);
                    String conversionFrom = conversionPair[0];
                    String conversionTo = conversionPair[1];
                    newInquiryParameters = (String)newInquiryParameters + conversionTo + ":" + conversionFrom;
                    if (l >= conversions.length - 1) continue;
                    newInquiryParameters = (String)newInquiryParameters + ",";
                }
                field.setInquiryParameters((String)newInquiryParameters);
            }
            field.setFieldDirectInquiryEnabled(directInquiriesEnabled);
        } else {
            field.setFieldDirectInquiryEnabled(false);
        }
    }

    public static Field setFieldDirectInquiry(BusinessObject businessObject, String attributeName, Field field) {
        if (businessObject == null) {
            return field;
        }
        Boolean noDirectInquiry = LookupUtils.getBusinessObjectDictionaryService().noDirectInquiryFieldLookup(businessObject.getClass(), attributeName);
        if (noDirectInquiry != null && noDirectInquiry.booleanValue() || noDirectInquiry == null) {
            return field;
        }
        LookupUtils.setFieldDirectInquiry(field);
        return field;
    }

    @Deprecated
    public static Map getPrimitiveReference(BusinessObject businessObject, String attributeName) {
        HashMap<String, Class> chosenReferenceByKeySize = new HashMap<String, Class>();
        HashMap<String, Class> chosenReferenceByFieldName = new HashMap<String, Class>();
        Map<String, Class> referenceClasses = null;
        try {
            Map<String, Map> propMap = referencesForForeignKey.get(businessObject.getClass());
            if (propMap == null) {
                propMap = new HashMap<String, Map>();
                referencesForForeignKey.put(businessObject.getClass(), propMap);
            }
            if (propMap.containsKey(attributeName)) {
                referenceClasses = propMap.get(attributeName);
            } else {
                referenceClasses = LookupUtils.getBusinessObjectMetaDataService().getReferencesForForeignKey(businessObject, attributeName);
                if ((referenceClasses == null || referenceClasses.isEmpty()) && LookupUtils.getPersistenceStructureService().isPersistable(businessObject.getClass())) {
                    referenceClasses = LookupUtils.getPersistenceStructureService().getReferencesForForeignKey(businessObject.getClass(), attributeName);
                }
                propMap.put(attributeName, referenceClasses);
            }
        }
        catch (ClassNotPersistableException ex) {
            Map<String, Map> propMap = referencesForForeignKey.get(businessObject.getClass());
            propMap.put(attributeName, null);
        }
        if (referenceClasses == null || referenceClasses.isEmpty()) {
            return chosenReferenceByKeySize;
        }
        int minKeys = Integer.MAX_VALUE;
        for (String attr : referenceClasses.keySet()) {
            Class clazz = referenceClasses.get(attr);
            List pkNames = KRADServiceLocatorWeb.getLegacyDataAdapter().listPrimaryKeyFieldNames(clazz);
            if (pkNames.size() < minKeys) {
                minKeys = pkNames.size();
                chosenReferenceByKeySize.clear();
                chosenReferenceByKeySize.put(attr, clazz);
            }
            if (!attributeName.startsWith(attr)) continue;
            chosenReferenceByFieldName.clear();
            chosenReferenceByFieldName.put(attr, clazz);
        }
        return chosenReferenceByFieldName.isEmpty() ? chosenReferenceByKeySize : chosenReferenceByFieldName;
    }

    public static BusinessObject getNestedBusinessObject(BusinessObject bo, String attributeName) {
        String[] nestedAttributes = StringUtils.split((String)attributeName, (String)".");
        BusinessObject childBO = null;
        String attributeRefName = "";
        Class clazz = null;
        if (nestedAttributes.length > 1) {
            Object attributeStringSoFar = "";
            for (int i = 0; i < nestedAttributes.length - 1; ++i) {
                if (i != 0) {
                    attributeStringSoFar = (String)attributeStringSoFar + ".";
                }
                if ((clazz = ObjectUtils.getPropertyType(bo, (String)(attributeStringSoFar = (String)attributeStringSoFar + nestedAttributes[i]), LookupUtils.getPersistenceStructureService())) == null || !BusinessObject.class.isAssignableFrom(clazz)) continue;
                try {
                    childBO = (BusinessObject)ObjectUtils.createNewObjectFromClass(clazz);
                    continue;
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        return childBO;
    }

    public static Class getNestedReferenceClass(BusinessObject businessObject, String attributeName) {
        BusinessObject bo = LookupUtils.getNestedBusinessObject(businessObject, attributeName);
        return null == bo ? null : bo.getClass();
    }

    @Deprecated
    private static String generateFieldConversions(Object businessObject, String collectionName, DataObjectRelationship relationship, String propertyPrefix, List displayedFieldNames, String nestedObjectPrefix) {
        Object fieldConversions = "";
        if (LOG.isDebugEnabled()) {
            LOG.debug("generateFieldConversions(" + businessObject.getClass().getName() + "," + collectionName + ",\n" + String.valueOf(relationship) + "\n," + propertyPrefix + "," + String.valueOf(displayedFieldNames) + "," + nestedObjectPrefix + ")");
        }
        for (Map.Entry entry : relationship.getParentToChildReferences().entrySet()) {
            String fromField = (String)entry.getValue();
            Object toField = (String)entry.getKey();
            if (!displayedFieldNames.contains(toField)) {
                toField = LookupUtils.translateToDisplayedField(businessObject.getClass(), (String)toField, displayedFieldNames);
            }
            if (StringUtils.isNotBlank((String)fieldConversions)) {
                fieldConversions = (String)fieldConversions + ",";
            }
            if (StringUtils.isNotEmpty((String)propertyPrefix)) {
                toField = propertyPrefix + "." + (String)toField;
            }
            if (StringUtils.isNotEmpty((String)collectionName)) {
                toField = collectionName + (String)toField;
            }
            fieldConversions = (String)fieldConversions + fromField + ":" + (String)toField;
        }
        return fieldConversions;
    }

    @Deprecated
    private static String generateLookupParameters(Object businessObject, String collectionName, DataObjectRelationship relationship, String propertyPrefix, List displayedFieldNames, String nestedObjectPrefix) {
        Object lookupParameters = "";
        List displayedQFFieldNames = LookupUtils.getBusinessObjectDictionaryService().getLookupFieldNames(relationship.getRelatedClass());
        for (Map.Entry entry : relationship.getParentToChildReferences().entrySet()) {
            Object fromField = (String)entry.getKey();
            String toField = (String)entry.getValue();
            if (relationship.getUserVisibleIdentifierKey() != null && !relationship.getUserVisibleIdentifierKey().equals(fromField)) continue;
            if (!displayedFieldNames.contains(fromField)) {
                fromField = LookupUtils.translateToDisplayedField(businessObject.getClass(), (String)fromField, displayedFieldNames);
            }
            if (displayedQFFieldNames != null && !displayedQFFieldNames.contains(toField)) {
                toField = LookupUtils.translateToDisplayedField(relationship.getRelatedClass(), toField, displayedQFFieldNames);
            }
            if (StringUtils.isNotBlank((String)lookupParameters)) {
                lookupParameters = (String)lookupParameters + ",";
            }
            if (propertyPrefix != null && !propertyPrefix.equals("")) {
                fromField = propertyPrefix + "." + (String)fromField;
            }
            if (StringUtils.isNotEmpty((String)collectionName)) {
                fromField = collectionName + (String)fromField;
            }
            lookupParameters = (String)lookupParameters + (String)fromField + ":" + toField;
        }
        return lookupParameters;
    }

    @Deprecated
    private static String translateToDisplayedField(Class businessObjectClass, String fieldName, List displayedFieldNames) {
        if (LookupUtils.getPersistenceStructureService().isPersistable(businessObjectClass)) {
            Map nestedFkMap = LookupUtils.getPersistenceStructureService().getNestedForeignKeyMap(businessObjectClass);
            if (!displayedFieldNames.contains(fieldName)) {
                for (String dispField : displayedFieldNames) {
                    if (!nestedFkMap.containsKey(dispField) || !nestedFkMap.get(dispField).equals(fieldName)) continue;
                    fieldName = dispField;
                }
            }
        }
        return fieldName;
    }

    public static String convertReferencesToSelectCollectionToString(Collection<String> referencesToRefresh) {
        StringBuilder buf = new StringBuilder();
        for (String reference : referencesToRefresh) {
            buf.append(reference).append(",");
        }
        if (!referencesToRefresh.isEmpty()) {
            buf.delete(buf.length() - ",".length(), buf.length());
        }
        return buf.toString();
    }

    public static String convertSetOfObjectIdsToString(Set<String> objectIds) {
        if (objectIds.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (String objectId : objectIds) {
            if (objectId.contains("||")) {
                throw new RuntimeException("object ID " + objectId + " contains the selected obj ID separator");
            }
            buf.append(objectId).append("||");
        }
        buf.delete(buf.length() - "||".length(), buf.length());
        return buf.toString();
    }

    public static Set<String> convertStringOfObjectIdsToSet(String objectIdsString) {
        HashSet<String> set = new HashSet<String>();
        if (StringUtils.isNotBlank((String)objectIdsString)) {
            String[] objectIds;
            for (String objectId : objectIds = StringUtils.splitByWholeSeparator((String)objectIdsString, (String)"||")) {
                set.add(objectId);
            }
        }
        return set;
    }

    public static Comparator findBestValueComparatorForColumn(List<ResultRow> resultTable, int column) {
        NullValueComparator comp = NullValueComparator.getInstance();
        for (ResultRow row : resultTable) {
            Comparator tempComp = row.getColumns().get(column).getValueComparator();
            if (tempComp == null || NullValueComparator.class.equals(tempComp.getClass())) continue;
            return tempComp;
        }
        return comp;
    }

    public static Map<String, String> preProcessRangeFields(Map<String, String> lookupFormFields) {
        HashMap<String, String> fieldsToUpdate = new HashMap<String, String>();
        Set<String> fieldsForLookup = lookupFormFields.keySet();
        for (String propName : fieldsForLookup) {
            if (!propName.startsWith("rangeLowerBoundKeyPrefix_")) continue;
            String rangedLowerBoundValue = lookupFormFields.get(propName);
            String rangedFieldName = StringUtils.remove((String)propName, (String)"rangeLowerBoundKeyPrefix_");
            String rangedValue = lookupFormFields.get(rangedFieldName);
            Range range = new Range();
            range.setLowerBoundInclusive(true);
            range.setUpperBoundInclusive(true);
            range.setLowerBoundValue(rangedLowerBoundValue);
            range.setUpperBoundValue(rangedValue);
            String expr = range.toString();
            if (StringUtils.isEmpty((String)expr)) {
                expr = rangedValue;
            }
            fieldsToUpdate.put(rangedFieldName, expr);
        }
        Set keysToUpdate = fieldsToUpdate.keySet();
        for (String updateKey : keysToUpdate) {
            lookupFormFields.put(updateKey, (String)fieldsToUpdate.get(updateKey));
        }
        return fieldsToUpdate;
    }

    public static Map<String, String> generateCompositeSelectedObjectIds(Set<String> previouslySelectedObjectIds, Set<String> displayedObjectIds, Set<String> selectedObjectIds) {
        HashMap<String, String> tempMap = new HashMap<String, String>();
        for (String previouslySelectedObjectId : previouslySelectedObjectIds) {
            tempMap.put(previouslySelectedObjectId, previouslySelectedObjectId);
        }
        for (String displayedObjectId : displayedObjectIds) {
            tempMap.remove(displayedObjectId);
        }
        for (String selectedObjectId : selectedObjectIds) {
            tempMap.put(selectedObjectId, selectedObjectId);
        }
        return tempMap;
    }

    public static DataDictionaryService getDataDictionaryService() {
        return KRADServiceLocatorWeb.getDataDictionaryService();
    }

    public static PersistenceStructureService getPersistenceStructureService() {
        return KNSServiceLocator.getPersistenceStructureService();
    }

    public static BusinessObjectDictionaryService getBusinessObjectDictionaryService() {
        return KNSServiceLocator.getBusinessObjectDictionaryService();
    }

    public static BusinessObjectMetaDataService getBusinessObjectMetaDataService() {
        return KNSServiceLocator.getBusinessObjectMetaDataService();
    }

    public static DateTimeService getDateTimeService() {
        return CoreApiServiceLocator.getDateTimeService();
    }
}

