/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.dao.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.dao.BusinessObjectDao;
import org.kuali.rice.krad.service.PersistenceStructureService;
import org.kuali.rice.krad.service.util.OjbCollectionAware;
import org.kuali.rice.krad.service.util.OjbCollectionHelper;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.rice.krad.util.QueryPagingRequest;
import org.kuali.rice.krad.util.QueryPagingResults;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.ObjectRetrievalFailureException;

@Deprecated
public class BusinessObjectDaoOjb
extends PlatformAwareDaoBaseOjb
implements BusinessObjectDao,
OjbCollectionAware {
    private static final Logger LOG = LogManager.getLogger(BusinessObjectDaoOjb.class);
    private PersistenceStructureService persistenceStructureService;
    private OjbCollectionHelper ojbCollectionHelper;

    public BusinessObjectDaoOjb(PersistenceStructureService persistenceStructureService) {
        this.persistenceStructureService = persistenceStructureService;
    }

    @Override
    public <T extends PersistableBusinessObject> T findBySinglePrimaryKey(Class<T> clazz, Object primaryKey) {
        if (primaryKey.getClass().getName().startsWith("java.lang.") || primaryKey.getClass().getName().startsWith("java.sql.") || primaryKey.getClass().getName().startsWith("java.math.") || primaryKey.getClass().getName().startsWith("java.util.")) {
            try {
                return (T)((PersistableBusinessObject)this.getPersistenceBrokerTemplate().getObjectById(clazz, primaryKey));
            }
            catch (ObjectRetrievalFailureException ex) {
                return null;
            }
        }
        Criteria criteria = this.buildCriteria(clazz, primaryKey);
        return (T)((PersistableBusinessObject)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)QueryFactory.newQuery(clazz, (Criteria)criteria)));
    }

    @Override
    public <T extends PersistableBusinessObject> T findByPrimaryKey(Class<T> clazz, Map<String, ?> primaryKeys) {
        Criteria criteria = this.buildCriteria(primaryKeys);
        return (T)((PersistableBusinessObject)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)QueryFactory.newQuery(clazz, (Criteria)criteria)));
    }

    @Override
    public <T extends PersistableBusinessObject> List<T> findAll(Class<T> clazz) {
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery(clazz, (Criteria)null));
    }

    @Override
    public <T extends PersistableBusinessObject> QueryPagingResults<T> findAll(Class<T> clazz, QueryPagingRequest pagingRequest) {
        int total = this.getPersistenceBrokerTemplate().getCount((Query)QueryFactory.newQuery(clazz, (Criteria)null));
        List results = (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)this.withPaging(QueryFactory.newQuery(clazz, (Criteria)null), pagingRequest));
        return new QueryPagingResults(pagingRequest, results, total);
    }

    private QueryByCriteria withPaging(QueryByCriteria queryByCriteria, QueryPagingRequest pagingRequest) {
        int ojbStartIndex = pagingRequest.getStartAtIndex() + 1;
        int ojbEndIndex = ojbStartIndex + pagingRequest.getMaxResults();
        queryByCriteria.setStartAtIndex(ojbStartIndex);
        queryByCriteria.setEndAtIndex(ojbEndIndex);
        return queryByCriteria;
    }

    @Override
    public <T extends PersistableBusinessObject> List<T> findAllOrderBy(Class<T> clazz, String sortField, boolean sortAscending) {
        QueryByCriteria queryByCriteria = new QueryByCriteria(clazz, null);
        if (sortAscending) {
            queryByCriteria.addOrderByAscending(sortField);
        } else {
            queryByCriteria.addOrderByDescending(sortField);
        }
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)queryByCriteria);
    }

    @Override
    public <T extends PersistableBusinessObject> QueryPagingResults<T> findAllOrderBy(Class<T> clazz, String sortField, boolean sortAscending, QueryPagingRequest pagingRequest) {
        QueryByCriteria queryByCriteria = new QueryByCriteria(clazz, null);
        if (sortAscending) {
            queryByCriteria.addOrderByAscending(sortField);
        } else {
            queryByCriteria.addOrderByDescending(sortField);
        }
        int total = this.getPersistenceBrokerTemplate().getCount((Query)queryByCriteria);
        List results = (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)this.withPaging(queryByCriteria, pagingRequest));
        return new QueryPagingResults(pagingRequest, results, total);
    }

    @Override
    public <T extends PersistableBusinessObject> List<T> findMatching(Class<T> clazz, Map<String, ?> fieldValues) {
        Criteria criteria = this.buildCriteria(fieldValues);
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery(clazz, (Criteria)criteria));
    }

    @Override
    public <T extends PersistableBusinessObject> QueryPagingResults<T> findMatching(Class<T> clazz, Map<String, ?> fieldValues, QueryPagingRequest pagingRequest) {
        Criteria criteria = this.buildCriteria(fieldValues);
        QueryByCriteria queryByCriteria = QueryFactory.newQuery(clazz, (Criteria)criteria);
        int total = this.getPersistenceBrokerTemplate().getCount((Query)queryByCriteria);
        List results = (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)this.withPaging(queryByCriteria, pagingRequest));
        return new QueryPagingResults(pagingRequest, results, total);
    }

    @Override
    public <T extends PersistableBusinessObject> List<T> findAllActive(Class<T> clazz) {
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery(clazz, (Criteria)this.buildActiveCriteria()));
    }

    @Override
    public <T extends PersistableBusinessObject> QueryPagingResults<T> findAllActive(Class<T> clazz, QueryPagingRequest pagingRequest) {
        Criteria criteria = this.buildActiveCriteria();
        QueryByCriteria queryByCriteria = QueryFactory.newQuery(clazz, (Criteria)criteria);
        int total = this.getPersistenceBrokerTemplate().getCount((Query)queryByCriteria);
        List results = (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)this.withPaging(queryByCriteria, pagingRequest));
        return new QueryPagingResults(pagingRequest, results, total);
    }

    @Override
    public <T extends PersistableBusinessObject> List<T> findAllInactive(Class<T> clazz) {
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery(clazz, (Criteria)this.buildInactiveCriteria()));
    }

    @Override
    public <T extends PersistableBusinessObject> QueryPagingResults<T> findAllInactive(Class<T> clazz, QueryPagingRequest pagingRequest) {
        Criteria criteria = this.buildInactiveCriteria();
        QueryByCriteria queryByCriteria = QueryFactory.newQuery(clazz, (Criteria)criteria);
        int total = this.getPersistenceBrokerTemplate().getCount((Query)queryByCriteria);
        List results = (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)this.withPaging(queryByCriteria, pagingRequest));
        return new QueryPagingResults(pagingRequest, results, total);
    }

    @Override
    public <T extends PersistableBusinessObject> List<T> findAllActiveOrderBy(Class<T> clazz, String sortField, boolean sortAscending) {
        QueryByCriteria queryByCriteria = new QueryByCriteria(clazz, this.buildActiveCriteria());
        if (sortAscending) {
            queryByCriteria.addOrderByAscending(sortField);
        } else {
            queryByCriteria.addOrderByDescending(sortField);
        }
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)queryByCriteria);
    }

    @Override
    public <T extends PersistableBusinessObject> QueryPagingResults<T> findAllActiveOrderBy(Class<T> clazz, String sortField, boolean sortAscending, QueryPagingRequest pagingRequest) {
        QueryByCriteria queryByCriteria = new QueryByCriteria(clazz, this.buildActiveCriteria());
        if (sortAscending) {
            queryByCriteria.addOrderByAscending(sortField);
        } else {
            queryByCriteria.addOrderByDescending(sortField);
        }
        int total = this.getPersistenceBrokerTemplate().getCount((Query)queryByCriteria);
        List results = (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)this.withPaging(queryByCriteria, pagingRequest));
        return new QueryPagingResults(pagingRequest, results, total);
    }

    @Override
    public <T extends PersistableBusinessObject> List<T> findMatchingActive(Class<T> clazz, Map<String, ?> fieldValues) {
        Criteria criteria = this.buildCriteria(fieldValues);
        criteria.addAndCriteria(this.buildActiveCriteria());
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery(clazz, (Criteria)criteria));
    }

    @Override
    public <T extends PersistableBusinessObject> QueryPagingResults<T> findMatchingActive(Class<T> clazz, Map<String, ?> fieldValues, QueryPagingRequest pagingRequest) {
        Criteria criteria = this.buildCriteria(fieldValues);
        criteria.addAndCriteria(this.buildActiveCriteria());
        QueryByCriteria queryByCriteria = QueryFactory.newQuery(clazz, (Criteria)criteria);
        int total = this.getPersistenceBrokerTemplate().getCount((Query)queryByCriteria);
        List results = (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)this.withPaging(queryByCriteria, pagingRequest));
        return new QueryPagingResults(pagingRequest, results, total);
    }

    @Override
    public <T extends PersistableBusinessObject> int countMatching(Class<T> clazz, Map<String, ?> fieldValues) {
        Criteria criteria = this.buildCriteria(fieldValues);
        return this.getPersistenceBrokerTemplate().getCount((Query)QueryFactory.newQuery(clazz, (Criteria)criteria));
    }

    @Override
    public <T extends PersistableBusinessObject> int countMatching(Class<T> clazz, Map<String, ?> positiveFieldValues, Map<String, ?> negativeFieldValues) {
        Criteria criteria = this.buildCriteria(positiveFieldValues);
        Criteria negativeCriteria = this.buildNegativeCriteria(negativeFieldValues);
        criteria.addAndCriteria(negativeCriteria);
        return this.getPersistenceBrokerTemplate().getCount((Query)QueryFactory.newQuery(clazz, (Criteria)criteria));
    }

    @Override
    public <T extends PersistableBusinessObject> List<T> findMatchingOrderBy(Class<T> clazz, Map<String, ?> fieldValues, String sortField, boolean sortAscending) {
        Criteria criteria = this.buildCriteria(fieldValues);
        QueryByCriteria queryByCriteria = new QueryByCriteria(clazz, criteria);
        if (sortAscending) {
            queryByCriteria.addOrderByAscending(sortField);
        } else {
            queryByCriteria.addOrderByDescending(sortField);
        }
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)queryByCriteria);
    }

    @Override
    public <T extends PersistableBusinessObject> QueryPagingResults<T> findMatchingOrderBy(Class<T> clazz, Map<String, ?> fieldValues, String sortField, boolean sortAscending, QueryPagingRequest pagingRequest) {
        Criteria criteria = this.buildCriteria(fieldValues);
        QueryByCriteria queryByCriteria = new QueryByCriteria(clazz, criteria);
        if (sortAscending) {
            queryByCriteria.addOrderByAscending(sortField);
        } else {
            queryByCriteria.addOrderByDescending(sortField);
        }
        int total = this.getPersistenceBrokerTemplate().getCount((Query)queryByCriteria);
        List results = (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)this.withPaging(queryByCriteria, pagingRequest));
        return new QueryPagingResults(pagingRequest, results, total);
    }

    @Override
    public <T extends PersistableBusinessObject> T save(T bo) throws DataAccessException {
        Set<String> boCollections = this.getPersistenceStructureService().listCollectionObjectTypes(bo.getClass()).keySet();
        if (!boCollections.isEmpty()) {
            PersistableBusinessObject savedBo = (PersistableBusinessObject)((Object)ObjectUtils.deepCopy(bo));
            for (String boCollection : boCollections) {
                if (!this.getPersistenceStructureService().isCollectionUpdatable(savedBo.getClass(), boCollection)) continue;
                savedBo.refreshReferenceObject(boCollection);
            }
            this.getOjbCollectionHelper().processCollections(this, bo, savedBo);
        }
        this.getPersistenceBrokerTemplate().store(bo);
        return bo;
    }

    @Override
    public <T extends PersistableBusinessObject> List<T> save(List<T> businessObjects) throws DataAccessException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("About to persist the following BOs:");
            businessObjects.forEach(bo -> LOG.debug("   --->" + String.valueOf(bo)));
        }
        businessObjects.forEach(bo -> this.getPersistenceBrokerTemplate().store(bo));
        return businessObjects;
    }

    @Override
    public void delete(Object bo) {
        this.getPersistenceBrokerTemplate().delete(bo);
    }

    @Override
    public <T extends PersistableBusinessObject> void delete(List<T> boList) {
        for (PersistableBusinessObject bo : boList) {
            this.getPersistenceBrokerTemplate().delete((Object)bo);
        }
    }

    @Override
    public <T extends PersistableBusinessObject> void deleteMatching(Class<T> clazz, Map<String, ?> fieldValues) {
        Criteria criteria = this.buildCriteria(fieldValues);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)QueryFactory.newQuery(clazz, (Criteria)criteria));
        this.getPersistenceBrokerTemplate().clearCache();
    }

    @Override
    public Object retrieve(Object object) {
        return this.getPersistenceBrokerTemplate().getObjectByQuery((Query)QueryFactory.newQueryByIdentity((Object)object));
    }

    @Override
    public <T extends PersistableBusinessObject> T findByPrimaryKeyUsingKeyObject(Class<T> clazz, Object pkObject) {
        throw new UnsupportedOperationException("OJB does not support this option");
    }

    @Override
    public <T extends PersistableBusinessObject> T manageReadOnly(T bo) {
        return bo;
    }

    private Criteria buildCriteria(Map<String, ?> fieldValues) {
        Criteria criteria = new Criteria();
        for (Map.Entry<String, ?> stringEntry : fieldValues.entrySet()) {
            String key = stringEntry.getKey();
            Object value = stringEntry.getValue();
            if (value instanceof Collection) {
                criteria.addIn(key, (Collection)value);
                continue;
            }
            criteria.addEqualTo(key, value);
        }
        return criteria;
    }

    private <T extends BusinessObject> Criteria buildCriteria(Class<T> clazz, Object primaryKey) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        List fieldNames = this.getPersistenceStructureService().getPrimaryKeys(clazz);
        for (String fieldName : fieldNames) {
            try {
                Object fieldValue = primaryKey.getClass().getMethod("get" + StringUtils.capitalize((String)fieldName), new Class[0]).invoke(primaryKey, new Object[0]);
                fieldValues.put(fieldName, fieldValue);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.buildCriteria(fieldValues);
    }

    private Criteria buildActiveCriteria() {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("active", (Object)true);
        return criteria;
    }

    private Criteria buildInactiveCriteria() {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("active", (Object)false);
        return criteria;
    }

    private Criteria buildNegativeCriteria(Map<String, ?> negativeFieldValues) {
        Criteria criteria = new Criteria();
        for (Map.Entry<String, ?> stringEntry : negativeFieldValues.entrySet()) {
            String key = stringEntry.getKey();
            Object value = stringEntry.getValue();
            if (value instanceof Collection) {
                criteria.addNotIn(key, (Collection)value);
                continue;
            }
            criteria.addNotEqualTo((Object)key, value);
        }
        return criteria;
    }

    protected PersistenceStructureService getPersistenceStructureService() {
        return this.persistenceStructureService;
    }

    public void setPersistenceStructureService(PersistenceStructureService persistenceStructureService) {
        this.persistenceStructureService = persistenceStructureService;
    }

    protected OjbCollectionHelper getOjbCollectionHelper() {
        if (this.ojbCollectionHelper == null) {
            this.ojbCollectionHelper = KNSServiceLocator.getOjbCollectionHelper();
        }
        return this.ojbCollectionHelper;
    }

    public void setOjbCollectionHelper(OjbCollectionHelper ojbCollectionHelper) {
        this.ojbCollectionHelper = ojbCollectionHelper;
    }
}

