/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.award.finance.timeAndMoney.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.kuali.coeus.award.finance.timeAndMoney.TimeAndMoneyPosts;
import org.kuali.coeus.award.finance.timeAndMoney.dao.TimeAndMoneyPostsDao;
import org.kuali.coeus.award.finance.timeAndMoney.dto.AwardAmountTransactionDto;
import org.kuali.coeus.award.finance.timeAndMoney.dto.TimeAndMoneyDto;
import org.kuali.coeus.award.finance.timeAndMoney.dto.TimeAndMoneyPostDto;
import org.kuali.coeus.award.finance.timeAndMoney.dto.TransactionDetailDto;
import org.kuali.coeus.common.api.document.service.CommonApiService;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.controller.rest.RestController;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.rest.ResourceNotFoundException;
import org.kuali.coeus.sys.framework.rest.UnauthorizedAccessException;
import org.kuali.coeus.sys.framework.rest.UnprocessableEntityException;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyService;
import org.kuali.kra.award.dao.AwardDao;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.award.version.service.AwardVersionService;
import org.kuali.kra.timeandmoney.AwardHierarchyNode;
import org.kuali.kra.timeandmoney.dao.TimeAndMoneyDao;
import org.kuali.kra.timeandmoney.document.TimeAndMoneyDocument;
import org.kuali.kra.timeandmoney.history.TransactionDetail;
import org.kuali.kra.timeandmoney.rules.TimeAndMoneyAwardDateSaveRuleImpl;
import org.kuali.kra.timeandmoney.service.TimeAndMoneyService;
import org.kuali.kra.timeandmoney.service.TimeAndMoneyVersionService;
import org.kuali.kra.timeandmoney.transactions.PendingTransaction;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.exception.UnknownDocumentIdException;
import org.kuali.rice.krad.exception.ValidationException;
import org.kuali.rice.krad.service.DocumentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/api/v1"})
@Controller(value="timeAndMoneyController")
public class TimeAndMoneyController
extends RestController {
    @Autowired
    @Qualifier(value="timeAndMoneyPostsDao")
    private TimeAndMoneyPostsDao timeAndMoneyPostsDao;
    @Autowired
    @Qualifier(value="timeAndMoneyDao")
    private TimeAndMoneyDao timeAndMoneyDao;
    @Autowired
    @Qualifier(value="commonApiService")
    private CommonApiService commonApiService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="timeAndMoneyService")
    private TimeAndMoneyService timeAndMoneyService;
    @Autowired
    @Qualifier(value="documentService")
    private DocumentService documentService;
    @Autowired
    @Qualifier(value="awardDao")
    private AwardDao awardDao;
    @Autowired
    @Qualifier(value="awardService")
    private AwardService awardService;
    @Autowired
    @Qualifier(value="awardHierarchyService")
    private AwardHierarchyService awardHierarchyService;
    @Autowired
    @Qualifier(value="awardVersionService")
    private AwardVersionService awardVersionService;
    @Autowired
    @Qualifier(value="timeAndMoneyVersionService")
    private TimeAndMoneyVersionService timeAndMoneyVersionService;
    @Autowired
    @Qualifier(value="permissionService")
    private PermissionService permissionService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;

    @RequestMapping(method={RequestMethod.GET}, value={"/time-and-money-posts/"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    List<TimeAndMoneyPostDto> getTimeAndMoneyPosts() {
        this.assertUserHasReadAccess();
        List<TimeAndMoneyPosts> timeAndMoneyPosts = this.timeAndMoneyPostsDao.getActiveTimeAndMoneyPosts();
        return timeAndMoneyPosts.stream().map(this::translateTimeAndMoney).collect(Collectors.toList());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/time-and-money-posts/{id}"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    TimeAndMoneyPostDto getPost(@PathVariable Long id) {
        this.assertUserHasReadAccess();
        TimeAndMoneyPosts timeAndMoneyPosts = this.timeAndMoneyPostsDao.getTimeAndMoneyPost(id);
        if (timeAndMoneyPosts == null) {
            throw new ResourceNotFoundException("Time and money posts with id " + id + " not found.");
        }
        return this.translateTimeAndMoney(timeAndMoneyPosts);
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/time-and-money-posts/{id}"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public TimeAndMoneyPostDto putTimeAndMoneyPost(@RequestBody TimeAndMoneyPostDto timeAndMoneyPostDto, @PathVariable Long id) {
        this.assertUserHasWriteAccess();
        TimeAndMoneyPosts timeAndMoneyPosts = this.timeAndMoneyPostsDao.getTimeAndMoneyPost(id);
        if (timeAndMoneyPosts == null) {
            throw new ResourceNotFoundException("Time and money posts with id " + id + " not found.");
        }
        timeAndMoneyPosts.setActive(timeAndMoneyPostDto.isActive());
        this.dataObjectService.save((Object)timeAndMoneyPosts, new PersistenceOption[0]);
        return this.commonApiService.convertObject(timeAndMoneyPosts, TimeAndMoneyPostDto.class);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/time-and-money-documents/{documentNumber}"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public TimeAndMoneyDto getTimeAndMoneydocument(@PathVariable String documentNumber) {
        TimeAndMoneyDocument timeAndMoneyDocument;
        this.assertUserHasReadAccess();
        try {
            timeAndMoneyDocument = this.commonApiService.getDocumentFromDocId(documentNumber, TimeAndMoneyDocument.class);
        }
        catch (UnknownDocumentIdException e) {
            throw new ResourceNotFoundException("The time and money document with document number " + documentNumber + "could not be retrieved");
        }
        TimeAndMoneyDto timeAndMoneyDto = this.commonApiService.convertObject(timeAndMoneyDocument, TimeAndMoneyDto.class);
        timeAndMoneyDto.setTransactionDetails(this.timeAndMoneyDao.getTransactionDetailsForDocument(documentNumber).stream().map(item -> this.commonApiService.convertObject(item, TransactionDetailDto.class)).collect(Collectors.toList()));
        timeAndMoneyDto.setTimeAndMoneyDocumentNbr(timeAndMoneyDocument.getDocumentNumber());
        timeAndMoneyDto.setTimeAndMoneyDocumentStatus(timeAndMoneyDocument.getDocumentHeader().getWorkflowDocument().getStatus().getLabel());
        return timeAndMoneyDto;
    }

    public String createTimeAndMoneyDocument(TimeAndMoneyDto timeAndMoneyDto) throws Exception {
        return this.createTimeAndMoneyDocument(timeAndMoneyDto, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(method={RequestMethod.POST}, value={"/time-and-money-documents/"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public String createTimeAndMoneyDocument(@RequestBody TimeAndMoneyDto timeAndMoneyDto, @RequestParam(value="submit", required=false) boolean submit) throws Exception {
        this.assertUserHasWriteAccess();
        this.commonApiService.clearErrors();
        if (timeAndMoneyDto == null) {
            throw new UnprocessableEntityException("No data provided to create document");
        }
        String awardId = timeAndMoneyDto.getAwardId();
        Award award = this.awardDao.getAward(Long.parseLong(awardId));
        if (award == null) {
            throw new ResourceNotFoundException("Award with award id " + awardId + " not found.");
        }
        TimeAndMoneyAwardDateSaveRuleImpl timeAndMoneyAwardDateSaveRuleImpl = new TimeAndMoneyAwardDateSaveRuleImpl();
        timeAndMoneyAwardDateSaveRuleImpl.enforceAwardStartDatePopulated(award);
        if (!this.globalVariableService.getMessageMap().hasNoErrors()) throw new UnprocessableEntityException(this.commonApiService.getValidationErrors());
        String rootAwardNumber = this.awardService.getRootAwardNumber(award.getAwardNumber());
        String documentNumber = this.timeAndMoneyVersionService.getCurrentTimeAndMoneyDocumentNumber(rootAwardNumber);
        if (documentNumber != null) throw new UnprocessableEntityException("A time and money document already exists for this award.");
        if (!this.timeAndMoneyVersionService.validateCreateNewTimeAndMoneyDocument(rootAwardNumber)) {
            throw new UnprocessableEntityException(this.commonApiService.getValidationErrors());
        }
        try {
            TimeAndMoneyDocument timeAndMoneyDocument = this.createTimeAndMoneyDocument(timeAndMoneyDto, award, rootAwardNumber);
            this.documentService.saveDocument((Document)timeAndMoneyDocument);
            if (!submit) return timeAndMoneyDocument.getDocumentNumber();
            this.commonApiService.routeDocument((Document)timeAndMoneyDocument);
            return timeAndMoneyDocument.getDocumentNumber();
        }
        catch (ValidationException exception) {
            throw new UnprocessableEntityException(this.commonApiService.getValidationErrors());
        }
    }

    private TimeAndMoneyDocument createTimeAndMoneyDocument(TimeAndMoneyDto timeAndMoneyDto, Award award, String rootAwardNumber) throws Exception {
        TimeAndMoneyDocument timeAndMoneyDocument = this.timeAndMoneyService.setupTimeAndMoneyDocument(rootAwardNumber, award);
        this.commonApiService.saveDocument((Document)timeAndMoneyDocument);
        this.addTransactionDetails(timeAndMoneyDto, timeAndMoneyDocument);
        this.updateAwardAmountTransactionInformation(timeAndMoneyDocument, timeAndMoneyDto.getAwardAmountTransactions());
        this.captureAmountAndDateChanges(award, rootAwardNumber, timeAndMoneyDocument);
        return timeAndMoneyDocument;
    }

    private void updateAwardAmountTransactionInformation(TimeAndMoneyDocument timeAndMoneyDocument, List<AwardAmountTransactionDto> awardAmountTransactions) {
        if (awardAmountTransactions.size() == 0) {
            throw new UnprocessableEntityException("T & M doc cannot be processed without transaction information.");
        }
        timeAndMoneyDocument.getAwardAmountTransactions().get(0).setNoticeDate(awardAmountTransactions.get(0).getNoticeDate());
        timeAndMoneyDocument.getAwardAmountTransactions().get(0).setTransactionTypeCode(awardAmountTransactions.get(0).getTransactionTypeCode());
        timeAndMoneyDocument.getAwardAmountTransactions().get(0).setComments(awardAmountTransactions.get(0).getComments());
    }

    private void captureAmountAndDateChanges(Award award, String rootAwardNumber, TimeAndMoneyDocument timeAndMoneyDocument) throws Exception {
        this.timeAndMoneyService.populateAwardHierarchyItems(timeAndMoneyDocument, rootAwardNumber, new ArrayList<String>());
        HashMap<String, AwardHierarchyNode> awardHierarchyNodeItems = new HashMap<String, AwardHierarchyNode>();
        this.awardHierarchyService.populateAwardHierarchyNodes(timeAndMoneyDocument.getAwardHierarchyItems(), awardHierarchyNodeItems, award.getAwardNumber(), award.getSequenceNumber().toString());
        ArrayList<AwardHierarchyNode> awardHierarchyNodes = new ArrayList<AwardHierarchyNode>(awardHierarchyNodeItems.values());
        awardHierarchyNodes.add(0, null);
        this.timeAndMoneyService.captureDateChangeTransactions(timeAndMoneyDocument, awardHierarchyNodes);
        this.captureSingleNodeMoneyTransactions(timeAndMoneyDocument, awardHierarchyNodes);
    }

    protected void addTransactionDetails(TimeAndMoneyDto timeAndMoneyDto, TimeAndMoneyDocument timeAndMoneyDocument) {
        if (timeAndMoneyDto.getTransactionDetails() != null) {
            timeAndMoneyDocument.setPendingTransactions(timeAndMoneyDto.getTransactionDetails().stream().map(transactionDetail -> {
                PendingTransaction newPendingTransaction = this.commonApiService.convertObject(transactionDetail, PendingTransaction.class);
                newPendingTransaction.setAnticipatedAmount((ScaleTwoDecimal)newPendingTransaction.getAnticipatedDirectAmount().add((AbstractDecimal)newPendingTransaction.getAnticipatedIndirectAmount()));
                newPendingTransaction.setObligatedAmount((ScaleTwoDecimal)newPendingTransaction.getObligatedDirectAmount().add((AbstractDecimal)newPendingTransaction.getObligatedIndirectAmount()));
                return newPendingTransaction;
            }).collect(Collectors.toList()));
        }
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/time-and-money-documents/{documentNumber}"}, params={"version"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public String versionTimeAndMoney(@RequestBody TimeAndMoneyDto timeAndMoneyDto, @PathVariable String documentNumber) throws Exception {
        this.assertUserHasWriteAccess();
        this.commonApiService.clearErrors();
        if (timeAndMoneyDto == null) {
            throw new UnprocessableEntityException("No data provided to version document.");
        }
        TimeAndMoneyDocument timeAndMoneyDocument = this.timeAndMoneyDao.getTimeAndMoneyDocument(documentNumber);
        if (timeAndMoneyDocument == null) {
            throw new ResourceNotFoundException("Time and money document with number " + documentNumber + " was not found.");
        }
        String rootAwardNumber = timeAndMoneyDocument.getRootAwardNumber();
        TimeAndMoneyDocument finalTandM = this.timeAndMoneyVersionService.findOpenedTimeAndMoney(rootAwardNumber);
        this.addTransactionDetails(timeAndMoneyDto, finalTandM);
        Award award = this.awardVersionService.getWorkingAwardVersion(rootAwardNumber);
        this.updateAwardAmountTransactions(finalTandM, timeAndMoneyDto.getAwardAmountTransactions(), rootAwardNumber);
        finalTandM.setAward(award);
        this.captureAmountAndDateChanges(award, rootAwardNumber, finalTandM);
        this.documentService.saveDocument((Document)finalTandM);
        return finalTandM.getDocumentNumber();
    }

    private void updateAwardAmountTransactions(TimeAndMoneyDocument finalTandM, List<AwardAmountTransactionDto> awardAmountTransactions, String rootAwardNumber) {
        finalTandM.getAwardAmountTransactions().get(0).setAwardNumber(rootAwardNumber);
        finalTandM.getAwardAmountTransactions().get(0).setDocumentNumber(finalTandM.getDocumentNumber());
        this.updateAwardAmountTransactionInformation(finalTandM, awardAmountTransactions);
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/time-and-money-documents/{documentNumber}"}, params={"submit"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public TimeAndMoneyDto submitDocument(@PathVariable String documentNumber) throws WorkflowException {
        TimeAndMoneyDocument timeAndMoneyDocument;
        this.assertUserHasWriteAccess();
        this.commonApiService.clearErrors();
        try {
            timeAndMoneyDocument = this.commonApiService.getDocumentFromDocId(documentNumber, TimeAndMoneyDocument.class);
        }
        catch (UnknownDocumentIdException exception) {
            throw new ResourceNotFoundException("The document with document number" + documentNumber + " could not be located.");
        }
        Award award = this.awardVersionService.getWorkingAwardVersion(timeAndMoneyDocument.getRootAwardNumber());
        timeAndMoneyDocument.setAward(award);
        this.commonApiService.routeDocument((Document)timeAndMoneyDocument);
        return this.getTimeAndMoneyDto(timeAndMoneyDocument.getDocumentNumber());
    }

    public void captureSingleNodeMoneyTransactions(TimeAndMoneyDocument timeAndMoneyDocument, List<AwardHierarchyNode> awardHierarchyNodeItems) {
        ArrayList<TransactionDetail> moneyTransactionDetailItems = new ArrayList<TransactionDetail>();
        this.timeAndMoneyService.updateAwardAmountTransactions(timeAndMoneyDocument);
        if (timeAndMoneyDocument.getAwardHierarchyNodes().size() == 1) {
            for (Map.Entry<String, AwardHierarchyNode> awardHierarchyNode : timeAndMoneyDocument.getAwardHierarchyNodes().entrySet()) {
                this.timeAndMoneyService.captureMoneyChanges(awardHierarchyNodeItems, timeAndMoneyDocument, moneyTransactionDetailItems, awardHierarchyNode);
            }
        }
    }

    protected void addTransactionDetails(String documentNumber, TimeAndMoneyDto timeAndMoneyDto) {
        List<TransactionDetail> transactionDetails = this.timeAndMoneyDao.getTransactionDetailsForDocument(documentNumber);
        List<TransactionDetailDto> transactionDetailsDtos = transactionDetails.stream().map(transactionDetail -> this.commonApiService.convertObject(transactionDetail, TransactionDetailDto.class)).collect(Collectors.toList());
        timeAndMoneyDto.setTransactionDetails(transactionDetailsDtos);
    }

    protected TimeAndMoneyPostDto translateTimeAndMoney(TimeAndMoneyPosts timeAndMoneyPost) {
        TimeAndMoneyPostDto timeAndMoneyPostDto = this.commonApiService.convertObject(timeAndMoneyPost, TimeAndMoneyPostDto.class);
        TimeAndMoneyDto timeAndMoneyDto = this.getTimeAndMoneyDto(timeAndMoneyPost.getDocumentNumber());
        timeAndMoneyPostDto.setTimeAndMoney(timeAndMoneyDto);
        return timeAndMoneyPostDto;
    }

    protected TimeAndMoneyDto getTimeAndMoneyDto(String documentNumber) {
        TimeAndMoneyDocument timeAndMoneyDocument = this.timeAndMoneyDao.getTimeAndMoneyDocument(documentNumber);
        if (timeAndMoneyDocument == null) {
            throw new ResourceNotFoundException("Time and money document with document number " + documentNumber + " not found.");
        }
        TimeAndMoneyDto timeAndMoneyDto = this.commonApiService.convertObject(timeAndMoneyDocument, TimeAndMoneyDto.class);
        this.addTransactionDetails(documentNumber, timeAndMoneyDto);
        return timeAndMoneyDto;
    }

    public boolean isApiAuthEnabled() {
        return this.parameterService.getParameterValueAsBoolean("KC-GEN", "Document", "RESKC-2456_Enable_Api_Authorization");
    }

    protected void assertUserHasReadAccess() {
        if (this.isApiAuthEnabled() && (this.globalVariableService.getUserSession() == null || !this.permissionService.hasPermissionByTemplate(this.globalVariableService.getUserSession().getPrincipalId(), "KC-SYS", "Read Class", Collections.singletonMap("className", Award.class.getName())))) {
            throw new UnauthorizedAccessException();
        }
    }

    protected void assertUserHasWriteAccess() {
        if (this.isApiAuthEnabled() && (this.globalVariableService.getUserSession() == null || !this.permissionService.hasPermissionByTemplate(this.globalVariableService.getUserSession().getPrincipalId(), "KC-SYS", "Write Class", Collections.singletonMap("className", Award.class.getName())))) {
            throw new UnauthorizedAccessException();
        }
    }
}

