-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

DELIMITER /

drop procedure if exists resolveMultipleSequenceTables
/

create procedure resolveMultipleSequenceTables() 
begin
declare seqExists int default 0;
declare records int default 0;
select count(*) into seqExists from information_schema.tables where table_schema = DATABASE() and table_name = 'COMM_SCHEDULE_ATTACHMENT_ID';

if (seqExists > 0) then
select count(*) into records from COMM_SCHEDULE_ATTACHMENT_ID;
if (records > 0) then
select max(id)+1 into @newMax from COMM_SCHEDULE_ATTACHMENT_ID;
select concat('alter table SEQ_COMM_SCHED_ATTACH_ID AUTO_INCREMENT = ', @newMax) into @fixStmt from dual;
prepare stmt from @fixStmt;
execute stmt;
end if;
end if;

end
/

call resolveMultipleSequenceTables()
/

drop procedure resolveMultipleSequenceTables
/

drop table if exists COMM_SCHEDULE_ATTACHMENT_ID
/

DELIMITER ;
