/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.util;

import java.io.IOException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.util.xml.SafeXmlUtils;
import org.kuali.rice.ken.bo.NotificationBo;
import org.kuali.rice.ken.bo.NotificationChannelBo;
import org.kuali.rice.ken.bo.NotificationContentTypeBo;
import org.kuali.rice.ken.bo.NotificationPriorityBo;
import org.kuali.rice.ken.bo.NotificationProducerBo;
import org.kuali.rice.ken.bo.NotificationRecipientBo;
import org.kuali.rice.ken.bo.NotificationSenderBo;
import org.kuali.rice.ken.service.NotificationContentTypeService;
import org.kuali.rice.ken.util.ClassLoaderEntityResolver;
import org.kuali.rice.ken.util.CompoundEntityResolver;
import org.kuali.rice.ken.util.CompoundNamespaceContext;
import org.kuali.rice.ken.util.ConfiguredNamespaceContext;
import org.kuali.rice.ken.util.ContentTransformer;
import org.kuali.rice.ken.util.ContentTypeEntityResolver;
import org.kuali.rice.ken.util.DocumentNamespaceContext;
import org.kuali.rice.ken.util.XslSourceResolver;
import org.kuali.rice.krad.data.DataObjectService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class Util {
    private static final Logger LOG = LogManager.getLogger(Util.class);
    public static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final NamespaceContext NOTIFICATION_NAMESPACE_CONTEXT = new ConfiguredNamespaceContext(Collections.singletonMap("nreq", "ns:notification/NotificationRequest"));
    private static final String ZULU_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private static final TimeZone ZULU_TZ = TimeZone.getTimeZone("UTC");
    private static final String CURR_TZ_FORMAT = "MM/dd/yyyy hh:mm a";

    private Util() {
        throw new UnsupportedOperationException("do not call");
    }

    public static String getNotificationSystemUser() {
        String system_user = ConfigContext.getCurrentContextConfig().getProperty("ken.system.user");
        if (system_user == null) {
            system_user = "notsys";
        }
        return system_user;
    }

    public static Date parseXSDDateTime(String dateTimeString) throws ParseException {
        return Util.createZulu().parse(dateTimeString);
    }

    public static String toXSDDateTimeString(Date d) {
        return Util.createZulu().format(d);
    }

    public static String getCurrentDateTime() {
        return Util.toUIDateTimeString(new Date());
    }

    public static String toUIDateTimeString(Date d) {
        return Util.createCurrTz().format(d);
    }

    public static Date parseUIDateTime(String s) throws ParseException {
        return Util.createCurrTz().parse(s);
    }

    public static NamespaceContext getNotificationNamespaceContext(Document doc) {
        return new CompoundNamespaceContext(NOTIFICATION_NAMESPACE_CONTEXT, new DocumentNamespaceContext(doc));
    }

    public static EntityResolver getNotificationEntityResolver(NotificationContentTypeService notificationContentTypeService) {
        return new CompoundEntityResolver(new ClassLoaderEntityResolver("schema", "notification"), new ContentTypeEntityResolver(notificationContentTypeService));
    }

    public static String transformContent(NotificationBo notification) {
        NotificationContentTypeBo contentType = notification.getContentType();
        String xsl = contentType.getXsl();
        LOG.debug("xsl: " + xsl);
        XslSourceResolver xslresolver = new XslSourceResolver();
        StreamSource xslsource = xslresolver.resolveXslFromString(xsl);
        String content = notification.getContent();
        LOG.debug("xslsource:" + xslsource.toString());
        String contenthtml = new String();
        try {
            ContentTransformer transformer = new ContentTransformer(xslsource);
            contenthtml = transformer.transform(content);
            LOG.debug("html: " + contenthtml);
        }
        catch (IOException ex) {
            LOG.error("IOException transforming document", (Throwable)ex);
        }
        catch (Exception ex) {
            LOG.error("Exception transforming document", (Throwable)ex);
        }
        return contenthtml;
    }

    public static Document parse(final InputSource source, boolean validate, boolean namespaceAware, EntityResolver entityResolver) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory dbf = SafeXmlUtils.safeDocumentBuilderFactory();
        dbf.setValidating(validate);
        dbf.setNamespaceAware(namespaceAware);
        dbf.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
        DocumentBuilder db = dbf.newDocumentBuilder();
        if (entityResolver != null) {
            db.setEntityResolver(entityResolver);
        }
        db.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException se) {
                LOG.warn("Warning parsing xml doc " + String.valueOf(source), (Throwable)se);
            }

            @Override
            public void error(SAXParseException se) throws SAXException {
                LOG.error("Error parsing xml doc " + String.valueOf(source), (Throwable)se);
                throw se;
            }

            @Override
            public void fatalError(SAXParseException se) throws SAXException {
                LOG.error("Fatal error parsing xml doc " + String.valueOf(source), (Throwable)se);
                throw se;
            }
        });
        return db.parse(source);
    }

    public static Document parseWithNotificationEntityResolver(InputSource source, boolean validate, boolean namespaceAware, NotificationContentTypeService notificationContentTypeService) throws ParserConfigurationException, IOException, SAXException {
        return Util.parse(source, validate, namespaceAware, Util.getNotificationEntityResolver(notificationContentTypeService));
    }

    public static Element getChildElement(Node parent, String name) {
        NodeList childList = parent.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            Node node = childList.item(i);
            if (node.getNodeType() != 1 || !name.equals(node.getLocalName()) && !name.equals(node.getNodeName())) continue;
            return (Element)node;
        }
        return null;
    }

    public static final NotificationBo cloneNotificationWithoutObjectReferences(NotificationBo notification) {
        NotificationBo clone = new NotificationBo();
        if (notification.getCreationDateTime() != null) {
            clone.setCreationDateTimeValue(new Timestamp(notification.getCreationDateTimeValue().getTime()));
        }
        if (notification.getAutoRemoveDateTime() != null) {
            clone.setAutoRemoveDateTimeValue(new Timestamp(notification.getAutoRemoveDateTimeValue().getTime()));
        }
        clone.setContent(new String(notification.getContent()));
        clone.setDeliveryType(new String(notification.getDeliveryType()));
        if (notification.getId() != null) {
            clone.setId(new Long(notification.getId()));
        }
        clone.setProcessingFlag(new String(notification.getProcessingFlag()));
        if (notification.getSendDateTimeValue() != null) {
            clone.setSendDateTimeValue(new Timestamp(notification.getSendDateTimeValue().getTime()));
        }
        clone.setTitle(notification.getTitle());
        NotificationChannelBo channel = new NotificationChannelBo();
        channel.setId(new Long(notification.getChannel().getId()));
        channel.setName(new String(notification.getChannel().getName()));
        channel.setDescription(new String(notification.getChannel().getDescription()));
        channel.setSubscribable(new Boolean(notification.getChannel().isSubscribable()));
        clone.setChannel(channel);
        NotificationContentTypeBo contentType = new NotificationContentTypeBo();
        contentType.setId(new Long(notification.getContentType().getId()));
        contentType.setDescription(new String(notification.getContentType().getDescription()));
        contentType.setName(new String(notification.getContentType().getName()));
        contentType.setNamespace(new String(notification.getContentType().getNamespace()));
        clone.setContentType(contentType);
        NotificationPriorityBo priority = new NotificationPriorityBo();
        priority.setDescription(new String(notification.getPriority().getDescription()));
        priority.setId(new Long(notification.getPriority().getId()));
        priority.setName(new String(notification.getPriority().getName()));
        priority.setOrder(new Integer(notification.getPriority().getOrder()));
        clone.setPriority(priority);
        NotificationProducerBo producer = new NotificationProducerBo();
        producer.setDescription(new String(notification.getProducer().getDescription()));
        producer.setId(new Long(notification.getProducer().getId()));
        producer.setName(new String(notification.getProducer().getName()));
        producer.setContactInfo(new String(notification.getProducer().getContactInfo()));
        clone.setProducer(producer);
        ArrayList<NotificationRecipientBo> recipients = new ArrayList<NotificationRecipientBo>();
        for (int i = 0; i < notification.getRecipients().size(); ++i) {
            NotificationRecipientBo recipient = notification.getRecipient(i);
            NotificationRecipientBo cloneRecipient = new NotificationRecipientBo();
            cloneRecipient.setRecipientId(new String(recipient.getRecipientId()));
            cloneRecipient.setRecipientType(new String(recipient.getRecipientType()));
            recipients.add(cloneRecipient);
        }
        clone.setRecipients(recipients);
        ArrayList<NotificationSenderBo> senders = new ArrayList<NotificationSenderBo>();
        for (int i = 0; i < notification.getSenders().size(); ++i) {
            NotificationSenderBo sender = notification.getSender(i);
            NotificationSenderBo cloneSender = new NotificationSenderBo();
            cloneSender.setSenderName(new String(sender.getSenderName()));
            senders.add(cloneSender);
        }
        clone.setSenders(senders);
        return clone;
    }

    public static <T> T retrieveFieldReference(String fieldName, String keyName, String keyValue, Class clazz, DataObjectService dataObjectService, Boolean searchCurrentField) throws RuntimeException {
        LOG.debug(fieldName + " key value: " + keyValue);
        if (StringUtils.isBlank((String)keyValue)) {
            throw new IllegalArgumentException(fieldName + " must be specified in notification");
        }
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(PredicateFactory.equal((String)keyName, (Object)keyValue));
        if (searchCurrentField.booleanValue()) {
            predicates.add(PredicateFactory.equal((String)"current", (Object)Boolean.TRUE));
        }
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(predicates.toArray(new Predicate[predicates.size()]));
        List references = dataObjectService.findMatching(clazz, criteria.build()).getResults();
        if (references.isEmpty()) {
            throw new IllegalArgumentException(fieldName + " '" + keyValue + "' not found");
        }
        if (references.size() > 1) {
            throw new RuntimeException("More than one item found for the given value: " + keyValue);
        }
        return (T)references.get(0);
    }

    public static <T> T retrieveFieldReference(String fieldName, String keyName, String keyValue, Class clazz, DataObjectService dataObjectService) throws RuntimeException {
        return Util.retrieveFieldReference(fieldName, keyName, keyValue, clazz, dataObjectService, false);
    }

    private static DateFormat createZulu() {
        SimpleDateFormat df = new SimpleDateFormat(ZULU_FORMAT);
        df.setTimeZone(ZULU_TZ);
        return df;
    }

    private static DateFormat createCurrTz() {
        return new SimpleDateFormat(CURR_TZ_FORMAT);
    }
}

