/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.award.api;

import java.util.List;
import java.util.Map;
import org.kuali.coeus.award.api.AwardApiService;
import org.kuali.coeus.award.dto.AwardCustomDataArgValueDto;
import org.kuali.coeus.award.dto.AwardDto;
import org.kuali.coeus.common.api.document.service.CommonApiService;
import org.kuali.coeus.common.framework.custom.arg.ArgValueLookup;
import org.kuali.kra.award.home.Award;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="awardApiService")
public class AwardApiServiceImpl
implements AwardApiService {
    @Autowired
    @Qualifier(value="commonApiService")
    private CommonApiService commonApiService;
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;

    @Override
    public AwardDto convertAwardToDto(Award award) {
        AwardDto awardDto;
        if (award.getAwardStatus() == null) {
            award.refreshReferenceObject("awardStatus");
        }
        if (award.getPrimeSponsor() == null) {
            award.refreshReferenceObject("primeSponsor");
        }
        if (award.getAwardMethodOfPayment() == null) {
            award.refreshReferenceObject("awardMethodOfPayment");
        }
        if (award.getAwardBasisOfPayment() == null) {
            award.refreshReferenceObject("awardBasisOfPayment");
        }
        if ((awardDto = this.commonApiService.convertObject(award, AwardDto.class)).getAwardCustomDataList() != null && awardDto.getAwardCustomDataList().size() > 0) {
            awardDto.setAwardCustomDataList(awardDto.getAwardCustomDataList().stream().map(customData -> {
                List argValues;
                if (customData.getLookupClass() != null && customData.getLookupField() != null && customData.getLookupClass().equalsIgnoreCase(ArgValueLookup.class.getName()) && customData.getValue() != null && !(argValues = this.businessObjectService.findMatching(ArgValueLookup.class, Map.of("ARGUMENT_NAME", customData.getLookupField(), "VALUE", customData.getValue()))).isEmpty()) {
                    customData.setArgValue(this.commonApiService.convertObject(argValues.get(0), AwardCustomDataArgValueDto.class));
                }
                return customData;
            }).toList());
        }
        return awardDto;
    }

    public CommonApiService getCommonApiService() {
        return this.commonApiService;
    }

    public void setCommonApiService(CommonApiService commonApiService) {
        this.commonApiService = commonApiService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

