/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.sponsor;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.sponsor.hierarchy.SponsorHierarchy;
import org.kuali.coeus.common.impl.sponsor.SponsorHierarchyMaintenanceService;
import org.kuali.coeus.common.impl.sponsor.hierarchy.SponsorHierarchyDao;
import org.kuali.coeus.common.impl.sponsor.hierarchy.SponsorHierarchyForm;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.kra.infrastructure.Constants;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="sponsorHierarchyMaintenanceService")
public class SponsorHierarchyMaintenanceServiceImpl
implements SponsorHierarchyMaintenanceService,
Constants {
    private static final Logger LOG = LogManager.getLogger(SponsorHierarchyMaintenanceServiceImpl.class);
    private static final String SESSION_KEY = SponsorHierarchyMaintenanceServiceImpl.class.getName() + ".actionList";
    private static final Integer HIERARCHY_MAX_HEIGHT = 10;
    @Autowired
    @Qualifier(value="sponsorHierarchyDao")
    private SponsorHierarchyDao sponsorHierarchyDao;
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;

    @Override
    public String getTopSponsorHierarchy() {
        Object topSponsorHierarchy = "";
        List sponsorHierarchies = (List)this.getTopSponsorHierarchyList();
        Collections.sort(sponsorHierarchies);
        for (Object hierarchyName : sponsorHierarchies) {
            topSponsorHierarchy = (String)topSponsorHierarchy + String.valueOf(hierarchyName) + ";1;";
        }
        if (((String)topSponsorHierarchy).length() >= 3) {
            topSponsorHierarchy = ((String)topSponsorHierarchy).substring(0, ((String)topSponsorHierarchy).length() - 3);
        }
        return topSponsorHierarchy;
    }

    @Override
    public Collection getTopSponsorHierarchyList() {
        Iterator sponsorHierarchyList = this.sponsorHierarchyDao.getTopSponsorHierarchy();
        ArrayList<String> sponsorHierarchies = new ArrayList<String>();
        while (sponsorHierarchyList.hasNext()) {
            Object[] names = (Object[])sponsorHierarchyList.next();
            String name = (String)names[0];
            sponsorHierarchies.add(name);
        }
        Collections.sort(sponsorHierarchies);
        return sponsorHierarchies;
    }

    @Override
    public String getSubSponsorHierarchiesForTreeView(String hierarchyName, String depth, String groups) {
        Object returnSponsorHierarchy = null;
        String[] ascendantList = groups.split(";1;");
        if (Integer.parseInt(depth) < 10) {
            returnSponsorHierarchy = this.getSubSponsorHierarchy(hierarchyName, Integer.parseInt(depth) + 1, ascendantList);
        }
        if (StringUtils.isBlank(returnSponsorHierarchy) && StringUtils.isNotBlank((CharSequence)(returnSponsorHierarchy = this.getSponsorCodesForGroup(hierarchyName, Integer.parseInt(depth) + 1, ascendantList)))) {
            returnSponsorHierarchy = "((leafNodes));1;" + (String)returnSponsorHierarchy;
        }
        return returnSponsorHierarchy;
    }

    protected String getSubSponsorHierarchy(String hierarchyName, int level, String[] levelName) {
        HashMap<Object, String> values = new HashMap<Object, String>();
        values.put("hierarchyName", hierarchyName);
        for (int i = 1; i < level; ++i) {
            values.put("level" + i, levelName[i - 1]);
        }
        List sponsors = this.getBusinessObjectService().findMatchingOrderBy(SponsorHierarchy.class, values, "level" + level + "Sortid", true);
        try {
            Method getLevel = SponsorHierarchy.class.getDeclaredMethod("getLevel" + level, null);
            Method getSortId = SponsorHierarchy.class.getDeclaredMethod("getLevel" + level + "Sortid", null);
            Object retVal = null;
            ArrayList<CallSite> uniqueLevel = new ArrayList<CallSite>();
            for (SponsorHierarchy sponsorHierarchy : sponsors) {
                String levelValue = (String)getLevel.invoke((Object)sponsorHierarchy, null);
                Integer sortValue = (Integer)getSortId.invoke((Object)sponsorHierarchy, null);
                if (levelValue == null || uniqueLevel.contains(levelValue + ":1:" + sortValue)) continue;
                uniqueLevel.add((CallSite)((Object)(levelValue + ":1:" + sortValue)));
            }
            for (String string : uniqueLevel) {
                if (retVal == null) {
                    retVal = string.split(":1:")[0];
                    continue;
                }
                retVal = (String)retVal + ";1;" + string.split(":1:")[0];
            }
            return retVal;
        }
        catch (Exception e) {
            LOG.error("Error getting sponsor hierarchy information", (Throwable)e);
            return null;
        }
    }

    protected String getSponsorCodesForGroup(String hierarchyName, int level, String[] levelName) {
        HashMap<Object, String> values = new HashMap<Object, String>();
        values.put("hierarchyName", hierarchyName);
        for (int i = 1; i < level; ++i) {
            values.put("level" + i, levelName[i - 1]);
        }
        int groupingNumber = 300;
        try {
            String sysParam = this.parameterService.getParameterValueAsString("KC-PD", "A", "numberPerSponsorHierarchyGroup");
            groupingNumber = Integer.parseInt(sysParam);
        }
        catch (Exception e) {
            LOG.debug("System param for numberPerSponsorHierarchyGroup is not defined");
        }
        List sponsors = this.getBusinessObjectService().findMatchingOrderBy(SponsorHierarchy.class, values, "sponsorCode", true);
        String retVal = null;
        int i = groupingNumber;
        for (SponsorHierarchy sponsor : sponsors) {
            if (StringUtils.isBlank(retVal)) {
                retVal = sponsor.getSponsorCode() + ":" + sponsor.getSponsor().getSponsorName();
                --i;
                continue;
            }
            if (i-- > 0) {
                retVal = retVal + ";1;" + sponsor.getSponsorCode() + ":" + sponsor.getSponsor().getSponsorName();
                continue;
            }
            retVal = retVal + "#1#" + sponsor.getSponsorCode() + ":" + sponsor.getSponsor().getSponsorName();
            i = groupingNumber;
        }
        return retVal;
    }

    protected String getSponsorCodesForDeletedGroup(String hierarchyName, int level, String[] levelName) {
        HashMap<Object, String> values = new HashMap<Object, String>();
        values.put("hierarchyName", hierarchyName);
        for (int i = 1; i < level; ++i) {
            values.put("level" + i, levelName[i - 1]);
        }
        List sponsors = this.getBusinessObjectService().findMatching(SponsorHierarchy.class, values);
        Object retVal = null;
        for (SponsorHierarchy sponsor : sponsors) {
            if (StringUtils.isBlank(retVal)) {
                retVal = sponsor.getSponsorCode();
                continue;
            }
            retVal = (String)retVal + ";" + sponsor.getSponsorCode();
        }
        return retVal;
    }

    @Override
    public void copySponsorHierarchy(SponsorHierarchyForm sponsorHierarchyForm) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("hierarchyName", sponsorHierarchyForm.getSelectedSponsorHierarchy());
        List sponsors = this.businessObjectService.findMatching(SponsorHierarchy.class, fieldValues);
        ArrayList<SponsorHierarchy> newSponsors = new ArrayList<SponsorHierarchy>();
        for (Object sponsorHierarchyObj : sponsors) {
            SponsorHierarchy sponsorHierarchy = (SponsorHierarchy)sponsorHierarchyObj;
            sponsorHierarchy.setHierarchyName(sponsorHierarchyForm.getNewHierarchyName());
            newSponsors.add(sponsorHierarchy);
        }
        this.businessObjectService.save(newSponsors);
    }

    @Override
    public void deleteSponsorHierarchy(SponsorHierarchyForm sponsorHierarchyForm) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("hierarchyName", sponsorHierarchyForm.getSelectedSponsorHierarchy());
        List sponsors = this.businessObjectService.findMatching(SponsorHierarchy.class, fieldValues);
        this.businessObjectService.delete(sponsors);
    }

    @Override
    public String loadToSponsorHierachyMt(String hierarchyName) {
        Object sponsorCodes = "";
        Iterator sponsorHierarchyList = this.sponsorHierarchyDao.getAllSponsors(hierarchyName);
        while (sponsorHierarchyList.hasNext()) {
            sponsorCodes = (String)sponsorCodes + String.valueOf(((Object[])sponsorHierarchyList.next())[0]) + ";";
        }
        return sponsorCodes;
    }

    @Override
    public String getSponsorCodes(String hierarchyName, String depth, String groups) {
        String[] ascendantList = groups.split(";1;");
        return this.getSponsorCodesForDeletedGroup(hierarchyName, Integer.parseInt(depth) + 1, ascendantList);
    }

    @Override
    public void updateSponsorCodes(String sponsorCodes) {
        if (this.globalVariableService.getUserSession().retrieveObject("sponsorCodes") != null) {
            this.globalVariableService.getUserSession().removeObject("sponsorCodes");
        }
        this.globalVariableService.getUserSession().addObject("sponsorCodes", (Object)sponsorCodes);
    }

    @Override
    public void insertSponsor(String hierarchyName, String[] sponsorCodes, String[] levels, Integer[] sortIds) {
        for (String sponsorCode : sponsorCodes) {
            SponsorAction newAction = new SponsorAction();
            newAction.actionType = SponsorActionType.INSERT;
            newAction.hierarchyName = hierarchyName;
            newAction.sponsorCode = sponsorCode;
            newAction.setLevels(levels);
            newAction.setSortIds(sortIds);
            this.addActionToBeSaved(newAction);
        }
    }

    @Override
    public void deleteSponsor(String hierarchyName, String sponsorCode, String[] levels) {
        SponsorAction newAction = new SponsorAction();
        newAction.actionType = SponsorActionType.DELETE;
        newAction.hierarchyName = hierarchyName;
        newAction.sponsorCode = sponsorCode;
        newAction.setLevels(levels);
        this.addActionToBeSaved(newAction);
    }

    @Override
    public void updateGroupName(String hierarchyName, Integer levelToChange, String oldGroupName, String newGroupName, String[] levels) {
        SponsorAction newAction = new SponsorAction();
        newAction.actionType = SponsorActionType.UPDATE_NAME;
        newAction.hierarchyName = hierarchyName;
        newAction.levelToChange = levelToChange;
        newAction.oldGroupName = oldGroupName;
        newAction.newGroupName = newGroupName;
        newAction.setLevels(levels);
        this.addActionToBeSaved(newAction);
    }

    @Override
    public void changeSponsorSortOrder(String hierarchyName, Integer levelToChange, Boolean moveDown, String[] levels) {
        SponsorAction newAction = new SponsorAction();
        newAction.actionType = SponsorActionType.UPDATE_SORT;
        newAction.hierarchyName = hierarchyName;
        newAction.levelToChange = levelToChange;
        newAction.moveDown = moveDown;
        newAction.setLevels(levels);
        this.addActionToBeSaved(newAction);
    }

    protected void addActionToBeSaved(SponsorAction action) {
        ArrayList<SponsorAction> actions = (ArrayList<SponsorAction>)this.globalVariableService.getUserSession().retrieveObject(SESSION_KEY);
        if (actions == null) {
            actions = new ArrayList<SponsorAction>();
            this.globalVariableService.getUserSession().addObject(SESSION_KEY, actions);
        }
        actions.add(action);
    }

    @Override
    public void executeActions() {
        List actions = (List)this.globalVariableService.getUserSession().retrieveObject(SESSION_KEY);
        if (actions != null) {
            for (SponsorAction action : actions) {
                List sponsors;
                if (action.actionType == SponsorActionType.INSERT) {
                    SponsorHierarchy newSponsor = new SponsorHierarchy();
                    newSponsor.setHierarchyName(action.hierarchyName);
                    newSponsor.setSponsorCode(action.sponsorCode);
                    newSponsor.setLevel1(action.levels[0]);
                    newSponsor.setLevel2(action.levels[1]);
                    newSponsor.setLevel3(action.levels[2]);
                    newSponsor.setLevel4(action.levels[3]);
                    newSponsor.setLevel5(action.levels[4]);
                    newSponsor.setLevel6(action.levels[5]);
                    newSponsor.setLevel7(action.levels[6]);
                    newSponsor.setLevel8(action.levels[7]);
                    newSponsor.setLevel9(action.levels[8]);
                    newSponsor.setLevel10(action.levels[9]);
                    newSponsor.setLevel1Sortid(action.sortIds[0]);
                    newSponsor.setLevel2Sortid(action.sortIds[1]);
                    newSponsor.setLevel3Sortid(action.sortIds[2]);
                    newSponsor.setLevel4Sortid(action.sortIds[3]);
                    newSponsor.setLevel5Sortid(action.sortIds[4]);
                    newSponsor.setLevel6Sortid(action.sortIds[5]);
                    newSponsor.setLevel7Sortid(action.sortIds[6]);
                    newSponsor.setLevel8Sortid(action.sortIds[7]);
                    newSponsor.setLevel9Sortid(action.sortIds[8]);
                    newSponsor.setLevel10Sortid(action.sortIds[9]);
                    this.getBusinessObjectService().save((PersistableBusinessObject)newSponsor);
                    continue;
                }
                if (action.actionType == SponsorActionType.DELETE) {
                    this.getBusinessObjectService().deleteMatching(SponsorHierarchy.class, this.getFieldValues(action));
                    continue;
                }
                if (action.actionType == SponsorActionType.UPDATE_NAME) {
                    sponsors = this.getBusinessObjectService().findMatching(SponsorHierarchy.class, this.getFieldValues(action));
                    for (SponsorHierarchy sponsor : sponsors) {
                        this.updateGroup(sponsor, action.levelToChange, action.newGroupName);
                        this.getBusinessObjectService().save((PersistableBusinessObject)sponsor);
                    }
                    continue;
                }
                if (action.actionType != SponsorActionType.UPDATE_SORT) continue;
                sponsors = this.getBusinessObjectService().findMatching(SponsorHierarchy.class, this.getFieldValues(action));
                for (SponsorHierarchy sponsor : sponsors) {
                    this.updateSortId(sponsor, action.levelToChange, action.moveDown);
                    this.getBusinessObjectService().save((PersistableBusinessObject)sponsor);
                }
            }
            actions.clear();
        }
    }

    protected void updateGroup(SponsorHierarchy sponsor, Integer level, String newGroupName) {
        try {
            Method setLevelMethod = SponsorHierarchy.class.getMethod("setLevel" + level, String.class);
            setLevelMethod.invoke((Object)sponsor, newGroupName);
        }
        catch (Exception e) {
            LOG.debug("Error setting group name on sponsor", (Throwable)e);
        }
    }

    protected void updateSortId(SponsorHierarchy sponsor, Integer level, Boolean moveDown) {
        int changeBy = 1;
        if (moveDown.booleanValue()) {
            changeBy = -1;
        }
        try {
            Method setSortIdMethod = SponsorHierarchy.class.getMethod("setLevel" + level + "Sortid", Integer.class);
            Method getSortIdMethod = SponsorHierarchy.class.getMethod("getLevel" + level + "Sortid", null);
            setSortIdMethod.invoke((Object)sponsor, this.getNewSortId((Integer)getSortIdMethod.invoke((Object)sponsor, (Object[])null), changeBy));
        }
        catch (Exception e) {
            LOG.debug("Error setting new sortId on sponsor", (Throwable)e);
        }
    }

    protected Integer getNewSortId(Integer currentSortId, int changeBy) {
        if (currentSortId == null) {
            currentSortId = 0;
        }
        return currentSortId + changeBy;
    }

    protected Map<String, String> getFieldValues(SponsorAction action) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("hierarchyName", action.hierarchyName);
        if (StringUtils.isNotBlank((CharSequence)action.sponsorCode)) {
            fieldValues.put("sponsorCode", action.sponsorCode);
        }
        for (int i = 0; i < action.levels.length; ++i) {
            if (!StringUtils.isNotBlank((CharSequence)action.levels[i])) continue;
            fieldValues.put("level" + (i + 1), action.levels[i]);
        }
        if (StringUtils.isNotBlank((CharSequence)action.oldGroupName)) {
            fieldValues.put("level" + action.levelToChange, action.oldGroupName);
        }
        return fieldValues;
    }

    @Override
    public void clearCurrentActions() {
        this.globalVariableService.getUserSession().removeObject(SESSION_KEY);
    }

    @Override
    public List<String> getUniqueGroupingNames(String hierarchyName, Integer level) {
        List<String> result = this.getSponsorHierarchyDao().getUniqueNamesAtLevel(hierarchyName, level);
        Collections.sort(result);
        return result;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    protected SponsorHierarchyDao getSponsorHierarchyDao() {
        return this.sponsorHierarchyDao;
    }

    protected void setSponsorHierarchyDao(SponsorHierarchyDao sponsorHierarchyDao) {
        this.sponsorHierarchyDao = sponsorHierarchyDao;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    protected static class SponsorAction
    implements Serializable {
        public SponsorActionType actionType;
        public String hierarchyName;
        public String sponsorCode;
        public String[] levels = new String[HIERARCHY_MAX_HEIGHT.intValue()];
        public Integer[] sortIds = new Integer[HIERARCHY_MAX_HEIGHT.intValue()];
        public Integer levelToChange;
        public String oldGroupName;
        public String newGroupName;
        public Boolean moveDown;

        protected SponsorAction() {
        }

        public void setLevels(String[] newLevels) {
            for (int i = 0; i < this.levels.length && i < newLevels.length; ++i) {
                this.levels[i] = newLevels[i];
            }
        }

        public void setSortIds(Integer[] newSortIds) {
            for (int i = 0; i < this.sortIds.length && i < newSortIds.length; ++i) {
                this.sortIds[i] = newSortIds[i];
            }
        }
    }

    protected static enum SponsorActionType {
        INSERT,
        UPDATE_NAME,
        UPDATE_SORT,
        DELETE;

    }
}

