/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdevrest.impl.budget.standalone;

import java.util.Collections;
import java.util.List;
import org.kuali.coeus.common.budget.api.standalone.BudgetDto;
import org.kuali.coeus.common.budget.api.standalone.BudgetSummaryDto;
import org.kuali.coeus.common.budget.api.standalone.StandaloneBudgetImportService;
import org.kuali.coeus.propdev.impl.budget.standalone.ProposalStandaloneBudgetBo;
import org.kuali.coeus.propdev.impl.budget.standalone.StandaloneBudgetCacheService;
import org.kuali.coeus.sys.framework.controller.rest.RestController;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.krad.data.DataObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class BudgetCalculationsRestController
extends RestController {
    private static final String PROPOSAL_ID_PARAM = "proposalId";
    private static final String BUDGET_ID_PARAM = "budgetId";
    @Autowired
    @Qualifier(value="standaloneBudgetImportService")
    private StandaloneBudgetImportService standaloneBudgetImportService;
    @Autowired
    @Qualifier(value="standaloneBudgetCacheService")
    private StandaloneBudgetCacheService standaloneBudgetCacheService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;

    @GetMapping(value={"/api/v1/budgets/import-new"})
    @ResponseBody
    public List<BudgetSummaryDto> listBudgets(@RequestParam(value="proposalId") String proposalId) {
        if (this.standaloneBudgetImportService.isEnabled()) {
            List<BudgetSummaryDto> budgets = this.standaloneBudgetImportService.listBudgets(proposalId);
            this.standaloneBudgetCacheService.updateCache(budgets, this.getDataObjectService().findMatching(ProposalStandaloneBudgetBo.class, QueryByCriteria.Builder.forAttribute((String)"proposalNumber", (Object)proposalId).build()).getResults());
            return budgets;
        }
        return Collections.emptyList();
    }

    @GetMapping(value={"/api/v1/budgets/import-one"})
    @ResponseBody
    public BudgetDto getBudget(@RequestParam(value="budgetId") String budgetId) {
        if (this.standaloneBudgetImportService.isEnabled()) {
            BudgetDto budget = this.standaloneBudgetImportService.getBudget(budgetId);
            if (budget != null) {
                this.standaloneBudgetCacheService.updateCache(List.of(budget), this.getDataObjectService().findMatching(ProposalStandaloneBudgetBo.class, QueryByCriteria.Builder.forAttribute((String)BUDGET_ID_PARAM, (Object)budgetId).build()).getResults());
            }
            return budget;
        }
        return null;
    }

    @GetMapping(value={"/api/v1/budgets/import-final"})
    @ResponseBody
    public BudgetDto getFinalBudget(@RequestParam(value="proposalId") String proposalId) {
        BudgetDto budget;
        if (this.standaloneBudgetImportService.isEnabled() && (budget = this.standaloneBudgetImportService.getFinalBudget(proposalId)) != null) {
            this.standaloneBudgetCacheService.updateCache(List.of(budget), this.getDataObjectService().findMatching(ProposalStandaloneBudgetBo.class, QueryByCriteria.Builder.forAttribute((String)BUDGET_ID_PARAM, (Object)budget.getBudgetId()).build()).getResults());
            return budget;
        }
        return null;
    }

    public StandaloneBudgetImportService getStandaloneBudgetImportService() {
        return this.standaloneBudgetImportService;
    }

    public void setStandaloneBudgetImportService(StandaloneBudgetImportService standaloneBudgetImportService) {
        this.standaloneBudgetImportService = standaloneBudgetImportService;
    }

    public StandaloneBudgetCacheService getStandaloneBudgetCacheService() {
        return this.standaloneBudgetCacheService;
    }

    public void setStandaloneBudgetCacheService(StandaloneBudgetCacheService standaloneBudgetCacheService) {
        this.standaloneBudgetCacheService = standaloneBudgetCacheService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

