/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.negotiations.rules;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.upload.FormFile;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.ErrorReporter;
import org.kuali.kra.negotiations.bo.Negotiation;
import org.kuali.kra.negotiations.bo.NegotiationActivity;
import org.kuali.kra.negotiations.bo.NegotiationActivityAttachment;
import org.kuali.kra.negotiations.document.NegotiationDocument;
import org.kuali.kra.negotiations.rules.NegotiationActivityAttachmentAddRule;
import org.kuali.kra.negotiations.rules.NegotiationActivityAttachmentAddRuleEvent;
import org.kuali.rice.krad.util.GlobalVariables;

public class NegotiationActivityAttachmentRuleImpl
implements NegotiationActivityAttachmentAddRule {
    private static final Logger LOG = LogManager.getLogger(NegotiationActivityAttachmentRuleImpl.class);
    private final ErrorReporter errorReporter = KcServiceLocator.getService(ErrorReporter.class);

    @Override
    public boolean processAddAttachmentRule(NegotiationActivityAttachmentAddRuleEvent event) {
        boolean result = true;
        NegotiationDocument document = (NegotiationDocument)event.getDocument();
        Negotiation negotiation = document.getNegotiation();
        NegotiationActivity activity = event.getActivity();
        NegotiationActivityAttachment newAttachment = event.getNewAttachment();
        FormFile newFile = newAttachment.getNewFile();
        GlobalVariables.getMessageMap().addToErrorPath(event.getErrorPathPrefix());
        result &= this.validateAttachmentRule(negotiation, activity, newAttachment);
        if (!this.errorReporter.propertyHasErrorReported(GlobalVariables.getMessageMap().getKeyPath("newFile", true)) && (newFile == null || StringUtils.isBlank((CharSequence)newFile.getFileName()))) {
            result = false;
            this.errorReporter.reportError("newFile", "error.required", "File (File)");
        }
        if (result && newFile != null && !this.errorReporter.propertyHasErrorReported(GlobalVariables.getMessageMap().getKeyPath("newFile", true))) {
            try {
                byte[] fileData = newFile.getFileData();
                if (fileData == null || fileData.length == 0) {
                    result = false;
                    LOG.error("Attachment file data is null or empty for file: {}", (Object)newFile.getFileName());
                    this.errorReporter.reportError("newFile", "error.attachment.file.required", new String[0]);
                }
            }
            catch (IOException e) {
                result = false;
                LOG.error("Error reading attachment file data for file: {}", (Object)newFile.getFileName(), (Object)e);
                this.errorReporter.reportError("newFile", "error.attachment.file.required", new String[0]);
            }
        }
        GlobalVariables.getMessageMap().removeFromErrorPath(event.getErrorPathPrefix());
        return result;
    }

    public boolean validateAttachmentRule(Negotiation negotiation, NegotiationActivity activity, NegotiationActivityAttachment attachment) {
        boolean result = true;
        if (!this.errorReporter.propertyHasErrorReported(GlobalVariables.getMessageMap().getKeyPath("description", true)) && StringUtils.isBlank((CharSequence)attachment.getDescription())) {
            result = false;
            this.errorReporter.reportError("description", "error.required", "Description (Description)");
        }
        return result;
    }
}

