/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.personmasschange.document;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.custom.DocumentCustomData;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.model.KcTransactionalDocumentBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.personmasschange.bo.PersonMassChange;
import org.kuali.kra.personmasschange.service.PersonMassChangeService;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;

public class PersonMassChangeDocument
extends KcTransactionalDocumentBase
implements Serializable {
    public static final String DOCUMENT_TYPE_CODE = "PMC";
    private static final long serialVersionUID = 4841496352465715699L;
    private List<PersonMassChange> personMassChangeList = new ArrayList<PersonMassChange>();
    private transient PersonMassChangeService personMassChangeService;

    public PersonMassChangeDocument() {
        PersonMassChange newPersonMassChange = new PersonMassChange();
        newPersonMassChange.setPersonMassChangeDocument(this);
        this.personMassChangeList.add(newPersonMassChange);
    }

    @Override
    public String getDocumentTypeCode() {
        return DOCUMENT_TYPE_CODE;
    }

    public List<PersonMassChange> getPersonMassChangeList() {
        return this.personMassChangeList;
    }

    public void setPersonMassChangeList(List<PersonMassChange> personMassChangeList) {
        this.personMassChangeList = personMassChangeList;
    }

    public PersonMassChange getPersonMassChange() {
        return this.personMassChangeList.isEmpty() ? null : this.personMassChangeList.get(0);
    }

    public void setPersonMassChange(PersonMassChange personMassChange) {
        this.personMassChangeList.set(0, personMassChange);
    }

    @Override
    public KcPersistableBusinessObjectBase getBusinessObject() {
        return this.getPersonMassChange();
    }

    @Override
    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        this.executeAsLastActionUser(() -> {
            super.doRouteStatusChange(statusChangeEvent);
            if (this.isFinal(statusChangeEvent)) {
                this.getPersonMassChangeService().performPersonMassChange(this.getPersonMassChange());
            }
            return null;
        });
    }

    private boolean isFinal(DocumentRouteStatusChange statusChangeEvent) {
        return StringUtils.equals((CharSequence)"F", (CharSequence)statusChangeEvent.getNewRouteStatus());
    }

    @Override
    public boolean isProcessComplete() {
        boolean isComplete = false;
        if (this.getDocumentHeader().hasWorkflowDocument() && this.getDocumentHeader().getWorkflowDocument().isFinal()) {
            isComplete = true;
        }
        return isComplete;
    }

    public PersonMassChangeService getPersonMassChangeService() {
        if (this.personMassChangeService == null) {
            this.personMassChangeService = KcServiceLocator.getService(PersonMassChangeService.class);
        }
        return this.personMassChangeService;
    }

    public void setPersonMassChangeService(PersonMassChangeService personMassChangeService) {
        this.personMassChangeService = personMassChangeService;
    }

    @Override
    public List<? extends DocumentCustomData> getDocumentCustomData() {
        return new ArrayList();
    }

    @Override
    public String getDocumentBoNumber() {
        return "" + this.getPersonMassChange().getPersonMassChangeId();
    }
}

