/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.util;

import org.displaytag.util.Href;
import org.displaytag.util.HtmlAttributeMap;

public class Anchor {
    private Href href;
    private String linkText;
    private final HtmlAttributeMap attributeMap = new HtmlAttributeMap();

    public Anchor(Href linkHref, String linkBody) {
        this.href = linkHref;
        this.linkText = linkBody;
    }

    public void setHref(Href linkHref) {
        this.href = linkHref;
    }

    public void setText(String linkBody) {
        this.linkText = linkBody;
    }

    public void setClass(String cssClass) {
        this.attributeMap.put("class", cssClass);
    }

    public void setStyle(String style) {
        this.attributeMap.put("style", style);
    }

    public void setTitle(String title) {
        this.attributeMap.put("title", title);
    }

    private String getHrefString() {
        if (this.href == null) {
            return "";
        }
        return " href=\"" + this.href.toString() + "\"";
    }

    public String getOpenTag() {
        if (this.attributeMap.size() == 0) {
            return "\n<a" + this.getHrefString() + ">";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("\n<").append("a").append(this.getHrefString());
        buffer.append(this.attributeMap);
        buffer.append(">");
        return buffer.toString();
    }

    public String getCloseTag() {
        return "</a>";
    }

    public String toString() {
        return this.getOpenTag() + this.linkText + this.getCloseTag();
    }
}

