/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.framework.engine.expression;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.commons.lang.ObjectUtils;
import org.kuali.rice.krms.api.engine.IncompatibleTypeException;
import org.kuali.rice.krms.framework.engine.expression.EngineComparatorExtension;
import org.kuali.rice.krms.framework.engine.expression.StringCoercionExtension;

public class DefaultComparisonOperator
implements EngineComparatorExtension,
StringCoercionExtension {
    public int compare(Object lhs, Object rhs) {
        if (lhs == null && rhs == null) {
            return 0;
        }
        if (lhs == null) {
            return -1;
        }
        if (rhs == null) {
            return 1;
        }
        if (rhs instanceof String && !(lhs instanceof String)) {
            rhs = this.coerceStringOperand(lhs, rhs.toString());
        } else if (lhs instanceof String && !(rhs instanceof String)) {
            lhs = this.coerceStringOperand(rhs, lhs.toString());
        }
        if (ObjectUtils.equals((Object)lhs, (Object)rhs)) {
            return 0;
        }
        if (lhs instanceof Comparable && rhs instanceof Comparable) {
            int result = ((Comparable)lhs).compareTo(rhs);
            return result;
        }
        throw new IncompatibleTypeException("DefaultComparisonOperator could not compare values", lhs, new Class[]{rhs.getClass()});
    }

    public boolean canCompare(Object lhs, Object rhs) {
        try {
            this.compare(lhs, rhs);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private Object coerceStringOperand(Object objectArg, String stringArg) {
        Object result = stringArg;
        if (objectArg != null && stringArg != null && !(objectArg instanceof String) && (result = this.coerceHelper(objectArg, stringArg, Double.class, Float.class, Long.class, Integer.class, Boolean.class)) instanceof String) {
            if (objectArg instanceof BigDecimal) {
                try {
                    result = BigDecimal.valueOf(Double.valueOf(stringArg.toString()));
                }
                catch (NumberFormatException e) {
                    throw new IncompatibleTypeException((Exception)e, "Could not coerce String to BigDecimal" + String.valueOf(this), (Object)stringArg, new Class[]{objectArg.getClass()});
                }
            } else if (objectArg instanceof BigInteger) {
                try {
                    result = BigInteger.valueOf(Long.valueOf(stringArg.toString()));
                }
                catch (NumberFormatException e) {
                    throw new IncompatibleTypeException((Exception)e, "Could not coerce String to BigInteger" + String.valueOf(this), (Object)stringArg, new Class[]{objectArg.getClass()});
                }
            } else {
                throw new IncompatibleTypeException("Could not compare values for operator " + String.valueOf(this), objectArg, new Class[]{stringArg.getClass()});
            }
        }
        return result;
    }

    private Object coerceHelper(Object objectArg, String stringArg, Class<?> ... clazzes) {
        for (Class<?> clazz : clazzes) {
            if (!clazz.isInstance(objectArg)) continue;
            try {
                return clazz.getMethod("valueOf", String.class).invoke(null, stringArg);
            }
            catch (NumberFormatException e) {
                throw new IncompatibleTypeException((Exception)e, "Could not coerce String to " + clazz.getSimpleName() + " " + String.valueOf(this), (Object)stringArg, new Class[]{objectArg.getClass()});
            }
            catch (NoSuchMethodException e) {
                throw new IncompatibleTypeException((Exception)e, "Could not coerce String to " + clazz.getSimpleName() + " " + String.valueOf(this), (Object)stringArg, new Class[]{objectArg.getClass()});
            }
            catch (InvocationTargetException e) {
                throw new IncompatibleTypeException((Exception)e, "Could not coerce String to " + clazz.getSimpleName() + " " + String.valueOf(this), (Object)stringArg, new Class[]{objectArg.getClass()});
            }
            catch (IllegalAccessException e) {
                throw new IncompatibleTypeException((Exception)e, "Could not coerce String to " + clazz.getSimpleName() + " " + String.valueOf(this), (Object)stringArg, new Class[]{objectArg.getClass()});
            }
        }
        return stringArg;
    }

    public Object coerce(String type, String value) {
        try {
            Class<?> clazz = Class.forName(type);
            Constructor<?> constructor = clazz.getConstructor(String.class);
            Object propObject = constructor.newInstance(value);
            return propObject;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean canCoerce(String type, String value) {
        return this.coerce(type, value) != null;
    }
}

