/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.lookup;

import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.encryption.EncryptionService;
import org.kuali.rice.core.api.search.SearchOperator;
import org.kuali.rice.core.api.util.type.TypeUtils;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;
import org.kuali.rice.krad.datadictionary.BusinessObjectEntry;
import org.kuali.rice.krad.datadictionary.DataObjectEntry;
import org.kuali.rice.krad.datadictionary.validation.constraint.ValidCharactersConstraint;
import org.kuali.rice.krad.lookup.CollectionIncomplete;
import org.kuali.rice.krad.lookup.LookupForm;
import org.kuali.rice.krad.lookup.LookupInputField;
import org.kuali.rice.krad.lookup.LookupUtils;
import org.kuali.rice.krad.lookup.LookupView;
import org.kuali.rice.krad.lookup.Lookupable;
import org.kuali.rice.krad.service.DataObjectAuthorizationService;
import org.kuali.rice.krad.service.DocumentDictionaryService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.LookupService;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.control.Control;
import org.kuali.rice.krad.uif.control.FilterableLookupCriteriaControl;
import org.kuali.rice.krad.uif.control.FilterableLookupCriteriaControlPostData;
import org.kuali.rice.krad.uif.control.HiddenControl;
import org.kuali.rice.krad.uif.control.ValueConfiguredControl;
import org.kuali.rice.krad.uif.element.Link;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.lifecycle.ViewPostMetadata;
import org.kuali.rice.krad.uif.service.impl.ViewHelperServiceImpl;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.util.ScriptUtils;
import org.kuali.rice.krad.util.BeanPropertyComparator;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.util.MessageMap;
import org.kuali.rice.krad.util.UrlFactory;

public class LookupableImpl
extends ViewHelperServiceImpl
implements Lookupable {
    private static final long serialVersionUID = 1885161468871327740L;
    private static final Logger LOG = LogManager.getLogger(LookupableImpl.class);
    private Class<?> dataObjectClass;
    private transient DataObjectAuthorizationService dataObjectAuthorizationService;
    private transient DocumentDictionaryService documentDictionaryService;
    private transient LookupService lookupService;
    private transient EncryptionService encryptionService;

    @Override
    public Collection<?> performSearch(LookupForm form, Map<String, String> searchCriteria, boolean bounded) {
        ArrayList<Object> sortedResults;
        Map<String, String> adjustedSearchCriteria = this.processSearchCriteria(form, searchCriteria);
        boolean isValidCriteria = this.validateSearchParameters(form, adjustedSearchCriteria);
        if (!isValidCriteria) {
            return new ArrayList();
        }
        List<String> wildcardAsLiteralSearchCriteria = this.identifyWildcardDisabledFields(form, adjustedSearchCriteria);
        Integer searchResultsLimit = null;
        if (bounded) {
            searchResultsLimit = LookupUtils.getSearchResultsLimit(this.getDataObjectClass(), form);
        }
        if (adjustedSearchCriteria == null) {
            MessageMap messageMap = GlobalVariables.getMessageMap();
            messageMap.putInfoForSectionId("LookupResultMessages", "lookup.results.none.found", new String[0]);
            return new ArrayList();
        }
        Collection<?> searchResults = null;
        searchResults = ExternalizableBusinessObject.class.isAssignableFrom(this.getDataObjectClass()) ? this.getSearchResultsForEBO(adjustedSearchCriteria, !bounded) : this.getSearchResults(adjustedSearchCriteria, wildcardAsLiteralSearchCriteria, !bounded, searchResultsLimit);
        this.generateLookupResultsMessages(adjustedSearchCriteria, searchResults, bounded, searchResultsLimit);
        if (searchResults != null) {
            sortedResults = new ArrayList(searchResults);
            this.sortSearchResults(form, (List)sortedResults);
        } else {
            sortedResults = new ArrayList();
        }
        return sortedResults;
    }

    protected Collection<?> executeSearch(Map<String, String> adjustedSearchCriteria, List<String> wildcardAsLiteralSearchCriteria, boolean bounded, Integer searchResultsLimit) {
        return this.getLookupService().findCollectionBySearchHelper(this.getDataObjectClass(), adjustedSearchCriteria, wildcardAsLiteralSearchCriteria, !bounded, searchResultsLimit);
    }

    protected Map<String, String> processSearchCriteria(LookupForm lookupForm, Map<String, String> searchCriteria) {
        Map<Object, Object> criteriaFields = new HashMap();
        if (lookupForm.getView() != null) {
            criteriaFields = this.getCriteriaFieldsForValidation((LookupView)lookupForm.getView(), lookupForm);
        }
        Map<String, String> filteredSearchCriteria = LookupUtils.preprocessDateFields(searchCriteria);
        for (String fieldName : searchCriteria.keySet()) {
            InputField inputField = (InputField)criteriaFields.get(fieldName);
            if (inputField == null || !(inputField instanceof LookupInputField)) continue;
            LookupInputField lookupInputField = (LookupInputField)inputField;
            String propertyName = lookupInputField.getPropertyName();
            ViewPostMetadata viewPostMetadata = lookupForm.getViewPostMetadata();
            if (viewPostMetadata == null) continue;
            Object componentPostData = viewPostMetadata.getComponentPostData(lookupForm.getViewId(), "filterableLookupCriteria");
            Map filterableLookupCriteria = (Map)componentPostData;
            if (filterableLookupCriteria != null && filterableLookupCriteria.containsKey(propertyName)) {
                FilterableLookupCriteriaControlPostData postData = (FilterableLookupCriteriaControlPostData)filterableLookupCriteria.get(propertyName);
                Class<? extends FilterableLookupCriteriaControl> controlClass = postData.getControlClass();
                FilterableLookupCriteriaControl control = KRADUtils.createNewObjectFromClass(controlClass);
                filteredSearchCriteria = control.filterSearchCriteria(propertyName, filteredSearchCriteria, postData);
            }
            if ((filteredSearchCriteria = lookupInputField.filterSearchCriteria(filteredSearchCriteria)) != null) continue;
            return null;
        }
        HashMap<String, String> processedSearchCriteria = new HashMap<String, String>();
        for (String fieldName : filteredSearchCriteria.keySet()) {
            String fieldValue = filteredSearchCriteria.get(fieldName);
            InputField inputField = (InputField)criteriaFields.get(fieldName);
            if (inputField != null && inputField.getControl() instanceof HiddenControl || StringUtils.isBlank((String)fieldValue)) continue;
            boolean isSecure = KRADUtils.isSecure(fieldName, this.dataObjectClass);
            if (StringUtils.endsWith((String)fieldValue, (String)"(&^#&)")) {
                fieldValue = StringUtils.removeEnd((String)fieldValue, (String)"(&^#&)");
                isSecure = true;
            }
            if (isSecure) {
                try {
                    if (CoreApiServiceLocator.getEncryptionService().isEnabled()) {
                        fieldValue = this.getEncryptionService().decrypt(fieldValue);
                    }
                }
                catch (GeneralSecurityException e) {
                    String message = "Data object class " + String.valueOf(this.dataObjectClass) + " property " + fieldName + " should have been encrypted, but there was a problem decrypting it.";
                    LOG.error(message);
                    throw new RuntimeException(message, e);
                }
            }
            processedSearchCriteria.put(fieldName, fieldValue);
        }
        return processedSearchCriteria;
    }

    protected List<String> identifyWildcardDisabledFields(LookupForm lookupForm, Map<String, String> searchCriteria) {
        ArrayList<String> wildcardAsLiteralPropertyNames = new ArrayList<String>();
        if (searchCriteria != null) {
            Map<Object, Object> criteriaFields = new HashMap();
            if (lookupForm.getView() != null) {
                criteriaFields = this.getCriteriaFieldsForValidation((LookupView)lookupForm.getView(), lookupForm);
            }
            for (String fieldName : searchCriteria.keySet()) {
                InputField inputField = (InputField)criteriaFields.get(fieldName);
                if (inputField == null || !(inputField instanceof LookupInputField) || !LookupInputField.class.isAssignableFrom(inputField.getClass()) || !((LookupInputField)inputField).isDisableWildcardsAndOperators()) continue;
                wildcardAsLiteralPropertyNames.add(fieldName);
            }
        }
        return wildcardAsLiteralPropertyNames;
    }

    protected boolean validateSearchParameters(LookupForm form, Map<String, String> searchCriteria) {
        boolean valid = true;
        if (searchCriteria == null) {
            return valid;
        }
        if (form.getViewPostMetadata() == null) {
            return valid;
        }
        HashSet<String> unprocessedSearchCriteria = new HashSet<String>(searchCriteria.keySet());
        for (Map.Entry<String, Map<String, Object>> lookupCriteria : form.getViewPostMetadata().getLookupCriteria().entrySet()) {
            ValidCharactersConstraint constraint;
            String propertyName = lookupCriteria.getKey();
            Map<String, Object> lookupCriteriaAttributes = lookupCriteria.getValue();
            unprocessedSearchCriteria.remove(propertyName);
            if (this.isCriteriaRequired(lookupCriteriaAttributes) && StringUtils.isBlank((String)searchCriteria.get(propertyName))) {
                GlobalVariables.getMessageMap().putError(propertyName, "error.required", new String[]{this.getCriteriaLabel(form, (String)lookupCriteriaAttributes.get("componentId"))});
            }
            if ((constraint = this.getSearchCriteriaConstraint(lookupCriteriaAttributes)) != null) {
                this.validateSearchParameterConstraint(form, propertyName, lookupCriteriaAttributes, searchCriteria.get(propertyName), constraint);
            }
            if (!searchCriteria.containsKey(propertyName)) continue;
            this.validateSearchParameterWildcardAndOperators(form, propertyName, lookupCriteriaAttributes, searchCriteria.get(propertyName));
        }
        for (String readOnlyItem : form.getReadOnlyFieldsList()) {
            unprocessedSearchCriteria.remove(readOnlyItem);
        }
        if (!unprocessedSearchCriteria.isEmpty()) {
            throw new RuntimeException("Invalid search value sent for property name(s): " + ((Object)unprocessedSearchCriteria).toString());
        }
        if (GlobalVariables.getMessageMap().hasErrors()) {
            valid = false;
        }
        return valid;
    }

    protected void validateSearchParameterWildcardAndOperators(LookupForm form, String propertyName, Map<String, Object> lookupCriteriaAttributes, String searchPropertyValue) {
        if (StringUtils.isBlank((String)searchPropertyValue)) {
            return;
        }
        boolean found = false;
        for (SearchOperator op : SearchOperator.QUERY_CHARACTERS) {
            String queryCharacter = op.op();
            if (!searchPropertyValue.contains(queryCharacter)) continue;
            found = true;
        }
        if (!found) {
            return;
        }
        if (this.isCriteriaWildcardDisabled(lookupCriteriaAttributes)) {
            Class<?> propertyType = ObjectPropertyUtils.getPropertyType(this.getDataObjectClass(), propertyName);
            if (TypeUtils.isIntegralClass(propertyType) || TypeUtils.isDecimalClass(propertyType) || TypeUtils.isTemporalClass(propertyType)) {
                GlobalVariables.getMessageMap().putError(propertyName, "error.wildcards.and.operators.not.allowed.on.field", new String[]{this.getCriteriaLabel(form, (String)lookupCriteriaAttributes.get("componentId"))});
            } else if (TypeUtils.isStringClass(propertyType)) {
                GlobalVariables.getMessageMap().putInfo(propertyName, "info.wildcards.and.operators.treated.literally", new String[]{this.getCriteriaLabel(form, (String)lookupCriteriaAttributes.get("componentId"))});
            }
        } else if (this.isCriteriaSecure(lookupCriteriaAttributes)) {
            GlobalVariables.getMessageMap().putError(propertyName, "error.secureField", new String[]{this.getCriteriaLabel(form, (String)lookupCriteriaAttributes.get("componentId"))});
        }
    }

    protected void validateSearchParameterConstraint(LookupForm form, String propertyName, Map<String, Object> lookupCriteriaAttributes, String searchPropertyValue, ValidCharactersConstraint validCharactersConstraint) {
        if (StringUtils.isBlank((String)searchPropertyValue)) {
            return;
        }
        Matcher matcher = Pattern.compile(validCharactersConstraint.getValue()).matcher(searchPropertyValue);
        if (!matcher.find()) {
            String[] prefixParams = new String[]{this.getCriteriaLabel(form, (String)lookupCriteriaAttributes.get("componentId"))};
            ErrorMessage errorMessage = new ErrorMessage(validCharactersConstraint.getMessageKey(), validCharactersConstraint.getValidationMessageParamsArray());
            errorMessage.setMessagePrefixKey("validation.propertyNamePrefix");
            errorMessage.setMessagePrefixParameters(prefixParams);
            GlobalVariables.getMessageMap().putError(propertyName, errorMessage);
        }
    }

    protected String getCriteriaLabel(LookupForm form, String componentId) {
        return (String)form.getViewPostMetadata().getComponentPostData(componentId, "label");
    }

    protected boolean isCriteriaWildcardDisabled(Map lookupCriteria) {
        return BooleanUtils.isTrue((Boolean)((Boolean)lookupCriteria.get("disableWildcardsAndOperators")));
    }

    protected boolean isCriteriaRequired(Map lookupCriteria) {
        return BooleanUtils.isTrue((Boolean)((Boolean)lookupCriteria.get("required")));
    }

    protected boolean isCriteriaSecure(Map lookupCriteria) {
        return BooleanUtils.isTrue((Boolean)((Boolean)lookupCriteria.get("secureValue")));
    }

    protected ValidCharactersConstraint getSearchCriteriaConstraint(Map lookupCriteria) {
        return (ValidCharactersConstraint)lookupCriteria.get("validCharactersConstraint");
    }

    protected void generateLookupResultsMessages(Map<String, String> searchCriteria, Collection<?> searchResults, boolean bounded, Integer searchResultsLimit) {
        MessageMap messageMap = GlobalVariables.getMessageMap();
        Long searchResultsSize = 0L;
        if (searchResults instanceof CollectionIncomplete && ((CollectionIncomplete)searchResults).getActualSizeIfTruncated() > 0L) {
            searchResultsSize = ((CollectionIncomplete)searchResults).getActualSizeIfTruncated();
        } else if (searchResults != null) {
            searchResultsSize = searchResults.size();
        }
        if (searchResultsSize == 0L) {
            messageMap.putInfoForSectionId("LookupResultMessages", "lookup.results.none.found", new String[0]);
        } else if (searchResultsSize == 1L) {
            messageMap.putInfoForSectionId("LookupResultMessages", "lookup.results.found.display.one", new String[0]);
        } else if (searchResultsSize > 1L) {
            boolean resultsExceedsLimit;
            boolean bl = resultsExceedsLimit = bounded && searchResultsLimit != null && searchResultsSize > (long)searchResultsLimit.intValue();
            if (resultsExceedsLimit) {
                messageMap.putInfoForSectionId("LookupResultMessages", "lookup.results.exceeds.limit", new String[]{searchResultsSize.toString(), searchResultsLimit.toString()});
            }
        }
        Boolean usingPrimaryKey = this.getLookupService().allPrimaryKeyValuesPresentAndNotWildcard(this.getDataObjectClass(), searchCriteria);
        if (usingPrimaryKey.booleanValue()) {
            List pkNames = this.getLegacyDataAdapter().listPrimaryKeyFieldNames(this.getDataObjectClass());
            ArrayList<String> pkLabels = new ArrayList<String>();
            for (String pkName : pkNames) {
                pkLabels.add(this.getDataDictionaryService().getAttributeLabel(this.getDataObjectClass(), pkName));
            }
            messageMap.putInfoForSectionId("LookupResultMessages", "lookup.using.primary.keys", new String[]{StringUtils.join(pkLabels, (String)",")});
        }
    }

    protected void sortSearchResults(LookupForm form, List<?> searchResults) {
        List<String> defaultSortColumns = null;
        boolean defaultSortAscending = true;
        if (form.getView() != null) {
            defaultSortColumns = ((LookupView)form.getView()).getDefaultSortAttributeNames();
            defaultSortAscending = ((LookupView)form.getView()).isDefaultSortAscending();
        }
        boolean hasExpression = false;
        if (defaultSortColumns != null) {
            for (String sortColumn : defaultSortColumns) {
                if (sortColumn != null) continue;
                hasExpression = true;
            }
        }
        if (hasExpression) {
            defaultSortColumns = null;
        }
        if (defaultSortColumns != null && !defaultSortColumns.isEmpty()) {
            BeanPropertyComparator comparator = new BeanPropertyComparator(defaultSortColumns, true);
            if (defaultSortAscending) {
                Collections.sort(searchResults, comparator);
            } else {
                Collections.sort(searchResults, Collections.reverseOrder(comparator));
            }
        }
    }

    protected Collection<?> getSearchResults(Map<String, String> searchCriteria, List<String> wildcardAsLiteralSearchCriteria, boolean unbounded, Integer searchResultsLimit) {
        try {
            if (LookupUtils.hasExternalBusinessObjectProperty(this.getDataObjectClass(), searchCriteria)) {
                searchCriteria = LookupUtils.adjustCriteriaForNestedEBOs(this.getDataObjectClass(), searchCriteria, unbounded);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Passing these results into the lookup service: " + String.valueOf(searchCriteria));
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error trying to check for nested external business objects", e);
        }
        catch (InstantiationException e1) {
            throw new RuntimeException("Error trying to check for nested external business objects", e1);
        }
        return this.executeSearch(searchCriteria, wildcardAsLiteralSearchCriteria, !unbounded, searchResultsLimit);
    }

    protected List<?> getSearchResultsForEBO(Map<String, String> searchCriteria, boolean unbounded) {
        ModuleService eboModuleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(this.getDataObjectClass());
        BusinessObjectEntry ddEntry = eboModuleService.getExternalizableBusinessObjectDictionaryEntry(this.getDataObjectClass());
        HashMap<String, String> filteredFieldValues = new HashMap<String, String>();
        for (String fieldName : searchCriteria.keySet()) {
            if (!ddEntry.getAttributeNames().contains(fieldName)) continue;
            filteredFieldValues.put(fieldName, searchCriteria.get(fieldName));
        }
        Map<String, Object> translatedValues = KRADUtils.coerceRequestParameterTypes(this.getDataObjectClass(), filteredFieldValues);
        List<?> searchResults = eboModuleService.getExternalizableBusinessObjectsListForLookup(this.getDataObjectClass(), translatedValues, unbounded);
        return searchResults;
    }

    @Override
    public Map<String, String> performClear(LookupForm form, Map<String, String> lookupCriteria) {
        HashMap<String, String> clearedLookupCriteria = new HashMap<String, String>();
        Map<Object, Object> criteriaFieldMap = new HashMap();
        if (form.getView() != null) {
            criteriaFieldMap = this.getCriteriaFieldsForValidation((LookupView)form.getView(), form);
        }
        List<String> readOnlyFieldsList = form.getReadOnlyFieldsList();
        for (Map.Entry<String, String> searchKeyValue : lookupCriteria.entrySet()) {
            String searchPropertyName = searchKeyValue.getKey();
            String searchPropertyValue = searchKeyValue.getValue();
            InputField inputField = (InputField)criteriaFieldMap.get(searchPropertyName);
            if (readOnlyFieldsList == null || !readOnlyFieldsList.contains(searchPropertyName)) {
                searchPropertyValue = inputField != null && inputField.getDefaultValue() != null ? inputField.getDefaultValue().toString() : "";
            }
            clearedLookupCriteria.put(searchPropertyName, searchPropertyValue);
        }
        return clearedLookupCriteria;
    }

    @Override
    public void buildReturnUrlForResult(Link returnLink, Object model) {
        Object dataObject;
        LookupForm lookupForm = (LookupForm)model;
        Map<String, Object> returnLinkContext = returnLink.getContext();
        LookupView lookupView = returnLinkContext == null ? null : (LookupView)returnLinkContext.get("view");
        Object object = dataObject = returnLinkContext == null ? null : returnLinkContext.get("line");
        if (dataObject == null || !this.isResultReturnable(dataObject)) {
            returnLink.setRender(false);
            return;
        }
        String dataReturnValue = "true";
        if (lookupForm.isReturnByScript()) {
            Map<String, String> translatedKeyValues = this.getTranslatedReturnKeyValues(lookupView, lookupForm, dataObject);
            dataReturnValue = ScriptUtils.translateValue(translatedKeyValues);
            returnLink.setHref("#");
            String dialogId = lookupForm.getShowDialogId();
            if (StringUtils.isNotBlank((String)dialogId)) {
                returnLink.setHref(returnLink.getHref() + dialogId);
            }
        } else if (StringUtils.isBlank((String)returnLink.getHref())) {
            String href = this.getReturnUrl(lookupView, lookupForm, dataObject);
            if (!StringUtils.isNotBlank((String)href)) {
                returnLink.setRender(false);
                return;
            }
            returnLink.setHref(href);
            String target = lookupForm.getReturnTarget();
            if (StringUtils.isNotBlank((String)target)) {
                returnLink.setTarget(target);
            }
        }
        returnLink.addDataAttribute("return", dataReturnValue);
        if (StringUtils.isBlank((String)returnLink.getTitle())) {
            String linkLabel = StringUtils.defaultIfBlank((String)this.getConfigurationService().getPropertyValueAsString("title.return.url.value.prependtext"), (String)"");
            Map<String, String> returnKeyValues = this.getReturnKeyValues(lookupView, lookupForm, dataObject);
            String title = KRADUtils.buildAttributeTitleString(linkLabel, this.getDataObjectClass(), returnKeyValues);
            returnLink.setTitle(title);
        }
    }

    protected boolean isResultReturnable(Object dataObject) {
        return true;
    }

    protected String getReturnUrl(LookupView lookupView, LookupForm lookupForm, Object dataObject) {
        Properties props = this.getReturnUrlParameters(lookupView, lookupForm, dataObject);
        String href = "";
        if (StringUtils.isNotBlank((String)lookupForm.getReturnLocation())) {
            href = UrlFactory.parameterizeUrl((String)lookupForm.getReturnLocation(), (Properties)props);
        }
        return href;
    }

    protected Properties getReturnUrlParameters(LookupView lookupView, LookupForm lookupForm, Object dataObject) {
        String dialogId;
        Properties props = new Properties();
        props.put("methodToCall", "refresh");
        if (StringUtils.isNotBlank((String)lookupForm.getReturnFormKey())) {
            props.put("formKey", lookupForm.getReturnFormKey());
        }
        props.put("refreshCaller", lookupView.getId());
        props.put("refreshDataObjectClass", this.getDataObjectClass().getName());
        if (StringUtils.isNotBlank((String)lookupForm.getReferencesToRefresh())) {
            props.put("referencesToRefresh", lookupForm.getReferencesToRefresh());
        }
        String selectedCollectionId = null;
        String selectedCollectionPath = null;
        String selectedLineIndex = null;
        if (lookupForm.getInitialRequestParameters() != null) {
            String[] lines;
            String[] paths;
            String[] ids = lookupForm.getInitialRequestParameters().get("selectedCollectionId");
            if (ids != null && ids.length > 0) {
                selectedCollectionId = ids[0];
            }
            if ((paths = lookupForm.getInitialRequestParameters().get("selectedCollectionPath")) != null && paths.length > 0) {
                selectedCollectionPath = paths[0];
            }
            if ((lines = lookupForm.getInitialRequestParameters().get("selectedLineIndex")) != null && lines.length > 0) {
                selectedLineIndex = lines[0];
            }
        }
        if (StringUtils.isNotBlank(selectedLineIndex)) {
            props.put("actionParameters[selectedLineIndex]", selectedLineIndex);
        }
        if (StringUtils.isNotBlank(selectedCollectionId)) {
            props.put("actionParameters[selectedCollectionId]", selectedCollectionId);
        }
        if (StringUtils.isNotBlank(selectedCollectionPath)) {
            props.put("actionParameters[selectedCollectionPath]", selectedCollectionPath);
        }
        if (StringUtils.isNotBlank((String)(dialogId = lookupForm.getShowDialogId()))) {
            props.put("actionParameters[dialogId]", dialogId);
        }
        if (StringUtils.isNotBlank((String)lookupForm.getQuickfinderId())) {
            props.put("quickfinderId", lookupForm.getQuickfinderId());
        }
        Map<String, String> returnKeyValues = this.getTranslatedReturnKeyValues(lookupView, lookupForm, dataObject);
        props.putAll(returnKeyValues);
        return props;
    }

    protected Map<String, String> getTranslatedReturnKeyValues(LookupView lookupView, LookupForm lookupForm, Object dataObject) {
        HashMap<String, String> translatedKeyValues = new HashMap<String, String>();
        Map<String, String> returnKeyValues = this.getReturnKeyValues(lookupView, lookupForm, dataObject);
        for (String returnKey : returnKeyValues.keySet()) {
            String returnValue = returnKeyValues.get(returnKey);
            if (lookupForm.getFieldConversions().containsKey(returnKey)) {
                returnKey = lookupForm.getFieldConversions().get(returnKey);
            }
            translatedKeyValues.put(returnKey, returnValue);
        }
        return translatedKeyValues;
    }

    protected Map<String, String> getReturnKeyValues(LookupView lookupView, LookupForm lookupForm, Object dataObject) {
        ArrayList<String> returnKeys = lookupForm.getFieldConversions() != null && !lookupForm.getFieldConversions().isEmpty() ? new ArrayList<String>(lookupForm.getFieldConversions().keySet()) : this.getLegacyDataAdapter().listPrimaryKeyFieldNames(this.getDataObjectClass());
        List<String> secureReturnKeys = lookupView.getAdditionalSecurePropertyNames();
        return KRADUtils.getPropertyKeyValuesFromDataObject(returnKeys, secureReturnKeys, dataObject);
    }

    @Override
    public void buildMaintenanceActionLink(Link actionLink, Object model, String maintenanceMethodToCall) {
        LookupForm lookupForm = (LookupForm)model;
        Map<String, Object> actionLinkContext = actionLink.getContext();
        Object dataObject = actionLinkContext == null ? null : actionLinkContext.get("line");
        List pkNames = this.getLegacyDataAdapter().listPrimaryKeyFieldNames(this.getDataObjectClass());
        if (StringUtils.isBlank((String)actionLink.getHref())) {
            String href = this.getMaintenanceActionUrl(lookupForm, dataObject, maintenanceMethodToCall, pkNames);
            if (StringUtils.isBlank((String)href)) {
                actionLink.setRender(false);
                return;
            }
            actionLink.setHref(href);
        }
        if (StringUtils.isBlank((String)actionLink.getTitle())) {
            DataObjectEntry dataObjectEntry;
            String dataObjectLabel;
            ArrayList<String> linkLabels = new ArrayList<String>();
            String linkText = actionLink.getLinkText();
            if (StringUtils.isNotBlank((String)linkText)) {
                linkLabels.add(linkText);
            }
            String string = dataObjectLabel = (dataObjectEntry = this.getDataDictionaryService().getDataDictionary().getDataObjectEntry(this.getDataObjectClass().getName())) != null ? dataObjectEntry.getObjectLabel() : null;
            if (StringUtils.isNotBlank((String)dataObjectLabel)) {
                linkLabels.add(dataObjectLabel);
            }
            String titleActionUrlPrependText = this.getConfigurationService().getPropertyValueAsString("title.action.url.value.prependtext");
            Map<String, String> primaryKeyValues = KRADUtils.getPropertyKeyValuesFromDataObject(pkNames, dataObject);
            if (StringUtils.isNotBlank((String)titleActionUrlPrependText) && !primaryKeyValues.isEmpty()) {
                linkLabels.add(titleActionUrlPrependText);
            }
            String linkLabel = StringUtils.defaultIfBlank((String)StringUtils.join(linkLabels, (String)" "), (String)"");
            String title = KRADUtils.buildAttributeTitleString(linkLabel, this.getDataObjectClass(), primaryKeyValues);
            actionLink.setTitle(title);
        }
    }

    protected String getMaintenanceActionUrl(LookupForm lookupForm, Object dataObject, String methodToCall, List<String> pkNames) {
        LookupView lookupView = (LookupView)lookupForm.getView();
        Properties props = new Properties();
        props.put("methodToCall", methodToCall);
        Map<String, String> primaryKeyValues = KRADUtils.getPropertyKeyValuesFromDataObject(pkNames, dataObject);
        for (String primaryKey : primaryKeyValues.keySet()) {
            String primaryKeyValue = primaryKeyValues.get(primaryKey);
            props.put(primaryKey, primaryKeyValue);
        }
        if (StringUtils.isNotBlank((String)lookupForm.getReturnLocation())) {
            props.put("returnLocation", lookupForm.getReturnLocation());
        }
        props.put("dataObjectClassName", lookupForm.getDataObjectClassName());
        props.put("viewTypeName", UifConstants.ViewType.MAINTENANCE.name());
        String maintenanceMapping = "maintenance";
        if (lookupView != null && StringUtils.isNotBlank((String)lookupView.getMaintenanceUrlMapping())) {
            maintenanceMapping = lookupView.getMaintenanceUrlMapping();
        }
        return UrlFactory.parameterizeUrl((String)maintenanceMapping, (Properties)props);
    }

    @Override
    public void buildMultiValueSelectField(InputField selectField, Object model) {
        Object lineDataObject;
        LookupForm lookupForm = (LookupForm)model;
        Map<String, Object> selectFieldContext = selectField.getContext();
        Object object = lineDataObject = selectFieldContext == null ? null : selectFieldContext.get("line");
        if (lineDataObject == null) {
            throw new RuntimeException("Unable to get data object for line from component: " + selectField.getId());
        }
        Control selectControl = selectField.getControl();
        if (selectControl != null && selectControl instanceof ValueConfiguredControl) {
            ArrayList<String> fromFieldNames = new ArrayList<String>(lookupForm.getFieldConversions().keySet());
            fromFieldNames = new ArrayList<String>(KRADUtils.getPropertyKeyValuesFromDataObject(fromFieldNames, lineDataObject).keySet());
            Collections.sort(fromFieldNames);
            lookupForm.setMultiValueReturnFields(fromFieldNames);
            Object lineIdentifier = "";
            for (String fromFieldName : fromFieldNames) {
                Object fromFieldValue = ObjectPropertyUtils.getPropertyValue(lineDataObject, fromFieldName);
                if (fromFieldValue != null) {
                    lineIdentifier = (String)lineIdentifier + String.valueOf(fromFieldValue);
                }
                lineIdentifier = (String)lineIdentifier + ":";
            }
            lineIdentifier = StringUtils.removeEnd((String)lineIdentifier, (String)":");
            ((ValueConfiguredControl)((Object)selectControl)).setValue((String)lineIdentifier);
        }
    }

    @Override
    public boolean allowsMaintenanceNewOrCopyAction() {
        boolean allowsNewOrCopy = false;
        String maintDocTypeName = this.getMaintenanceDocumentTypeName();
        if (StringUtils.isNotBlank((String)maintDocTypeName)) {
            allowsNewOrCopy = this.getDataObjectAuthorizationService().canCreate(this.getDataObjectClass(), GlobalVariables.getUserSession().getPerson(), maintDocTypeName);
        }
        return allowsNewOrCopy;
    }

    @Override
    public boolean allowsMaintenanceEditAction(Object dataObject) {
        boolean allowsEdit = false;
        String maintDocTypeName = this.getMaintenanceDocumentTypeName();
        if (StringUtils.isNotBlank((String)maintDocTypeName)) {
            allowsEdit = this.getDataObjectAuthorizationService().canMaintain(dataObject, GlobalVariables.getUserSession().getPerson(), maintDocTypeName);
        }
        return allowsEdit;
    }

    @Override
    public boolean allowsMaintenanceDeleteAction(Object dataObject) {
        boolean allowsDelete;
        boolean allowsMaintain = false;
        String maintDocTypeName = this.getMaintenanceDocumentTypeName();
        if (StringUtils.isNotBlank((String)maintDocTypeName)) {
            allowsMaintain = this.getDataObjectAuthorizationService().canMaintain(dataObject, GlobalVariables.getUserSession().getPerson(), maintDocTypeName);
        }
        return (allowsDelete = this.getDocumentDictionaryService().getAllowsRecordDeletion(this.getDataObjectClass()).booleanValue()) && allowsMaintain;
    }

    protected String getMaintenanceDocumentTypeName() {
        DocumentDictionaryService dd = this.getDocumentDictionaryService();
        return dd.getMaintenanceDocumentTypeName(this.getDataObjectClass());
    }

    protected Map<String, InputField> getCriteriaFieldsForValidation(LookupView lookupView, LookupForm form) {
        HashMap<String, InputField> criteriaFieldMap = new HashMap<String, InputField>();
        if (lookupView.getCriteriaFields() == null) {
            return criteriaFieldMap;
        }
        List<InputField> fields = null;
        fields = lookupView.getCriteriaGroup().getItems().size() > 0 ? ComponentUtils.getNestedContainerComponents(lookupView.getCriteriaGroup(), InputField.class) : (lookupView.getCriteriaFields().size() > 0 ? ComponentUtils.getComponentsOfType(lookupView.getCriteriaFields(), InputField.class) : new ArrayList<InputField>());
        for (InputField field : fields) {
            criteriaFieldMap.put(field.getPropertyName(), field);
        }
        return criteriaFieldMap;
    }

    @Override
    public Class<?> getDataObjectClass() {
        return this.dataObjectClass;
    }

    @Override
    public void setDataObjectClass(Class<?> dataObjectClass) {
        this.dataObjectClass = dataObjectClass;
    }

    protected DataObjectAuthorizationService getDataObjectAuthorizationService() {
        if (this.dataObjectAuthorizationService == null) {
            this.dataObjectAuthorizationService = KRADServiceLocatorWeb.getDataObjectAuthorizationService();
        }
        return this.dataObjectAuthorizationService;
    }

    public void setDataObjectAuthorizationService(DataObjectAuthorizationService dataObjectAuthorizationService) {
        this.dataObjectAuthorizationService = dataObjectAuthorizationService;
    }

    public DocumentDictionaryService getDocumentDictionaryService() {
        if (this.documentDictionaryService == null) {
            this.documentDictionaryService = KRADServiceLocatorWeb.getDocumentDictionaryService();
        }
        return this.documentDictionaryService;
    }

    public void setDocumentDictionaryService(DocumentDictionaryService documentDictionaryService) {
        this.documentDictionaryService = documentDictionaryService;
    }

    protected LookupService getLookupService() {
        if (this.lookupService == null) {
            this.lookupService = KRADServiceLocatorWeb.getLookupService();
        }
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    protected EncryptionService getEncryptionService() {
        if (this.encryptionService == null) {
            this.encryptionService = CoreApiServiceLocator.getEncryptionService();
        }
        return this.encryptionService;
    }

    public void setEncryptionService(EncryptionService encryptionService) {
        this.encryptionService = encryptionService;
    }
}

