/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.kuali.rice.krad.datadictionary.Copyable;
import org.kuali.rice.krad.uif.util.CopyUtils;
import org.kuali.rice.krad.uif.util.ProcessLogger;

public class DelayedCopyableHandler
implements InvocationHandler {
    private static final String COPY = "copy";
    private final Copyable original;
    private Copyable copy;
    private static final Map<Class<?>, ClassMetadata> CLASS_META_CACHE = Collections.synchronizedMap(new WeakHashMap());

    DelayedCopyableHandler(Copyable original) {
        this.original = original;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        boolean atomic;
        String methodName = method.getName();
        Class<?> returnType = method.getReturnType();
        boolean bl = atomic = this.copy == null && (COPY.equals(methodName) || (methodName.startsWith("get") || methodName.startsWith("is")) && !Copyable.class.isAssignableFrom(returnType) && !List.class.isAssignableFrom(returnType) && !Map.class.isAssignableFrom(returnType) && !returnType.isArray());
        ProcessLogger.ntrace("delay-" + (this.copy != null ? "dup" : (atomic ? "atomic" : COPY)) + ":", ":" + methodName + ":" + this.original.getClass().getSimpleName(), 1000L);
        if (this.copy == null && !atomic) {
            this.copy = (Copyable)CopyUtils.copy(this.original);
        }
        try {
            return method.invoke((Object)(this.copy == null ? this.original : this.copy), args);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null) {
                throw e.getCause();
            }
            throw e;
        }
    }

    static <T> T unwrap(T source) {
        if (!(source instanceof Copyable)) {
            return source;
        }
        Class<?> sourceClass = source.getClass();
        if (!Proxy.isProxyClass(sourceClass)) {
            return source;
        }
        InvocationHandler handler = Proxy.getInvocationHandler(source);
        if (!(handler instanceof DelayedCopyableHandler)) {
            return source;
        }
        DelayedCopyableHandler sourceHandler = (DelayedCopyableHandler)handler;
        if (sourceHandler.copy == null) {
            sourceHandler.copy = (Copyable)CopyUtils.copy(sourceHandler.original);
        }
        Copyable rv = sourceHandler.copy;
        return (T)DelayedCopyableHandler.unwrap(rv);
    }

    public static boolean isPendingDelayedCopy(Copyable source) {
        InvocationHandler handler;
        Class<?> sourceClass = source.getClass();
        if (Proxy.isProxyClass(sourceClass) && (handler = Proxy.getInvocationHandler(source)) instanceof DelayedCopyableHandler) {
            DelayedCopyableHandler sourceHandler = (DelayedCopyableHandler)handler;
            return sourceHandler.copy == null;
        }
        return false;
    }

    public static Copyable getDelayedCopy(Copyable source) {
        InvocationHandler handler;
        Class<?> sourceClass = source.getClass();
        if (Proxy.isProxyClass(sourceClass) && (handler = Proxy.getInvocationHandler(source)) instanceof DelayedCopyableHandler) {
            DelayedCopyableHandler sourceHandler = (DelayedCopyableHandler)handler;
            return DelayedCopyableHandler.getDelayedCopy(sourceHandler.copy == null ? sourceHandler.original : sourceHandler.copy);
        }
        return (Copyable)Proxy.newProxyInstance(sourceClass.getClassLoader(), DelayedCopyableHandler.getMetadata(sourceClass).interfaces, (InvocationHandler)new DelayedCopyableHandler(source));
    }

    private static final ClassMetadata getMetadata(Class<?> targetClass) {
        ClassMetadata metadata = CLASS_META_CACHE.get(targetClass);
        if (metadata == null) {
            metadata = new ClassMetadata(targetClass);
            CLASS_META_CACHE.put(targetClass, metadata);
        }
        return metadata;
    }

    private static class ClassMetadata {
        private final Class<?>[] interfaces;

        private ClassMetadata(Class<?> targetClass) {
            ArrayList interfaceList = new ArrayList();
            for (Class<?> currentClass = targetClass; currentClass != Object.class && currentClass != null; currentClass = currentClass.getSuperclass()) {
                for (Class<?> ifc : currentClass.getInterfaces()) {
                    if (interfaceList.contains(ifc)) continue;
                    interfaceList.add(ifc);
                }
            }
            this.interfaces = interfaceList.toArray(new Class[interfaceList.size()]);
        }
    }
}

