/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.shared.composites;

import java.time.Duration;
import java.util.Map;
import java.util.function.Supplier;
import org.ehcache.expiry.ExpiryPolicy;
import org.ehcache.impl.internal.store.shared.composites.CompositeValue;

public class CompositeExpiryPolicy
implements ExpiryPolicy<CompositeValue<?>, CompositeValue<?>> {
    private final Map<Integer, ExpiryPolicy<?, ?>> expiryPolicyMap;

    public CompositeExpiryPolicy(Map<Integer, ExpiryPolicy<?, ?>> expiryPolicyMap) {
        this.expiryPolicyMap = expiryPolicyMap;
    }

    private ExpiryPolicy<?, ?> getPolicy(int id) {
        return this.expiryPolicyMap.get(id);
    }

    public Duration getExpiryForCreation(CompositeValue<?> key, CompositeValue<?> value) {
        ExpiryPolicy<?, ?> expiryPolicy = this.getPolicy(key.getStoreId());
        if (expiryPolicy == null) {
            return Duration.ZERO;
        }
        return expiryPolicy.getExpiryForCreation(key.getValue(), value.getValue());
    }

    public Duration getExpiryForAccess(CompositeValue<?> key, Supplier<? extends CompositeValue<?>> value) {
        ExpiryPolicy<?, ?> expiryPolicy = this.getPolicy(key.getStoreId());
        if (expiryPolicy == null) {
            return Duration.ZERO;
        }
        return expiryPolicy.getExpiryForAccess(key.getValue(), () -> ((CompositeValue)value.get()).getValue());
    }

    public Duration getExpiryForUpdate(CompositeValue<?> key, Supplier<? extends CompositeValue<?>> oldValue, CompositeValue<?> newValue) {
        ExpiryPolicy<?, ?> expiryPolicy = this.getPolicy(key.getStoreId());
        if (expiryPolicy == null) {
            return Duration.ZERO;
        }
        return expiryPolicy.getExpiryForUpdate(key.getValue(), () -> ((CompositeValue)oldValue.get()).getValue(), newValue.getValue());
    }
}

