/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.impl.datetime;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.springframework.beans.factory.InitializingBean;

public class DateTimeServiceImpl
implements DateTimeService,
InitializingBean {
    protected String[] stringToDateFormats;
    protected String[] stringToTimeFormats;
    protected String[] stringToTimestampFormats;
    protected String dateToStringFormatForUserInterface;
    protected String timeToStringFormatForUserInterface;
    protected String timestampToStringFormatForUserInterface;
    protected String dateToStringFormatForFileName;
    protected String timestampToStringFormatForFileName;

    public String toDateString(java.util.Date date) {
        return this.toString(date, this.dateToStringFormatForUserInterface);
    }

    public String toTimeString(Time time) {
        return this.toString(time, this.timeToStringFormatForUserInterface);
    }

    public String toDateTimeString(java.util.Date date) {
        return this.toString(date, this.timestampToStringFormatForUserInterface);
    }

    public String toString(java.util.Date date, String pattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        dateFormat.setLenient(false);
        return dateFormat.format(date);
    }

    public java.util.Date getCurrentDate() {
        Calendar c = Calendar.getInstance();
        c.setTime(new java.util.Date());
        return c.getTime();
    }

    public Timestamp getCurrentTimestamp() {
        return new Timestamp(this.getCurrentDate().getTime());
    }

    public Date getCurrentSqlDate() {
        return new Date(this.getCurrentDate().getTime());
    }

    public Date getCurrentSqlDateMidnight() {
        return Date.valueOf(this.getCurrentSqlDate().toString());
    }

    public Calendar getCurrentCalendar() {
        return this.getCalendar(this.getCurrentDate());
    }

    public Calendar getCalendar(java.util.Date date) {
        if (date == null) {
            throw new IllegalArgumentException("invalid (null) date");
        }
        Calendar currentCalendar = Calendar.getInstance();
        currentCalendar.setTime(date);
        return currentCalendar;
    }

    public java.util.Date convertToDate(String dateString) throws ParseException {
        return this.parseAgainstFormatArray(dateString, this.stringToDateFormats);
    }

    public java.util.Date convertToDateTime(String dateTimeString) throws ParseException {
        if (StringUtils.isBlank((String)dateTimeString)) {
            throw new IllegalArgumentException("invalid (blank) date/time string");
        }
        return this.parseAgainstFormatArray(dateTimeString, this.stringToTimestampFormats);
    }

    public Timestamp convertToSqlTimestamp(String timeString) throws ParseException {
        if (!StringUtils.isBlank((String)timeString)) {
            return new Timestamp(this.convertToDateTime(timeString).getTime());
        }
        return null;
    }

    public Date convertToSqlDate(String dateString) throws ParseException {
        if (StringUtils.isBlank((String)dateString)) {
            throw new IllegalArgumentException("invalid (blank) dateString");
        }
        java.util.Date date = this.parseAgainstFormatArray(dateString, this.stringToDateFormats);
        return new Date(date.getTime());
    }

    public Date convertToSqlDateUpperBound(String dateString) throws ParseException {
        Date date = this.convertToSqlDate(dateString);
        DateTime dateUpperBound = new DateTime((Object)date).plusDays(1);
        return new Date(dateUpperBound.getMillis());
    }

    public Time convertToSqlTime(String timeString) throws ParseException {
        if (StringUtils.isBlank((String)timeString)) {
            throw new IllegalArgumentException("invalid (blank) dateString");
        }
        java.util.Date date = this.parseAgainstFormatArray(timeString, this.stringToTimeFormats);
        return new Time(date.getTime());
    }

    protected java.util.Date parseAgainstFormatArray(String dateString, String[] formats) throws ParseException {
        dateString = dateString.trim();
        StringBuffer exceptionMessage = new StringBuffer("Date or date/time string '").append(dateString).append("' could not be converted using any of the accepted formats: ");
        for (String dateFormatString : formats) {
            try {
                return this.parse(dateString, dateFormatString);
            }
            catch (ParseException e) {
                exceptionMessage.append(dateFormatString).append(" (error offset=").append(e.getErrorOffset()).append("),");
            }
        }
        throw new ParseException(exceptionMessage.toString().substring(0, exceptionMessage.length() - 1), 0);
    }

    public Date convertToSqlDate(Timestamp timestamp) throws ParseException {
        return new Date(timestamp.getTime());
    }

    public int dateDiff(java.util.Date startDate, java.util.Date endDate, boolean inclusive) {
        Calendar startDateCalendar = Calendar.getInstance();
        startDateCalendar.setTime(startDate);
        Calendar endDateCalendar = Calendar.getInstance();
        endDateCalendar.setTime(endDate);
        LocalDate startLocal = LocalDate.of(startDateCalendar.get(1), 1 + startDateCalendar.get(2), startDateCalendar.get(5));
        LocalDate endLocal = LocalDate.of(endDateCalendar.get(1), 1 + endDateCalendar.get(2), endDateCalendar.get(5));
        return (int)ChronoUnit.DAYS.between(startLocal, endLocal) + (inclusive ? 1 : 0);
    }

    protected java.util.Date parse(String dateString, String pattern) throws ParseException {
        if (!StringUtils.isBlank((String)dateString)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
            dateFormat.setLenient(false);
            ParsePosition parsePosition = new ParsePosition(0);
            java.util.Date testDate = ((DateFormat)dateFormat).parse(dateString, parsePosition);
            if (testDate == null) {
                throw new ParseException("The date that you provided is invalid.", parsePosition.getErrorIndex());
            }
            if (parsePosition.getIndex() != dateString.length()) {
                throw new ParseException("The date that you provided is invalid.", parsePosition.getIndex());
            }
            Calendar testCalendar = Calendar.getInstance();
            testCalendar.setLenient(false);
            testCalendar.setTime(testDate);
            if (testCalendar.get(1) < 1000 || testCalendar.get(1) > 9999) {
                throw new ParseException("The date that you provided is not between the years 1000 and 9999.", -1);
            }
            if (testCalendar.get(1) == 1970 && !pattern.contains("y".toLowerCase())) {
                Calendar curCalendar = Calendar.getInstance();
                curCalendar.setTime(new java.util.Date());
                testCalendar.set(1, curCalendar.get(1));
                testDate = testCalendar.getTime();
            }
            return testDate;
        }
        return null;
    }

    public String toDateStringForFilename(java.util.Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.dateToStringFormatForFileName);
        return dateFormat.format(date);
    }

    public String toDateTimeStringForFilename(java.util.Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.timestampToStringFormatForFileName);
        return dateFormat.format(date);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.stringToDateFormats == null) {
            this.stringToDateFormats = this.loadAndValidateFormats("STRING_TO_DATE_FORMATS", "MM/dd/yyyy hh:mm a;MM/dd/yy;MM/dd/yyyy;MM-dd-yy;MM-dd-yyyy;MMddyy;MMMM dd;yyyy;MM/dd/yy HH:mm:ss;MM/dd/yyyy HH:mm:ss;MM-dd-yy HH:mm:ss;MMddyy HH:mm:ss;MMMM dd HH:mm:ss;yyyy HH:mm:ss");
        }
        if (this.stringToTimeFormats == null) {
            this.stringToTimeFormats = this.loadAndValidateFormats("STRING_TO_TIME_FORMATS", "hh:mm aa");
        }
        if (this.stringToTimestampFormats == null) {
            this.stringToTimestampFormats = this.loadAndValidateFormats("STRING_TO_TIMESTAMP_FORMATS", "MM/dd/yyyy hh:mm a;MM/dd/yy;MM/dd/yyyy;MM-dd-yy;MMddyy;MMMM dd;yyyy;MM/dd/yy HH:mm:ss;MM/dd/yyyy HH:mm:ss;MM-dd-yy HH:mm:ss;MMddyy HH:mm:ss;MMMM dd HH:mm:ss;yyyy HH:mm:ss");
        }
        if (this.dateToStringFormatForUserInterface == null) {
            this.dateToStringFormatForUserInterface = this.loadAndValidateFormat("DATE_TO_STRING_FORMAT_FOR_USER_INTERFACE", "MM/dd/yyyy");
        }
        if (this.timeToStringFormatForUserInterface == null) {
            this.timeToStringFormatForUserInterface = this.loadAndValidateFormat("TIME_TO_STRING_FORMAT_FOR_USER_INTERFACE", "hh:mm aa");
        }
        if (this.timestampToStringFormatForUserInterface == null) {
            this.timestampToStringFormatForUserInterface = this.loadAndValidateFormat("TIMESTAMP_TO_STRING_FORMAT_FOR_USER_INTERFACE", "MM/dd/yyyy hh:mm a");
        }
        if (this.dateToStringFormatForFileName == null) {
            this.dateToStringFormatForFileName = this.loadAndValidateFormat("DATE_TO_STRING_FORMAT_FOR_FILE_NAME", "yyyyMMdd");
        }
        if (this.timestampToStringFormatForFileName == null) {
            this.timestampToStringFormatForFileName = this.loadAndValidateFormat("TIMESTAMP_TO_STRING_FORMAT_FOR_FILE_NAME", "yyyyMMdd-HH-mm-ss-S");
        }
    }

    private List<String> parseConfigValues(String configValue) {
        if (configValue == null || "".equals(configValue)) {
            return Collections.emptyList();
        }
        return Arrays.asList(configValue.split(";"));
    }

    private List<String> loadFormats(String property, String deflt) {
        return this.parseConfigValues(this.loadFormat(property, deflt));
    }

    private String[] loadAndValidateFormats(String property, String deflt) {
        List<String> dateFormatParams = this.loadFormats(property, deflt);
        String[] validFormats = new String[dateFormatParams.size()];
        for (int i = 0; i < dateFormatParams.size(); ++i) {
            String dateFormatParam = dateFormatParams.get(i);
            if (StringUtils.isBlank((String)dateFormatParam)) {
                throw new IllegalArgumentException("Core/All/" + property + " parameter contains a blank semi-colon delimited substring");
            }
            new SimpleDateFormat(dateFormatParam);
            validFormats[i] = dateFormatParam;
        }
        return validFormats;
    }

    private String loadFormat(String property, String deflt) {
        String format = ConfigContext.getCurrentContextConfig().getProperty(property);
        if (StringUtils.isBlank((String)format)) {
            format = deflt;
        }
        return format;
    }

    private String loadAndValidateFormat(String property, String deflt) {
        String format = this.loadFormat(property, deflt);
        new SimpleDateFormat(format);
        return format;
    }
}

