/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.core.store;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import org.ehcache.spi.service.ServiceProvider;

public final class StoreSupport {
    private StoreSupport() {
    }

    public static <T> T select(Class<T> serviceType, ServiceProvider<? super T> serviceProvider, ToIntFunction<T> ranking) {
        return StoreSupport.trySelect(serviceType, serviceProvider, ranking).orElseThrow(() -> {
            Class<?> enclosingClass = serviceType.getEnclosingClass();
            String type = enclosingClass == null ? serviceType.getSimpleName() : enclosingClass.getSimpleName() + "." + serviceType.getSimpleName();
            StringBuilder sb = new StringBuilder("No " + type + " types found to handle configuration ");
            sb.append(" from ");
            sb.append(serviceProvider.getServicesOfType(serviceType).stream().map(p -> p.getClass().getName()).collect(Collectors.joining(", ", "{", "}")));
            return new IllegalStateException(sb.toString());
        });
    }

    public static <T> Optional<T> trySelect(Class<T> serviceType, ServiceProvider<? super T> serviceProvider, ToIntFunction<T> ranking) {
        Collection providers = serviceProvider.getServicesOfType(serviceType);
        int highRank = 0;
        ArrayList rankingProviders = new ArrayList();
        for (Object provider : providers) {
            int rank = ranking.applyAsInt(provider);
            if (rank > highRank) {
                highRank = rank;
                rankingProviders.clear();
                rankingProviders.add(provider);
                continue;
            }
            if (rank == 0 || rank != highRank) continue;
            rankingProviders.add(provider);
        }
        if (rankingProviders.isEmpty()) {
            return Optional.empty();
        }
        if (rankingProviders.size() > 1) {
            Class<?> enclosingClass = serviceType.getEnclosingClass();
            String type = enclosingClass == null ? serviceType.getSimpleName() : enclosingClass.getSimpleName() + "." + serviceType.getSimpleName();
            StringBuilder sb = new StringBuilder("Multiple " + type + " types found to handle configuration ");
            sb.append(": ");
            sb.append(rankingProviders.stream().map(p -> p.getClass().getName()).collect(Collectors.joining(", ", "{", "}")));
            throw new IllegalStateException(sb.toString());
        }
        return Optional.of(rankingProviders.get(0));
    }
}

