/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kcb.quartz;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import javax.persistence.OptimisticLockException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.util.RiceUtilities;
import org.kuali.rice.kcb.quartz.ProcessingResult;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.UnexpectedRollbackException;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class ConcurrentJob<T> {
    protected final Logger LOG = LogManager.getLogger(this.getClass());
    protected ExecutorService executor = Executors.newSingleThreadExecutor(new KCBThreadFactory());
    protected PlatformTransactionManager txManager;

    public void setExecutorService(ExecutorService executor) {
        this.executor = executor;
    }

    @Required
    public void setTransactionManager(PlatformTransactionManager txManager) {
        this.txManager = txManager;
    }

    protected TransactionTemplate createNewTransaction() {
        TransactionTemplate tt = new TransactionTemplate(this.txManager);
        tt.setPropagationBehavior(3);
        return tt;
    }

    protected abstract Collection<T> takeAvailableWorkItems();

    protected Collection<Collection<T>> groupWorkItems(Collection<T> workItems, ProcessingResult<T> result) {
        ArrayList<Collection<T>> groupedWorkItems = new ArrayList<Collection<T>>(workItems.size());
        for (T workItem : workItems) {
            ArrayList<T> c = new ArrayList<T>(1);
            c.add(workItem);
            groupedWorkItems.add(c);
        }
        return groupedWorkItems;
    }

    protected abstract Collection<T> processWorkItems(Collection<T> var1);

    protected abstract void unlockWorkItem(T var1);

    public ProcessingResult<T> run() {
        Collection items;
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("[" + new Timestamp(System.currentTimeMillis()).toString() + "] STARTING RUN");
        }
        ProcessingResult result = new ProcessingResult();
        try {
            items = (Collection)this.executeInTransaction(new TransactionCallback(){

                public Object doInTransaction(TransactionStatus txStatus) {
                    return ConcurrentJob.this.takeAvailableWorkItems();
                }
            });
        }
        catch (DataAccessException dae) {
            Exception ole = (Exception)RiceUtilities.findExceptionInStack((Throwable)dae, OptimisticLockingFailureException.class);
            if (ole == null) {
                ole = (Exception)RiceUtilities.findExceptionInStack((Throwable)dae, OptimisticLockException.class);
            }
            if (ole != null) {
                this.LOG.info("Contention while taking work items: " + ole.getMessage());
            } else {
                this.LOG.error("Error taking work items", (Throwable)dae);
            }
            return result;
        }
        catch (UnexpectedRollbackException ure) {
            this.LOG.error("UnexpectedRollbackException", (Throwable)ure);
            return result;
        }
        catch (TransactionException te) {
            this.LOG.error("Error occurred obtaining available work items", (Throwable)te);
            result.addFailure(new ProcessingResult.Failure(te));
            return result;
        }
        Collection groupedWorkItems = this.groupWorkItems(items, result);
        Iterator i = groupedWorkItems.iterator();
        ArrayList futures = new ArrayList();
        while (i.hasNext()) {
            final Collection workUnit = i.next();
            this.LOG.info("Processing work unit: " + String.valueOf(workUnit));
            futures.add(this.executor.submit(new Callable(){

                public Object call() throws Exception {
                    ProcessingResult result = new ProcessingResult();
                    try {
                        Collection successes = (Collection)ConcurrentJob.this.executeInTransaction(new TransactionCallback(){

                            public Object doInTransaction(TransactionStatus txStatus) {
                                return ConcurrentJob.this.processWorkItems(workUnit);
                            }
                        });
                        result.addAllSuccesses(successes);
                    }
                    catch (Exception e) {
                        ConcurrentJob.this.LOG.error("Error occurred processing work unit " + String.valueOf(workUnit), (Throwable)e);
                        for (Object workItem : workUnit) {
                            ConcurrentJob.this.LOG.error("Error occurred processing work item " + String.valueOf(workItem), (Throwable)e);
                            result.addFailure(new ProcessingResult.Failure(workItem, e));
                            ConcurrentJob.this.unlockWorkItemAtomically(workItem);
                        }
                    }
                    return result;
                }
            }));
        }
        for (Future future : futures) {
            try {
                ProcessingResult workResult = (ProcessingResult)future.get();
                result.add(workResult);
            }
            catch (Exception e) {
                String message = "Error obtaining work result: " + String.valueOf(e);
                this.LOG.error(message, (Throwable)e);
                result.addFailure(new ProcessingResult.Failure(e, message));
            }
        }
        this.finishProcessing(result);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("[" + new Timestamp(System.currentTimeMillis()).toString() + "] FINISHED RUN - " + String.valueOf(result));
        }
        return result;
    }

    protected void finishProcessing(ProcessingResult<T> result) {
    }

    protected void unlockWorkItemAtomically(final T workItem) {
        try {
            this.executeInTransaction(new TransactionCallback(){

                public Object doInTransaction(TransactionStatus txStatus) {
                    ConcurrentJob.this.LOG.info("Unlocking failed work item: " + String.valueOf(workItem));
                    ConcurrentJob.this.unlockWorkItem(workItem);
                    return null;
                }
            });
        }
        catch (Exception e2) {
            this.LOG.error("Error unlocking failed work item " + String.valueOf(workItem), (Throwable)e2);
        }
    }

    protected <X> X executeInTransaction(TransactionCallback callback) {
        return (X)this.createNewTransaction().execute(callback);
    }

    private static class KCBThreadFactory
    implements ThreadFactory {
        private ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();

        private KCBThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = this.defaultThreadFactory.newThread(runnable);
            thread.setName("KCB-job-" + thread.getName());
            return thread;
        }
    }
}

