/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import net.sourceforge.schemaspy.model.ForeignKeyConstraint;
import net.sourceforge.schemaspy.model.Table;

public class TableOrderer {
    public List<Table> getTablesOrderedByRI(Collection<Table> collection, Collection<ForeignKeyConstraint> collection2) {
        ArrayList<Table> arrayList = new ArrayList<Table>();
        ArrayList<Table> arrayList2 = new ArrayList<Table>();
        ArrayList<Table> arrayList3 = new ArrayList<Table>(collection);
        List<Table> list = new ArrayList<Table>();
        Iterator iterator = arrayList3.iterator();
        while (iterator.hasNext()) {
            Table table = (Table)iterator.next();
            if (table.isRemote()) {
                table.unlinkParents();
                table.unlinkChildren();
                iterator.remove();
                continue;
            }
            if (!table.isLeaf() || !table.isRoot()) continue;
            list.add(table);
            iterator.remove();
        }
        list = TableOrderer.sortTrimmedLevel(list);
        boolean bl = false;
        while (!arrayList3.isEmpty()) {
            ForeignKeyConstraint foreignKeyConstraint;
            Table table3;
            int n = arrayList3.size();
            arrayList2.addAll(0, TableOrderer.trimLeaves(arrayList3));
            arrayList.addAll(TableOrderer.trimRoots(arrayList3));
            if (n != arrayList3.size()) continue;
            if (!bl) {
                for (Table table2 : arrayList3) {
                    table2.removeNonRealForeignKeys();
                }
                bl = true;
                continue;
            }
            boolean bl2 = false;
            for (Table table3 : arrayList3) {
                foreignKeyConstraint = table3.removeSelfReferencingConstraint();
                if (foreignKeyConstraint == null) continue;
                collection2.add(foreignKeyConstraint);
                bl2 = true;
            }
            if (bl2) continue;
            TreeSet<Table> treeSet = new TreeSet<Table>(new Comparator<Table>(this){

                @Override
                public int compare(Table table, Table table2) {
                    int n = Math.abs(table2.getNumChildren() - table2.getNumParents()) - Math.abs(table.getNumChildren() - table.getNumParents());
                    if (n == 0) {
                        n = table.compareTo(table2);
                    }
                    return n;
                }
            });
            treeSet.addAll(arrayList3);
            table3 = (Table)treeSet.iterator().next();
            foreignKeyConstraint = table3.removeAForeignKeyConstraint();
            collection2.add(foreignKeyConstraint);
        }
        ArrayList<Table> arrayList4 = new ArrayList<Table>(arrayList.size() + arrayList2.size());
        arrayList4.addAll(arrayList);
        arrayList = null;
        arrayList4.addAll(arrayList2);
        arrayList2 = null;
        arrayList4.addAll(list);
        return arrayList4;
    }

    private static List<Table> trimRoots(List<Table> list) {
        List<Table> list2 = new ArrayList<Table>();
        Iterator<Table> iterator = list.iterator();
        while (iterator.hasNext()) {
            Table table = iterator.next();
            if (!table.isRoot()) continue;
            list2.add(table);
            iterator.remove();
        }
        list2 = TableOrderer.sortTrimmedLevel(list2);
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            iterator.next().unlinkChildren();
        }
        return list2;
    }

    private static List<Table> trimLeaves(List<Table> list) {
        List<Table> list2 = new ArrayList<Table>();
        Iterator<Table> iterator = list.iterator();
        while (iterator.hasNext()) {
            Table table = iterator.next();
            if (!table.isLeaf()) continue;
            list2.add(table);
            iterator.remove();
        }
        list2 = TableOrderer.sortTrimmedLevel(list2);
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            iterator.next().unlinkParents();
        }
        return list2;
    }

    private static List<Table> sortTrimmedLevel(List<Table> list) {
        final class TrimComparator
        implements Comparator<Table> {
            TrimComparator() {
            }

            @Override
            public int compare(Table table, Table table2) {
                int n = table2.getMaxChildren() - table.getMaxChildren();
                if (n == 0) {
                    n = table.getMaxParents() - table2.getMaxParents();
                }
                if (n == 0) {
                    n = table.compareTo(table2);
                }
                return n;
            }
        }
        TreeSet<Table> treeSet = new TreeSet<Table>(new TrimComparator());
        treeSet.addAll(list);
        return new ArrayList<Table>(treeSet);
    }
}

